/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class BeanUtils {
    private static final Log logger = LogFactory.getLog(BeanUtils.class);
    private static final Set<Class<?>> unknownEditorTypes = Collections.newSetFromMap(new ConcurrentReferenceHashMap(64));

    public static <T> T instantiate(Class<T> clazz2) throws BeanInstantiationException {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface()) {
            throw new BeanInstantiationException(clazz2, "Specified class is an interface");
        }
        try {
            return clazz2.newInstance();
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(clazz2, "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(clazz2, "Is the constructor accessible?", (Throwable)ex);
        }
    }

    public static <T> T instantiateClass(Class<T> clazz2) throws BeanInstantiationException {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface()) {
            throw new BeanInstantiationException(clazz2, "Specified class is an interface");
        }
        try {
            return BeanUtils.instantiateClass(clazz2.getDeclaredConstructor(new Class[0]), new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new BeanInstantiationException(clazz2, "No default constructor found", (Throwable)ex);
        }
    }

    public static <T> T instantiateClass(Class<?> clazz2, Class<T> assignableTo) throws BeanInstantiationException {
        Assert.isAssignable(assignableTo, clazz2);
        return (T)BeanUtils.instantiateClass(clazz2);
    }

    public static <T> T instantiateClass(Constructor<T> ctor, Object ... args2) throws BeanInstantiationException {
        Assert.notNull(ctor, "Constructor must not be null");
        try {
            ReflectionUtils.makeAccessible(ctor);
            return ctor.newInstance(args2);
        }
        catch (InstantiationException ex) {
            throw new BeanInstantiationException(ctor, "Is it an abstract class?", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanInstantiationException(ctor, "Is the constructor accessible?", (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanInstantiationException(ctor, "Illegal arguments for constructor", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new BeanInstantiationException(ctor, "Constructor threw exception", ex.getTargetException());
        }
    }

    public static Method findMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        try {
            return clazz2.getMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException ex) {
            return BeanUtils.findDeclaredMethod(clazz2, methodName, paramTypes2);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        try {
            return clazz2.getDeclaredMethod(methodName, paramTypes2);
        }
        catch (NoSuchMethodException ex) {
            if (clazz2.getSuperclass() != null) {
                return BeanUtils.findDeclaredMethod(clazz2.getSuperclass(), methodName, paramTypes2);
            }
            return null;
        }
    }

    public static Method findMethodWithMinimalParameters(Class<?> clazz2, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.findMethodWithMinimalParameters(clazz2.getMethods(), methodName);
        if (targetMethod == null) {
            targetMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(clazz2, methodName);
        }
        return targetMethod;
    }

    public static Method findDeclaredMethodWithMinimalParameters(Class<?> clazz2, String methodName) throws IllegalArgumentException {
        Method targetMethod = BeanUtils.findMethodWithMinimalParameters(clazz2.getDeclaredMethods(), methodName);
        if (targetMethod == null && clazz2.getSuperclass() != null) {
            targetMethod = BeanUtils.findDeclaredMethodWithMinimalParameters(clazz2.getSuperclass(), methodName);
        }
        return targetMethod;
    }

    public static Method findMethodWithMinimalParameters(Method[] methods2, String methodName) throws IllegalArgumentException {
        Method targetMethod = null;
        int numMethodsFoundWithCurrentMinimumArgs = 0;
        for (Method method : methods2) {
            if (!method.getName().equals(methodName)) continue;
            int numParams = method.getParameterTypes().length;
            if (targetMethod == null || numParams < targetMethod.getParameterTypes().length) {
                targetMethod = method;
                numMethodsFoundWithCurrentMinimumArgs = 1;
                continue;
            }
            if (method.isBridge() || targetMethod.getParameterTypes().length != numParams) continue;
            if (targetMethod.isBridge()) {
                targetMethod = method;
                continue;
            }
            ++numMethodsFoundWithCurrentMinimumArgs;
        }
        if (numMethodsFoundWithCurrentMinimumArgs > 1) {
            throw new IllegalArgumentException("Cannot resolve method '" + methodName + "' to a unique method. Attempted to resolve to overloaded method with the least number of parameters but there were " + numMethodsFoundWithCurrentMinimumArgs + " candidates.");
        }
        return targetMethod;
    }

    public static Method resolveSignature(String signature2, Class<?> clazz2) {
        Assert.hasText(signature2, "'signature' must not be empty");
        Assert.notNull(clazz2, "Class must not be null");
        int startParen = signature2.indexOf(40);
        int endParen = signature2.indexOf(41);
        if (startParen > -1 && endParen == -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature2 + "': expected closing ')' for args list");
        }
        if (startParen == -1 && endParen > -1) {
            throw new IllegalArgumentException("Invalid method signature '" + signature2 + "': expected opening '(' for args list");
        }
        if (startParen == -1 && endParen == -1) {
            return BeanUtils.findMethodWithMinimalParameters(clazz2, signature2);
        }
        String methodName = signature2.substring(0, startParen);
        String[] parameterTypeNames = StringUtils.commaDelimitedListToStringArray(signature2.substring(startParen + 1, endParen));
        Class[] parameterTypes = new Class[parameterTypeNames.length];
        for (int i = 0; i < parameterTypeNames.length; ++i) {
            String parameterTypeName = parameterTypeNames[i].trim();
            try {
                parameterTypes[i] = ClassUtils.forName(parameterTypeName, clazz2.getClassLoader());
                continue;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Invalid method signature: unable to resolve type [" + parameterTypeName + "] for argument " + i + ". Root cause: " + ex);
            }
        }
        return BeanUtils.findMethod(clazz2, methodName, parameterTypes);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz2) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz2);
        return cr.getPropertyDescriptors();
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz2, String propertyName) throws BeansException {
        CachedIntrospectionResults cr = CachedIntrospectionResults.forClass(clazz2);
        return cr.getPropertyDescriptor(propertyName);
    }

    public static PropertyDescriptor findPropertyForMethod(Method method) throws BeansException {
        return BeanUtils.findPropertyForMethod(method, method.getDeclaringClass());
    }

    public static PropertyDescriptor findPropertyForMethod(Method method, Class<?> clazz2) throws BeansException {
        PropertyDescriptor[] pds;
        Assert.notNull(method, "Method must not be null");
        for (PropertyDescriptor pd : pds = BeanUtils.getPropertyDescriptors(clazz2)) {
            if (!method.equals(pd.getReadMethod()) && !method.equals(pd.getWriteMethod())) continue;
            return pd;
        }
        return null;
    }

    public static PropertyEditor findEditorByConvention(Class<?> targetType) {
        if (targetType == null || targetType.isArray() || unknownEditorTypes.contains(targetType)) {
            return null;
        }
        ClassLoader cl = targetType.getClassLoader();
        if (cl == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
                if (cl == null) {
                    return null;
                }
            }
            catch (Throwable ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not access system ClassLoader: " + ex);
                }
                return null;
            }
        }
        String editorName = targetType.getName() + "Editor";
        try {
            Class<?> editorClass = cl.loadClass(editorName);
            if (!PropertyEditor.class.isAssignableFrom(editorClass)) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Editor class [" + editorName + "] does not implement [java.beans.PropertyEditor] interface");
                }
                unknownEditorTypes.add(targetType);
                return null;
            }
            return (PropertyEditor)BeanUtils.instantiateClass(editorClass);
        }
        catch (ClassNotFoundException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("No property editor [" + editorName + "] found for type " + targetType.getName() + " according to 'Editor' suffix convention");
            }
            unknownEditorTypes.add(targetType);
            return null;
        }
    }

    public static Class<?> findPropertyType(String propertyName, Class<?> ... beanClasses) {
        if (beanClasses != null) {
            for (Class<?> beanClass : beanClasses) {
                PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(beanClass, propertyName);
                if (pd == null) continue;
                return pd.getPropertyType();
            }
        }
        return Object.class;
    }

    public static MethodParameter getWriteMethodParameter(PropertyDescriptor pd) {
        if (pd instanceof GenericTypeAwarePropertyDescriptor) {
            return new MethodParameter(((GenericTypeAwarePropertyDescriptor)pd).getWriteMethodParameter());
        }
        return new MethodParameter(pd.getWriteMethod(), 0);
    }

    public static boolean isSimpleProperty(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return BeanUtils.isSimpleValueType(clazz2) || clazz2.isArray() && BeanUtils.isSimpleValueType(clazz2.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz2) {
        return ClassUtils.isPrimitiveOrWrapper(clazz2) || Enum.class.isAssignableFrom(clazz2) || CharSequence.class.isAssignableFrom(clazz2) || Number.class.isAssignableFrom(clazz2) || Date.class.isAssignableFrom(clazz2) || URI.class == clazz2 || URL.class == clazz2 || Locale.class == clazz2 || Class.class == clazz2;
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        BeanUtils.copyProperties(source, target, null, (String[])null);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable) throws BeansException {
        BeanUtils.copyProperties(source, target, editable, (String[])null);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        BeanUtils.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) throws BeansException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(target, "Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value2 = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value2);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

