/*
 * Decompiled with CFR 0.152.
 */
package org.jsr166;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.LongAdder;
import sun.misc.Unsafe;

public class ConcurrentLinkedDeque8<E>
extends AbstractCollection<E>
implements Deque<E>,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    private volatile transient Node<E> head;
    private volatile transient Node<E> tail;
    private final LongAdder size = new LongAdder();
    private static final Node<Object> PREV_TERMINATOR = new Node();
    private static final Node<Object> NEXT_TERMINATOR;
    private static final int HOPS = 2;
    private static final Unsafe UNSAFE;
    private static final long headOffset;
    private static final long tailOffset;

    Node<E> prevTerminator() {
        return PREV_TERMINATOR;
    }

    Node<E> nextTerminator() {
        return NEXT_TERMINATOR;
    }

    private void linkFirst(E e) {
        Node p;
        Node h;
        ConcurrentLinkedDeque8.checkNotNull(e);
        this.size.increment();
        Node newNode = new Node(e);
        block0: while (true) {
            p = h = this.head;
            while (true) {
                Node q;
                if ((q = p.prev) != null) {
                    p = q;
                    q = p.prev;
                    if (q != null) {
                        p = h != (h = this.head) ? h : q;
                        continue;
                    }
                }
                if (p.next == p) continue block0;
                newNode.lazySetNext(p);
                if (p.casPrev(null, newNode)) break block0;
            }
            break;
        }
        if (p != h) {
            this.casHead(h, newNode);
        }
    }

    private Node<E> linkFirstx(E e) {
        Node p;
        Node h;
        ConcurrentLinkedDeque8.checkNotNull(e);
        this.size.increment();
        Node newNode = new Node(e);
        block0: while (true) {
            p = h = this.head;
            while (true) {
                Node q;
                if ((q = p.prev) != null) {
                    p = q;
                    q = p.prev;
                    if (q != null) {
                        p = h != (h = this.head) ? h : q;
                        continue;
                    }
                }
                if (p.next == p) continue block0;
                newNode.lazySetNext(p);
                if (p.casPrev(null, newNode)) break block0;
            }
            break;
        }
        if (p != h) {
            this.casHead(h, newNode);
        }
        return newNode;
    }

    private void linkLast(E e) {
        Node p;
        Node t;
        ConcurrentLinkedDeque8.checkNotNull(e);
        this.size.increment();
        Node newNode = new Node(e);
        block0: while (true) {
            p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block0;
                newNode.lazySetPrev(p);
                if (p.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p != t) {
            this.casTail(t, newNode);
        }
    }

    private void linkLast(Node<E> n) {
        Node p;
        Node t;
        ConcurrentLinkedDeque8.checkNotNull(n);
        this.size.increment();
        block0: while (true) {
            p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block0;
                n.lazySetPrev(p);
                if (p.casNext(null, n)) break block0;
            }
            break;
        }
        if (p != t) {
            this.casTail(t, n);
        }
    }

    private Node<E> linkLastx(E e) {
        Node p;
        Node t;
        ConcurrentLinkedDeque8.checkNotNull(e);
        this.size.increment();
        Node newNode = new Node(e);
        block0: while (true) {
            p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block0;
                newNode.lazySetPrev(p);
                if (p.casNext(null, newNode)) break block0;
            }
            break;
        }
        if (p != t) {
            this.casTail(t, newNode);
        }
        return newNode;
    }

    public boolean unlinkx(Node<E> x) {
        assert (x != null);
        Object item = x.item;
        if (item != null && x.casItem(item, null)) {
            this.unlink(x);
            return true;
        }
        return false;
    }

    void unlink(Node<E> x) {
        Node prev = x.prev;
        Node next2 = x.next;
        this.size.decrement();
        if (prev == null) {
            this.unlinkFirst(x, next2);
        } else if (next2 == null) {
            this.unlinkLast(x, prev);
        } else {
            boolean isLast;
            Node activeSucc;
            Node q;
            boolean isFirst;
            Node activePred;
            int hops = 1;
            Node p = prev;
            while (true) {
                if (p.item != null) {
                    activePred = p;
                    isFirst = false;
                    break;
                }
                q = p.prev;
                if (q == null) {
                    if (p.next == p) {
                        return;
                    }
                    activePred = p;
                    isFirst = true;
                    break;
                }
                if (p == q) {
                    return;
                }
                p = q;
                ++hops;
            }
            p = next2;
            while (true) {
                if (p.item != null) {
                    activeSucc = p;
                    isLast = false;
                    break;
                }
                q = p.next;
                if (q == null) {
                    if (p.prev == p) {
                        return;
                    }
                    activeSucc = p;
                    isLast = true;
                    break;
                }
                if (p == q) {
                    return;
                }
                p = q;
                ++hops;
            }
            if (hops < 2 && isFirst | isLast) {
                return;
            }
            this.skipDeletedSuccessors(activePred);
            this.skipDeletedPredecessors(activeSucc);
            if (isFirst | isLast && activePred.next == activeSucc && activeSucc.prev == activePred && (isFirst ? activePred.prev == null : activePred.item != null) && (isLast ? activeSucc.next == null : activeSucc.item != null)) {
                this.updateHead();
                this.updateTail();
                x.lazySetPrev(isFirst ? this.prevTerminator() : x);
                x.lazySetNext(isLast ? this.nextTerminator() : x);
            }
        }
    }

    private void unlinkFirst(Node<E> first, Node<E> next2) {
        Node<E> o = null;
        Node<E> p = next2;
        while (true) {
            Node q;
            if (p.item != null || (q = p.next) == null) {
                if (o != null && p.prev != p && first.casNext(next2, p)) {
                    this.skipDeletedPredecessors(p);
                    if (first.prev == null && (p.next == null || p.item != null) && p.prev == first) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetNext(o);
                        o.lazySetPrev(this.prevTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    private void unlinkLast(Node<E> last2, Node<E> prev) {
        Node<E> o = null;
        Node<E> p = prev;
        while (true) {
            Node q;
            if (p.item != null || (q = p.prev) == null) {
                if (o != null && p.next != p && last2.casPrev(prev, p)) {
                    this.skipDeletedSuccessors(p);
                    if (last2.next == null && (p.prev == null || p.item != null) && p.next == last2) {
                        this.updateHead();
                        this.updateTail();
                        o.lazySetPrev(o);
                        o.lazySetNext(this.nextTerminator());
                    }
                }
                return;
            }
            if (p == q) {
                return;
            }
            o = p;
            p = q;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateHead() {
        block0: while (true) {
            h = this.head;
            if (h.item != null || (p = h.prev) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.prev) == null) break block4;
                        p = q;
                        q = p.prev;
                        if (q != null) break block5;
                    }
                    if (!this.casHead(h, p)) continue block0;
                    return;
                }
                if (h == this.head) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateTail() {
        block0: while (true) {
            t = this.tail;
            if (t.item != null || (p = t.next) == null) break;
            while (true) {
                block5: {
                    block4: {
                        if ((q = p.next) == null) break block4;
                        p = q;
                        q = p.next;
                        if (q != null) break block5;
                    }
                    if (!this.casTail(t, p)) continue block0;
                    return;
                }
                if (t == this.tail) ** break;
                continue block0;
                p = q;
            }
            break;
        }
    }

    private void skipDeletedPredecessors(Node<E> x) {
        block0: do {
            Node prev;
            Node p = prev = x.prev;
            while (p.item == null) {
                Node q = p.prev;
                if (q == null) {
                    if (p.next != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (prev != p && !x.casPrev(prev, p)) continue;
            return;
        } while (x.item != null || x.next == null);
    }

    private void skipDeletedSuccessors(Node<E> x) {
        block0: do {
            Node next2;
            Node p = next2 = x.next;
            while (p.item == null) {
                Node q = p.next;
                if (q == null) {
                    if (p.prev != p) break;
                    continue block0;
                }
                if (p == q) continue block0;
                p = q;
            }
            if (next2 != p && !x.casNext(next2, p)) continue;
            return;
        } while (x.item != null || x.prev == null);
    }

    final Node<E> succ(Node<E> p) {
        Node q = p.next;
        return p == q ? this.first() : q;
    }

    final Node<E> pred(Node<E> p) {
        Node q = p.prev;
        return p == q ? this.last() : q;
    }

    Node<E> first() {
        Node<E> h;
        Node<E> p;
        block0: do {
            Node q;
            p = h = this.head;
            while ((q = p.prev) != null) {
                p = q;
                q = p.prev;
                if (q == null) continue block0;
                p = h != (h = this.head) ? h : q;
            }
        } while (p != h && !this.casHead(h, p));
        return p;
    }

    Node<E> last() {
        Node<E> t;
        Node<E> p;
        block0: do {
            Node q;
            p = t = this.tail;
            while ((q = p.next) != null) {
                p = q;
                q = p.next;
                if (q == null) continue block0;
                p = t != (t = this.tail) ? t : q;
            }
        } while (p != t && !this.casTail(t, p));
        return p;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private E screenNullResult(E v) {
        if (v == null) {
            throw new NoSuchElementException();
        }
        return v;
    }

    private ArrayList<E> toArrayList() {
        ArrayList list2 = new ArrayList();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                list2.add(item);
            }
            p = this.succ(p);
        }
        return list2;
    }

    public ConcurrentLinkedDeque8() {
        this.tail = new Node<Object>(null);
        this.head = this.tail;
    }

    public ConcurrentLinkedDeque8(Collection<? extends E> c) {
        Node<E> h = null;
        Node<E> t = null;
        for (E e : c) {
            ConcurrentLinkedDeque8.checkNotNull(e);
            Node<E> newNode = new Node<E>(e);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private void initHeadTail(Node<E> h, Node<E> t) {
        if (h == t) {
            if (h == null) {
                t = new Node<Object>(null);
                h = t;
            } else {
                Node<Object> newNode = new Node<Object>(null);
                t.lazySetNext(newNode);
                newNode.lazySetPrev(t);
                t = newNode;
            }
        }
        this.head = h;
        this.tail = t;
    }

    @Override
    public void addFirst(E e) {
        this.linkFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.linkLast(e);
    }

    public Node<E> addLastx(E e) {
        return this.linkLastx(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.linkFirst(e);
        return true;
    }

    public Node<E> offerFirstx(E e) {
        return this.linkFirstx(e);
    }

    @Override
    public boolean offerLast(E e) {
        this.linkLast(e);
        return true;
    }

    public Node<E> offerLastx(E e) {
        return this.linkLastx(e);
    }

    @Override
    public E peekFirst() {
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return item;
            }
            p = this.succ(p);
        }
        return null;
    }

    public Node<E> peekFirstx() {
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return p;
            }
            p = this.succ(p);
        }
        return null;
    }

    @Override
    public E peekLast() {
        Node<E> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                return item;
            }
            p = this.pred(p);
        }
        return null;
    }

    @Override
    public E getFirst() {
        return this.screenNullResult(this.peekFirst());
    }

    @Override
    public E getLast() {
        return this.screenNullResult(this.peekLast());
    }

    @Override
    public E pollFirst() {
        Node<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                return item;
            }
            p = this.succ(p);
        }
        return null;
    }

    @Override
    public E pollLast() {
        Node<Object> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null && p.casItem(item, null)) {
                this.unlink(p);
                return item;
            }
            p = this.pred(p);
        }
        return null;
    }

    @Override
    public E removeFirst() {
        return this.screenNullResult(this.pollFirst());
    }

    @Override
    public E removeLast() {
        return this.screenNullResult(this.pollLast());
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public boolean add(E e) {
        return this.offerLast(e);
    }

    public Node<E> addx(E e) {
        return this.offerLastx(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    public Node<E> peekx() {
        return this.peekFirstx();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        ConcurrentLinkedDeque8.checkNotNull(o);
        Node<Object> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                this.unlink(p);
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        ConcurrentLinkedDeque8.checkNotNull(o);
        Node<Object> p = this.last();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                this.unlink(p);
                return true;
            }
            p = this.pred(p);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null && o.equals(item)) {
                return true;
            }
            p = this.succ(p);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.peekFirst() == null;
    }

    public boolean isEmptyx() {
        return this.sizex() == 0;
    }

    @Override
    public int size() {
        int count2 = 0;
        Node<E> p = this.first();
        while (p != null && (p.item == null || ++count2 != Integer.MAX_VALUE)) {
            p = this.succ(p);
        }
        return count2;
    }

    public int sizex() {
        return this.size.intValue();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Node t;
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Node beginningOfTheEnd = null;
        Node last2 = null;
        int s2 = 0;
        for (E e : c) {
            ConcurrentLinkedDeque8.checkNotNull(e);
            Node newNode = new Node(e);
            if (beginningOfTheEnd == null) {
                beginningOfTheEnd = last2 = newNode;
                ++s2;
                continue;
            }
            last2.lazySetNext(newNode);
            newNode.lazySetPrev(last2);
            last2 = newNode;
            ++s2;
        }
        if (beginningOfTheEnd == null) {
            return false;
        }
        this.size.add(s2);
        block1: while (true) {
            Node p = t = this.tail;
            while (true) {
                Node q;
                if ((q = p.next) != null) {
                    p = q;
                    q = p.next;
                    if (q != null) {
                        p = t != (t = this.tail) ? t : q;
                        continue;
                    }
                }
                if (p.prev == p) continue block1;
                beginningOfTheEnd.lazySetPrev(p);
                if (p.casNext(null, beginningOfTheEnd)) break block1;
            }
            break;
        }
        if (!this.casTail(t, last2)) {
            t = this.tail;
            if (last2.next == null) {
                this.casTail(t, last2);
            }
        }
        return true;
    }

    @Override
    public void clear() {
        while (this.pollFirst() != null) {
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArrayList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArrayList().toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            Object item = p.item;
            if (item != null) {
                s2.writeObject(item);
            }
            p = this.succ(p);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        Object item;
        s2.defaultReadObject();
        Node<Object> h = null;
        Node<Object> t = null;
        while ((item = s2.readObject()) != null) {
            Node<Object> newNode = new Node<Object>(item);
            if (h == null) {
                h = t = newNode;
                continue;
            }
            t.lazySetNext(newNode);
            newNode.lazySetPrev(t);
            t = newNode;
        }
        this.initHeadTail(h, t);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, headOffset, cmp, val);
    }

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return UNSAFE.compareAndSwapObject(this, tailOffset, cmp, val);
    }

    static Unsafe unsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException ignored) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                        f2.setAccessible(true);
                        return (Unsafe)f2.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics.", e.getCause());
            }
        }
    }

    static {
        ConcurrentLinkedDeque8.PREV_TERMINATOR.next = PREV_TERMINATOR;
        NEXT_TERMINATOR = new Node();
        ConcurrentLinkedDeque8.NEXT_TERMINATOR.prev = NEXT_TERMINATOR;
        try {
            UNSAFE = ConcurrentLinkedDeque8.unsafe();
            Class<ConcurrentLinkedDeque8> k = ConcurrentLinkedDeque8.class;
            headOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("head"));
            tailOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("tail"));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque8.this.last();
        }

        @Override
        Node<E> nextNode(Node<E> p) {
            return ConcurrentLinkedDeque8.this.pred(p);
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> startNode() {
            return ConcurrentLinkedDeque8.this.first();
        }

        @Override
        Node<E> nextNode(Node<E> p) {
            return ConcurrentLinkedDeque8.this.succ(p);
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        abstract Node<E> startNode();

        abstract Node<E> nextNode(Node<E> var1);

        AbstractItr() {
            this.advance();
        }

        private void advance() {
            Node p;
            this.lastRet = this.nextNode;
            Node node = p = this.nextNode == null ? this.startNode() : this.nextNode(this.nextNode);
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    break;
                }
                Object item = p.item;
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    break;
                }
                p = this.nextNode(p);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextItem != null;
        }

        @Override
        public E next() {
            Object item = this.nextItem;
            if (item == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return item;
        }

        @Override
        public void remove() {
            Node l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.item = null;
            ConcurrentLinkedDeque8.this.unlink(l);
            this.lastRet = null;
        }
    }

    public static final class Node<E> {
        volatile Node<E> prev;
        volatile E item;
        volatile Node<E> next;
        private static final Unsafe UNSAFE;
        private static final long prevOffset;
        private static final long itemOffset;
        private static final long nextOffset;

        Node() {
        }

        Node(E item) {
            UNSAFE.putObject(this, itemOffset, item);
        }

        public E item() {
            return this.item;
        }

        boolean casItem(E cmp, E val) {
            return UNSAFE.compareAndSwapObject(this, itemOffset, cmp, val);
        }

        void lazySetNext(Node<E> val) {
            UNSAFE.putOrderedObject(this, nextOffset, val);
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, nextOffset, cmp, val);
        }

        void lazySetPrev(Node<E> val) {
            UNSAFE.putOrderedObject(this, prevOffset, val);
        }

        boolean casPrev(Node<E> cmp, Node<E> val) {
            return UNSAFE.compareAndSwapObject(this, prevOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = ConcurrentLinkedDeque8.unsafe();
                Class<Node> k = Node.class;
                prevOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("prev"));
                itemOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("item"));
                nextOffset = UNSAFE.objectFieldOffset(k.getDeclaredField("next"));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

