/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueFloat
extends Value {
    public static final int ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int PRECISION = 7;
    static final int DISPLAY_SIZE = 15;
    private static final ValueFloat ZERO = new ValueFloat(0.0f);
    private static final ValueFloat ONE = new ValueFloat(1.0f);
    private final float value;

    private ValueFloat(float f2) {
        this.value = f2;
    }

    @Override
    public Value add(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value + valueFloat.value);
    }

    @Override
    public Value subtract(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value - valueFloat.value);
    }

    @Override
    public Value negate() {
        return ValueFloat.get(-this.value);
    }

    @Override
    public Value multiply(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return ValueFloat.get(this.value * valueFloat.value);
    }

    @Override
    public Value divide(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        if ((double)valueFloat.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value / valueFloat.value);
    }

    @Override
    public Value modulus(Value value2) {
        ValueFloat valueFloat = (ValueFloat)value2;
        if (valueFloat.value == 0.0f) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueFloat.get(this.value % valueFloat.value);
    }

    @Override
    public String getSQL() {
        if (this.value == Float.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        return this.getString();
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    protected int compareSecure(Value value2, CompareMode compareMode) {
        ValueFloat valueFloat = (ValueFloat)value2;
        return Float.compare(this.value, valueFloat.value);
    }

    @Override
    public int getSignum() {
        return this.value == 0.0f ? 0 : (this.value < 0.0f ? -1 : 1);
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 7L;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int hashCode() {
        long l = Float.floatToIntBits(this.value);
        return (int)(l ^ l >> 32);
    }

    @Override
    public Object getObject() {
        return Float.valueOf(this.value);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setFloat(n, this.value);
    }

    public static ValueFloat get(float f2) {
        if (f2 == 1.0f) {
            return ONE;
        }
        if (f2 == 0.0f) {
            return ZERO;
        }
        return (ValueFloat)Value.cache(new ValueFloat(f2));
    }

    @Override
    public int getDisplaySize() {
        return 15;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueFloat)) {
            return false;
        }
        return this.compareSecure((ValueFloat)object, null) == 0;
    }
}

