/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.h2.engine.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Class<?> componentType;
    private final Value[] values;
    private int hash;

    private ValueArray(Class<?> clazz2, Value[] valueArray) {
        this.componentType = clazz2;
        this.values = valueArray;
    }

    private ValueArray(Value[] valueArray) {
        this(Object.class, valueArray);
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public static ValueArray get(Class<?> clazz2, Value[] valueArray) {
        return new ValueArray(clazz2, valueArray);
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = 1;
        for (Value value2 : this.values) {
            n = n * 31 + value2.hashCode();
        }
        this.hash = n;
        return n;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int getType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public long getPrecision() {
        long l = 0L;
        for (Value value2 : this.values) {
            l += value2.getPrecision();
        }
        return l;
    }

    @Override
    public String getString() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value2 : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value2.getString());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    protected int compareSecure(Value value2, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value2;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value3 = this.values[i];
            Value value4 = valueArray.values[i];
            int n4 = value3.compareTo(value4, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return Integer.compare(n, n2);
    }

    @Override
    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Value value2 = this.values[i];
            objectArray[i] = !SysProperties.OLD_RESULT_SET_GET_OBJECT && ((n2 = value2.getType()) == 2 || n2 == 3) ? Integer.valueOf(value2.getInt()) : value2.getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value2 : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value2.getSQL());
        }
        if (this.values.length == 1) {
            statementBuilder.append(',');
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getTraceSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value2 : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value2 == null ? "null" : value2.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public int getDisplaySize() {
        long l = 0L;
        for (Value value2 : this.values) {
            l += (long)value2.getDisplaySize();
        }
        return MathUtils.convertLongToInt(l);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMemory() {
        int n = 32;
        for (Value value2 : this.values) {
            n += value2.getMemory() + 8;
        }
        return n;
    }

    @Override
    public Value convertPrecision(long l, boolean bl) {
        if (!bl) {
            return this;
        }
        ArrayList<Value> arrayList = New.arrayList();
        for (Value value2 : this.values) {
            if ((l -= Math.max(1L, (value2 = value2.convertPrecision(l, true)).getPrecision())) < 0L) break;
            arrayList.add(value2);
        }
        return ValueArray.get(arrayList.toArray(new Value[0]));
    }
}

