/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Locale;
import org.h2.message.DbException;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;

public class CompareModeIcu4J
extends CompareMode {
    private final Comparator<String> collator;

    protected CompareModeIcu4J(String string2, int n, boolean bl) {
        super(string2, n, bl);
        this.collator = CompareModeIcu4J.getIcu4jCollator(string2, n);
    }

    @Override
    public int compareString(String string2, String string3, boolean bl) {
        if (bl) {
            string2 = string2.toUpperCase();
            string3 = string3.toUpperCase();
        }
        return this.collator.compare(string2, string3);
    }

    @Override
    public boolean equalsChars(String string2, int n, String string3, int n2, boolean bl) {
        return this.compareString(string2.substring(n, n + 1), string3.substring(n2, n2 + 1), bl) == 0;
    }

    private static Comparator<String> getIcu4jCollator(String string2, int n) {
        try {
            String string3;
            String string4;
            Locale locale2;
            int n2;
            Comparator comparator = null;
            Class clazz2 = JdbcUtils.loadUserClass("com.ibm.icu.text.Collator");
            Method method = clazz2.getMethod("getInstance", Locale.class);
            if (string2.length() == 2) {
                Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string2), "");
                if (CompareModeIcu4J.compareLocaleNames((Locale)localeArray, string2)) {
                    comparator = (Comparator)method.invoke(null, new Object[]{localeArray});
                }
            } else if (string2.length() == 5 && (n2 = string2.indexOf(95)) >= 0 && CompareModeIcu4J.compareLocaleNames(locale2 = new Locale(string4 = StringUtils.toLowerEnglish(string2.substring(0, n2)), string3 = string2.substring(n2 + 1)), string2)) {
                comparator = (Comparator)method.invoke(null, locale2);
            }
            if (comparator == null) {
                for (Locale locale2 : (Locale[])clazz2.getMethod("getAvailableLocales", new Class[0]).invoke(null, new Object[0])) {
                    if (!CompareModeIcu4J.compareLocaleNames(locale2, string2)) continue;
                    comparator = (Comparator)method.invoke(null, locale2);
                    break;
                }
            }
            if (comparator == null) {
                throw DbException.getInvalidValueException("collator", string2);
            }
            clazz2.getMethod("setStrength", Integer.TYPE).invoke((Object)comparator, n);
            return comparator;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }
}

