/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Locale;
import java.util.Objects;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CharsetCollator;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;

public class CompareMode {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;

    protected CompareMode(String string2, int n, boolean bl) {
        this.name = string2;
        this.strength = n;
        this.binaryUnsigned = bl;
    }

    public static CompareMode getInstance(String string2, int n) {
        return CompareMode.getInstance(string2, n, SysProperties.SORT_BINARY_UNSIGNED);
    }

    public static CompareMode getInstance(String string2, int n, boolean bl) {
        CompareMode compareMode = lastUsed;
        if (compareMode != null && Objects.equals(compareMode.name, string2) && compareMode.strength == n && compareMode.binaryUnsigned == bl) {
            return compareMode;
        }
        if (string2 == null || string2.equals(OFF)) {
            compareMode = new CompareMode(string2, n, bl);
        } else {
            boolean bl2;
            if (string2.startsWith(ICU4J)) {
                bl2 = true;
                string2 = string2.substring(ICU4J.length());
            } else if (string2.startsWith(DEFAULT)) {
                bl2 = false;
                string2 = string2.substring(DEFAULT.length());
            } else {
                bl2 = CAN_USE_ICU4J;
            }
            compareMode = bl2 ? new CompareModeIcu4J(string2, n, bl) : new CompareModeDefault(string2, n, bl);
        }
        lastUsed = compareMode;
        return compareMode;
    }

    public boolean equalsChars(String string2, int n, String string3, int n2, boolean bl) {
        char c = string2.charAt(n);
        char c2 = string3.charAt(n2);
        if (bl) {
            c = Character.toUpperCase(c);
            c2 = Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public int compareString(String string2, String string3, boolean bl) {
        if (bl) {
            return string2.compareToIgnoreCase(string3);
        }
        return string2.compareTo(string3);
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string2 = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string2 = StringUtils.toUpperEnglish(string2.trim().replace(' ', '_'));
        return string2;
    }

    static boolean compareLocaleNames(Locale locale, String string2) {
        return string2.equalsIgnoreCase(locale.toString()) || string2.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string2) {
        String string3;
        String string4;
        Locale locale2;
        int n;
        Collator collator = null;
        if (string2.startsWith(ICU4J)) {
            string2 = string2.substring(ICU4J.length());
        } else if (string2.startsWith(DEFAULT)) {
            string2 = string2.substring(DEFAULT.length());
        } else if (string2.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(string2.substring(CHARSET.length())));
        }
        if (string2.length() == 2) {
            Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string2), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string2)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (string2.length() == 5 && (n = string2.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(string4 = StringUtils.toLowerEnglish(string2.substring(0, n)), string3 = string2.substring(n + 1)), string2)) {
            collator = Collator.getInstance(locale2);
        }
        if (collator == null) {
            for (Locale locale2 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale2, string2)) continue;
                collator = Collator.getInstance(locale2);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompareMode)) {
            return false;
        }
        CompareMode compareMode = (CompareMode)object;
        if (!this.getName().equals(compareMode.getName())) {
            return false;
        }
        if (this.strength != compareMode.strength) {
            return false;
        }
        return this.binaryUnsigned == compareMode.binaryUnsigned;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.strength ^ (this.binaryUnsigned ? -1 : 0);
    }

    static {
        boolean bl = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = bl;
    }
}

