/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import org.h2.message.DbException;
import org.h2.util.HashBase;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap<V>
extends HashBase {
    private Value[] keys;
    private V[] values;

    public static <T> ValueHashMap<T> newInstance() {
        return new ValueHashMap();
    }

    @Override
    protected void reset(int n) {
        super.reset(n);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    @Override
    protected void rehash(int n) {
        Value[] valueArray = this.keys;
        V[] VArray = this.values;
        this.reset(n);
        int n2 = valueArray.length;
        for (int i = 0; i < n2; ++i) {
            Value value2 = valueArray[i];
            if (value2 == null || value2 == ValueNull.DELETED) continue;
            this.internalPut(value2, VArray[i]);
        }
    }

    private int getIndex(Value value2) {
        return value2.hashCode() & this.mask;
    }

    public void put(Value value2, V v) {
        this.checkSizePut();
        this.internalPut(value2, v);
    }

    private void internalPut(Value value2, V v) {
        int n = this.getIndex(value2);
        int n2 = 1;
        int n3 = -1;
        do {
            Value value3;
            if ((value3 = this.keys[n]) == null) {
                if (n3 >= 0) {
                    n = n3;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n] = value2;
                this.values[n] = v;
                return;
            }
            if (value3 == ValueNull.DELETED) {
                if (n3 < 0) {
                    n3 = n;
                }
            } else if (value3.equals(value2)) {
                this.values[n] = v;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        DbException.throwInternalError("hashmap is full");
    }

    public void remove(Value value2) {
        this.checkSizeRemove();
        int n = this.getIndex(value2);
        int n2 = 1;
        do {
            Value value3;
            if ((value3 = this.keys[n]) == null) {
                return;
            }
            if (value3 != ValueNull.DELETED && value3.equals(value2)) {
                this.keys[n] = ValueNull.DELETED;
                this.values[n] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
    }

    public V get(Value value2) {
        int n = this.getIndex(value2);
        int n2 = 1;
        do {
            Value value3;
            if ((value3 = this.keys[n]) == null) {
                return null;
            }
            if (value3 != ValueNull.DELETED && value3.equals(value2)) {
                return this.values[n];
            }
            n = n + n2++ & this.mask;
        } while (n2 <= this.len);
        return null;
    }

    public ArrayList<Value> keys() {
        ArrayList<Value> arrayList = new ArrayList<Value>(this.size);
        for (Value value2 : this.keys) {
            if (value2 == null || value2 == ValueNull.DELETED) continue;
            arrayList.add(value2);
        }
        return arrayList;
    }

    public ArrayList<V> values() {
        ArrayList<V> arrayList = new ArrayList<V>(this.size);
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            Value value2 = this.keys[i];
            if (value2 == null || value2 == ValueNull.DELETED) continue;
            arrayList.add(this.values[i]);
        }
        return arrayList;
    }
}

