/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Task;
import org.h2.util.Utils;

public class SourceCompiler {
    static final JavaCompiler JAVA_COMPILER;
    private static final Class<?> JAVAC_SUN;
    private static final String COMPILE_DIR;
    final HashMap<String, String> sources = new HashMap();
    final HashMap<String, Class<?>> compiled = new HashMap();
    final Map<String, CompiledScript> compiledScripts = new HashMap<String, CompiledScript>();
    boolean useJavaSystemCompiler = SysProperties.JAVA_SYSTEM_COMPILER;

    public void setSource(String string2, String string3) {
        this.sources.put(string2, string3);
        this.compiled.clear();
    }

    public void setJavaSystemCompiler(boolean bl) {
        this.useJavaSystemCompiler = bl;
    }

    public Class<?> getClass(String string2) throws ClassNotFoundException {
        Class<?> clazz2 = this.compiled.get(string2);
        if (clazz2 != null) {
            return clazz2;
        }
        String string3 = this.sources.get(string2);
        if (SourceCompiler.isGroovySource(string3)) {
            Class<?> clazz3 = GroovyCompiler.parseClass(string3, string2);
            this.compiled.put(string2, clazz3);
            return clazz3;
        }
        ClassLoader classLoader = new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String string2) throws ClassNotFoundException {
                Class<?> clazz2 = SourceCompiler.this.compiled.get(string2);
                if (clazz2 == null) {
                    byte[] byArray;
                    String string3;
                    String string4 = SourceCompiler.this.sources.get(string2);
                    String string5 = null;
                    int n = string2.lastIndexOf(46);
                    if (n >= 0) {
                        string5 = string2.substring(0, n);
                        string3 = string2.substring(n + 1);
                    } else {
                        string3 = string2;
                    }
                    String string6 = SourceCompiler.getCompleteSourceCode(string5, string3, string4);
                    clazz2 = JAVA_COMPILER != null && SourceCompiler.this.useJavaSystemCompiler ? SourceCompiler.this.javaxToolsJavac(string5, string3, string6) : ((byArray = SourceCompiler.this.javacCompile(string5, string3, string6)) == null ? this.findSystemClass(string2) : this.defineClass(string2, byArray, 0, byArray.length));
                    SourceCompiler.this.compiled.put(string2, clazz2);
                }
                return clazz2;
            }
        };
        return classLoader.loadClass(string2);
    }

    private static boolean isGroovySource(String string2) {
        return string2.startsWith("//groovy") || string2.startsWith("@groovy");
    }

    private static boolean isJavascriptSource(String string2) {
        return string2.startsWith("//javascript");
    }

    private static boolean isRubySource(String string2) {
        return string2.startsWith("#ruby");
    }

    public static boolean isJavaxScriptSource(String string2) {
        return SourceCompiler.isJavascriptSource(string2) || SourceCompiler.isRubySource(string2);
    }

    public CompiledScript getCompiledScript(String string2) throws ScriptException {
        CompiledScript compiledScript = this.compiledScripts.get(string2);
        if (compiledScript == null) {
            String string3;
            String string4 = this.sources.get(string2);
            if (SourceCompiler.isJavascriptSource(string4)) {
                string3 = "javascript";
            } else if (SourceCompiler.isRubySource(string4)) {
                string3 = "ruby";
            } else {
                throw new IllegalStateException("Unknown language for " + string4);
            }
            Compilable compilable = (Compilable)((Object)new ScriptEngineManager().getEngineByName(string3));
            compiledScript = compilable.compile(string4);
            this.compiledScripts.put(string2, compiledScript);
        }
        return compiledScript;
    }

    public Method getMethod(String string2) throws ClassNotFoundException {
        Method[] methodArray;
        Class<?> clazz2 = this.getClass(string2);
        for (Method method : methodArray = clazz2.getDeclaredMethods()) {
            String string3;
            int n = method.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || (string3 = method.getName()).startsWith("_") || method.getName().equals("main")) continue;
            return method;
        }
        return null;
    }

    byte[] javacCompile(String string2, String string3, String string4) {
        File file = new File(COMPILE_DIR);
        if (string2 != null) {
            file = new File(file, string2.replace('.', '/'));
            FileUtils.createDirectories(file.getAbsolutePath());
        }
        File file2 = new File(file, string3 + ".java");
        File file3 = new File(file, string3 + ".class");
        try {
            OutputStream outputStream = FileUtils.newOutputStream(file2.getAbsolutePath(), false);
            Writer writer = IOUtils.getBufferedWriter(outputStream);
            file3.delete();
            writer.write(string4);
            writer.close();
            if (JAVAC_SUN != null) {
                SourceCompiler.javacSun(file2);
            } else {
                SourceCompiler.javacProcess(file2);
            }
            byte[] byArray = new byte[(int)file3.length()];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file3));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            file2.delete();
            file3.delete();
        }
    }

    static String getCompleteSourceCode(String string2, String string3, String string4) {
        if (string4.startsWith("package ")) {
            return string4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append("package ").append(string2).append(";\n");
        }
        int n = string4.indexOf("@CODE");
        String string5 = "import java.util.*;\nimport java.math.*;\nimport java.sql.*;\n";
        if (n >= 0) {
            string5 = string4.substring(0, n);
            string4 = string4.substring("@CODE".length() + n);
        }
        stringBuilder.append(string5);
        stringBuilder.append("public class ").append(string3).append(" {\n    public static ").append(string4).append("\n}\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Class<?> javaxToolsJavac(String string2, String string3, String string4) {
        String string5 = string2 + "." + string3;
        StringWriter stringWriter = new StringWriter();
        try (ClassFileManager classFileManager = new ClassFileManager(JAVA_COMPILER.getStandardFileManager(null, null, null));){
            ArrayList<StringJavaFileObject> arrayList = new ArrayList<StringJavaFileObject>();
            arrayList.add(new StringJavaFileObject(string5, string4));
            Object object = JAVA_COMPILER;
            synchronized (object) {
                JAVA_COMPILER.getTask(stringWriter, classFileManager, null, null, null, arrayList).call();
            }
            object = stringWriter.toString();
            SourceCompiler.handleSyntaxError((String)object);
            Class<?> clazz2 = classFileManager.getClassLoader(null).loadClass(string5);
            return clazz2;
        }
        catch (IOException | ClassNotFoundException exception) {
            throw DbException.convert(exception);
        }
    }

    private static void javacProcess(File file) {
        SourceCompiler.exec("javac", "-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", file.getAbsolutePath());
    }

    private static int exec(String ... stringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.environment().remove("JAVA_TOOL_OPTIONS");
            processBuilder.command(stringArray);
            Process process2 = processBuilder.start();
            SourceCompiler.copyInThread(process2.getInputStream(), byteArrayOutputStream);
            SourceCompiler.copyInThread(process2.getErrorStream(), byteArrayOutputStream);
            process2.waitFor();
            String string2 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            SourceCompiler.handleSyntaxError(string2);
            return process2.exitValue();
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    private static void copyInThread(final InputStream inputStream, final OutputStream outputStream) {
        new Task(){

            @Override
            public void call() throws IOException {
                IOUtils.copy(inputStream, outputStream);
            }
        }.execute();
    }

    private static synchronized void javacSun(File file) {
        PrintStream printStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
        try {
            System.setErr(printStream2);
            Method method = JAVAC_SUN.getMethod("compile", String[].class);
            Object obj = JAVAC_SUN.newInstance();
            method.invoke(obj, new Object[]{new String[]{"-sourcepath", COMPILE_DIR, "-d", COMPILE_DIR, "-encoding", "UTF-8", file.getAbsolutePath()}});
            String string2 = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            SourceCompiler.handleSyntaxError(string2);
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
        finally {
            System.setErr(printStream);
        }
    }

    private static void handleSyntaxError(String string2) {
        boolean bl = false;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string2));
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.endsWith("warning") || string3.startsWith("Note:") || string3.startsWith("warning:")) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            string2 = StringUtils.replaceAll(string2, COMPILE_DIR, "");
            throw DbException.get(42000, string2);
        }
    }

    static {
        Class<?> clazz2;
        JavaCompiler javaCompiler;
        COMPILE_DIR = Utils.getProperty("java.io.tmpdir", ".");
        try {
            javaCompiler = ToolProvider.getSystemJavaCompiler();
        }
        catch (Exception exception) {
            javaCompiler = null;
        }
        JAVA_COMPILER = javaCompiler;
        try {
            clazz2 = Class.forName("com.sun.tools.javac.Main");
        }
        catch (Exception exception) {
            clazz2 = null;
        }
        JAVAC_SUN = clazz2;
    }

    static class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        JavaClassObject classObject;

        public ClassFileManager(StandardJavaFileManager standardJavaFileManager) {
            super(standardJavaFileManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String string2) throws ClassNotFoundException {
                    byte[] byArray = ClassFileManager.this.classObject.getBytes();
                    return super.defineClass(string2, byArray, 0, byArray.length);
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string2, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
            this.classObject = new JavaClassObject(string2, kind);
            return this.classObject;
        }
    }

    static class JavaClassObject
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();

        public JavaClassObject(String string2, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + string2.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.out.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.out;
        }
    }

    static class StringJavaFileObject
    extends SimpleJavaFileObject {
        private final String sourceCode;

        public StringJavaFileObject(String string2, String string3) {
            super(URI.create("string:///" + string2.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = string3;
        }

        @Override
        public CharSequence getCharContent(boolean bl) {
            return this.sourceCode;
        }
    }

    private static final class GroovyCompiler {
        private static final Object LOADER;
        private static final Throwable INIT_FAIL_EXCEPTION;

        private GroovyCompiler() {
        }

        public static Class<?> parseClass(String string2, String string3) {
            if (LOADER == null) {
                throw new RuntimeException("Compile fail: no Groovy jar in the classpath", INIT_FAIL_EXCEPTION);
            }
            try {
                Object object = Utils.newInstance("groovy.lang.GroovyCodeSource", string2, string3 + ".groovy", "UTF-8");
                Utils.callMethod(object, "setCachable", false);
                return (Class)Utils.callMethod(LOADER, "parseClass", object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        static {
            Object object = null;
            Exception exception = null;
            try {
                Class<?> clazz2 = Class.forName("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Object object2 = Utils.newInstance("org.codehaus.groovy.control.customizers.ImportCustomizer", new Object[0]);
                String[] stringArray = new String[]{"java.sql.Connection", "java.sql.Types", "java.sql.ResultSet", "groovy.sql.Sql", "org.h2.tools.SimpleResultSet"};
                Utils.callMethod(object2, "addImports", new Object[]{stringArray});
                Object object3 = Array.newInstance(clazz2, 1);
                Array.set(object3, 0, object2);
                Object object4 = Utils.newInstance("org.codehaus.groovy.control.CompilerConfiguration", new Object[0]);
                Utils.callMethod(object4, "addCompilationCustomizers", object3);
                ClassLoader classLoader = GroovyCompiler.class.getClassLoader();
                object = Utils.newInstance("groovy.lang.GroovyClassLoader", classLoader, object4);
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            LOADER = object;
            INIT_FAIL_EXCEPTION = exception;
        }
    }
}

