/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.h2.store.fs.FileUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class SortedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    @Override
    public synchronized Enumeration<Object> keys() {
        Vector<String> vector = new Vector<String>();
        for (Object object : this.keySet()) {
            vector.add(object.toString());
        }
        Collections.sort(vector);
        return new Vector(vector).elements();
    }

    public static boolean getBooleanProperty(Properties properties, String string2, boolean bl) {
        try {
            return Utils.parseBoolean(properties.getProperty(string2, null), bl, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return bl;
        }
    }

    public static int getIntProperty(Properties properties, String string2, int n) {
        String string3 = properties.getProperty(string2, "" + n);
        try {
            return Integer.decode(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return n;
        }
    }

    public static synchronized SortedProperties loadProperties(String string2) throws IOException {
        SortedProperties sortedProperties = new SortedProperties();
        if (FileUtils.exists(string2)) {
            try (InputStream inputStream = FileUtils.newInputStream(string2);){
                sortedProperties.load(inputStream);
            }
        }
        return sortedProperties;
    }

    public synchronized void store(String string2) throws IOException {
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.store(byteArrayOutputStream, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.ISO_8859_1);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        try {
            outputStreamWriter = new OutputStreamWriter(FileUtils.newOutputStream(string2, false));
        }
        catch (Exception exception) {
            throw new IOException(exception.toString(), exception);
        }
        try (PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));){
            String string3;
            while ((string3 = lineNumberReader.readLine()) != null) {
                if (string3.startsWith("#")) continue;
                printWriter.print(string3 + "\n");
            }
        }
    }

    public synchronized String toLines() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry2 : new TreeMap<Object, Object>(this).entrySet()) {
            stringBuilder.append(entry2.getKey()).append('=').append(entry2.getValue()).append('\n');
        }
        return stringBuilder.toString();
    }

    public static SortedProperties fromLines(String string2) {
        SortedProperties sortedProperties = new SortedProperties();
        for (String string3 : StringUtils.arraySplit(string2, '\n', true)) {
            int n = string3.indexOf(61);
            if (n <= 0) continue;
            sortedProperties.put(string3.substring(0, n), string3.substring(n + 1));
        }
        return sortedProperties;
    }
}

