/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.util.ColumnNamerConfiguration;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Session session;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        this.session = session;
        if (this.session != null && this.session.getColumnNamerConfiguration() != null) {
            this.configuration = this.session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression expression, int n, String[] stringArray) {
        String string2 = null;
        if (stringArray != null && stringArray.length > n) {
            string2 = stringArray[n];
        }
        return this.getColumnName(expression, n, string2);
    }

    public String getColumnName(Expression expression, int n, String string2) {
        String string3 = null;
        if (string2 != null) {
            string3 = string2;
            if (!this.isAllowableColumnName(string3)) {
                string3 = this.fixColumnName(string3);
            }
            if (!this.isAllowableColumnName(string3)) {
                string3 = null;
            }
        }
        if (string3 == null && expression.getAlias() != null && !DEFAULT_COLUMN_NAME.equals(expression.getAlias())) {
            string3 = expression.getAlias();
            if (!this.isAllowableColumnName(string3)) {
                string3 = this.fixColumnName(string3);
            }
            if (!this.isAllowableColumnName(string3)) {
                string3 = null;
            }
        }
        if (string3 == null && expression.getColumnName() != null && !DEFAULT_COLUMN_NAME.equals(expression.getColumnName())) {
            string3 = expression.getColumnName();
            if (!this.isAllowableColumnName(string3)) {
                string3 = this.fixColumnName(string3);
            }
            if (!this.isAllowableColumnName(string3)) {
                string3 = null;
            }
        }
        if (string3 == null && expression.getSQL() != null && !DEFAULT_COLUMN_NAME.equals(expression.getSQL())) {
            string3 = expression.getSQL();
            if (!this.isAllowableColumnName(string3)) {
                string3 = this.fixColumnName(string3);
            }
            if (!this.isAllowableColumnName(string3)) {
                string3 = null;
            }
        }
        if (string3 == null) {
            string3 = this.configuration.getDefaultColumnNamePattern().replace("$$", "" + (n + 1));
        }
        if (this.existingColumnNames.contains(string3) && this.configuration.isGenerateUniqueColumnNames()) {
            string3 = this.generateUniqueName(string3);
        }
        this.existingColumnNames.add(string3);
        return string3;
    }

    private String generateUniqueName(String string2) {
        String string3 = string2;
        int n = 2;
        while (this.existingColumnNames.contains(string3)) {
            String string4 = "_" + n;
            string3 = string2.substring(0, Math.min(string2.length(), this.configuration.getMaxIdentiferLength() - string4.length())) + string4;
            ++n;
        }
        return string3;
    }

    private boolean isAllowableColumnName(String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2.length() > this.configuration.getMaxIdentiferLength() || string2.length() == 0) {
            return false;
        }
        Matcher matcher2 = this.configuration.getCompiledRegularExpressionMatchAllowed().matcher(string2);
        return matcher2.matches();
    }

    private String fixColumnName(String string2) {
        Matcher matcher2 = this.configuration.getCompiledRegularExpressionMatchDisallowed().matcher(string2);
        string2 = matcher2.replaceAll("");
        if (string2.length() > this.configuration.getMaxIdentiferLength()) {
            string2 = string2.substring(0, this.configuration.getMaxIdentiferLength());
        }
        return string2;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

