/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.UUID;

public final class Bits {
    public static int compareNotNullSigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            byte by2 = byArray[i];
            byte by3 = byArray2[i];
            if (by2 == by3) continue;
            return by2 > by3 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static int compareNotNullUnsigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray2[i] & 0xFF;
            if (n2 == n3) continue;
            return n2 > n3 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static int readInt(byte[] byArray, int n) {
        return (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)Bits.readInt(byArray, n) << 32) + ((long)Bits.readInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public static byte[] uuidToBytes(long l, long l2) {
        byte[] byArray = new byte[16];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)(l >> 8 * (7 - i) & 0xFFL);
            byArray[8 + i] = (byte)(l2 >> 8 * (7 - i) & 0xFFL);
        }
        return byArray;
    }

    public static byte[] uuidToBytes(UUID uUID) {
        return Bits.uuidToBytes(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        Bits.writeInt(byArray, n, (int)(l >> 32));
        Bits.writeInt(byArray, n + 4, (int)l);
    }

    private Bits() {
    }
}

