/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.h2.constraint.Constraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintCheck;
import org.h2.constraint.ConstraintReferential;
import org.h2.constraint.ConstraintUnique;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Mode;
import org.h2.engine.QueryStatisticsData;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.engine.UserDataType;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.MetaIndex;
import org.h2.index.MultiVersionIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableSynonym;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.tools.Csv;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueStringIgnoreCase;

public class MetaTable
extends Table {
    public static final long ROW_COUNT_APPROXIMATION = 1000L;
    private static final String CHARACTER_SET_NAME = "Unicode";
    private static final int TABLES = 0;
    private static final int COLUMNS = 1;
    private static final int INDEXES = 2;
    private static final int TABLE_TYPES = 3;
    private static final int TYPE_INFO = 4;
    private static final int CATALOGS = 5;
    private static final int SETTINGS = 6;
    private static final int HELP = 7;
    private static final int SEQUENCES = 8;
    private static final int USERS = 9;
    private static final int ROLES = 10;
    private static final int RIGHTS = 11;
    private static final int FUNCTION_ALIASES = 12;
    private static final int SCHEMATA = 13;
    private static final int TABLE_PRIVILEGES = 14;
    private static final int COLUMN_PRIVILEGES = 15;
    private static final int COLLATIONS = 16;
    private static final int VIEWS = 17;
    private static final int IN_DOUBT = 18;
    private static final int CROSS_REFERENCES = 19;
    private static final int CONSTRAINTS = 20;
    private static final int FUNCTION_COLUMNS = 21;
    private static final int CONSTANTS = 22;
    private static final int DOMAINS = 23;
    private static final int TRIGGERS = 24;
    private static final int SESSIONS = 25;
    private static final int LOCKS = 26;
    private static final int SESSION_STATE = 27;
    private static final int QUERY_STATISTICS = 28;
    private static final int SYNONYMS = 29;
    private static final int TABLE_CONSTRAINTS = 30;
    private static final int KEY_COLUMN_USAGE = 31;
    private static final int REFERENTIAL_CONSTRAINTS = 32;
    private static final int META_TABLE_TYPE_COUNT = 33;
    private final int type;
    private final int indexColumn;
    private final MetaIndex metaIndex;

    public MetaTable(Schema schema, int n, int n2) {
        super(schema, n, null, true, true);
        Column[] columnArray;
        this.type = n2;
        String string2 = null;
        switch (n2) {
            case 0: {
                this.setObjectName("TABLES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "TABLE_TYPE", "STORAGE_TYPE", "SQL", "REMARKS", "LAST_MODIFICATION BIGINT", "ID INT", "TYPE_NAME", "TABLE_CLASS", "ROW_COUNT_ESTIMATE BIGINT");
                string2 = "TABLE_NAME";
                break;
            }
            case 1: {
                this.setObjectName("COLUMNS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION INT", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "CHARACTER_MAXIMUM_LENGTH INT", "CHARACTER_OCTET_LENGTH INT", "NUMERIC_PRECISION INT", "NUMERIC_PRECISION_RADIX INT", "NUMERIC_SCALE INT", "CHARACTER_SET_NAME", "COLLATION_NAME", "TYPE_NAME", "NULLABLE INT", "IS_COMPUTED BIT", "SELECTIVITY INT", "CHECK_CONSTRAINT", "SEQUENCE_NAME", "REMARKS", "SOURCE_DATA_TYPE SMALLINT", "COLUMN_TYPE", "COLUMN_ON_UPDATE");
                string2 = "TABLE_NAME";
                break;
            }
            case 2: {
                this.setObjectName("INDEXES");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "NON_UNIQUE BIT", "INDEX_NAME", "ORDINAL_POSITION SMALLINT", "COLUMN_NAME", "CARDINALITY INT", "PRIMARY_KEY BIT", "INDEX_TYPE_NAME", "IS_GENERATED BIT", "INDEX_TYPE SMALLINT", "ASC_OR_DESC", "PAGES INT", "FILTER_CONDITION", "REMARKS", "SQL", "ID INT", "SORT_TYPE INT", "CONSTRAINT_NAME", "INDEX_CLASS", "AFFINITY BIT");
                string2 = "TABLE_NAME";
                break;
            }
            case 3: {
                this.setObjectName("TABLE_TYPES");
                columnArray = this.createColumns("TYPE");
                break;
            }
            case 4: {
                this.setObjectName("TYPE_INFO");
                columnArray = this.createColumns("TYPE_NAME", "DATA_TYPE INT", "PRECISION INT", "PREFIX", "SUFFIX", "PARAMS", "AUTO_INCREMENT BIT", "MINIMUM_SCALE SMALLINT", "MAXIMUM_SCALE SMALLINT", "RADIX INT", "POS INT", "CASE_SENSITIVE BIT", "NULLABLE SMALLINT", "SEARCHABLE SMALLINT");
                break;
            }
            case 5: {
                this.setObjectName("CATALOGS");
                columnArray = this.createColumns("CATALOG_NAME");
                break;
            }
            case 6: {
                this.setObjectName("SETTINGS");
                columnArray = this.createColumns("NAME", "VALUE");
                break;
            }
            case 7: {
                this.setObjectName("HELP");
                columnArray = this.createColumns("ID INT", "SECTION", "TOPIC", "SYNTAX", "TEXT");
                break;
            }
            case 8: {
                this.setObjectName("SEQUENCES");
                columnArray = this.createColumns("SEQUENCE_CATALOG", "SEQUENCE_SCHEMA", "SEQUENCE_NAME", "CURRENT_VALUE BIGINT", "INCREMENT BIGINT", "IS_GENERATED BIT", "REMARKS", "CACHE BIGINT", "MIN_VALUE BIGINT", "MAX_VALUE BIGINT", "IS_CYCLE BIT", "ID INT");
                break;
            }
            case 9: {
                this.setObjectName("USERS");
                columnArray = this.createColumns("NAME", "ADMIN", "REMARKS", "ID INT");
                break;
            }
            case 10: {
                this.setObjectName("ROLES");
                columnArray = this.createColumns("NAME", "REMARKS", "ID INT");
                break;
            }
            case 11: {
                this.setObjectName("RIGHTS");
                columnArray = this.createColumns("GRANTEE", "GRANTEETYPE", "GRANTEDROLE", "RIGHTS", "TABLE_SCHEMA", "TABLE_NAME", "ID INT");
                string2 = "TABLE_NAME";
                break;
            }
            case 12: {
                this.setObjectName("FUNCTION_ALIASES");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "DATA_TYPE INT", "TYPE_NAME", "COLUMN_COUNT INT", "RETURNS_RESULT SMALLINT", "REMARKS", "ID INT", "SOURCE");
                break;
            }
            case 21: {
                this.setObjectName("FUNCTION_COLUMNS");
                columnArray = this.createColumns("ALIAS_CATALOG", "ALIAS_SCHEMA", "ALIAS_NAME", "JAVA_CLASS", "JAVA_METHOD", "COLUMN_COUNT INT", "POS INT", "COLUMN_NAME", "DATA_TYPE INT", "TYPE_NAME", "PRECISION INT", "SCALE SMALLINT", "RADIX SMALLINT", "NULLABLE SMALLINT", "COLUMN_TYPE SMALLINT", "REMARKS", "COLUMN_DEFAULT");
                break;
            }
            case 13: {
                this.setObjectName("SCHEMATA");
                columnArray = this.createColumns("CATALOG_NAME", "SCHEMA_NAME", "SCHEMA_OWNER", "DEFAULT_CHARACTER_SET_NAME", "DEFAULT_COLLATION_NAME", "IS_DEFAULT BIT", "REMARKS", "ID INT");
                break;
            }
            case 14: {
                this.setObjectName("TABLE_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string2 = "TABLE_NAME";
                break;
            }
            case 15: {
                this.setObjectName("COLUMN_PRIVILEGES");
                columnArray = this.createColumns("GRANTOR", "GRANTEE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "PRIVILEGE_TYPE", "IS_GRANTABLE");
                string2 = "TABLE_NAME";
                break;
            }
            case 16: {
                this.setObjectName("COLLATIONS");
                columnArray = this.createColumns("NAME", "KEY");
                break;
            }
            case 17: {
                this.setObjectName("VIEWS");
                columnArray = this.createColumns("TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "VIEW_DEFINITION", "CHECK_OPTION", "IS_UPDATABLE", "STATUS", "REMARKS", "ID INT");
                string2 = "TABLE_NAME";
                break;
            }
            case 18: {
                this.setObjectName("IN_DOUBT");
                columnArray = this.createColumns("TRANSACTION", "STATE");
                break;
            }
            case 19: {
                this.setObjectName("CROSS_REFERENCES");
                columnArray = this.createColumns("PKTABLE_CATALOG", "PKTABLE_SCHEMA", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CATALOG", "FKTABLE_SCHEMA", "FKTABLE_NAME", "FKCOLUMN_NAME", "ORDINAL_POSITION SMALLINT", "UPDATE_RULE SMALLINT", "DELETE_RULE SMALLINT", "FK_NAME", "PK_NAME", "DEFERRABILITY SMALLINT");
                string2 = "PKTABLE_NAME";
                break;
            }
            case 20: {
                this.setObjectName("CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "UNIQUE_INDEX_NAME", "CHECK_EXPRESSION", "COLUMN_LIST", "REMARKS", "SQL", "ID INT");
                string2 = "TABLE_NAME";
                break;
            }
            case 22: {
                this.setObjectName("CONSTANTS");
                columnArray = this.createColumns("CONSTANT_CATALOG", "CONSTANT_SCHEMA", "CONSTANT_NAME", "DATA_TYPE INT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 23: {
                this.setObjectName("DOMAINS");
                columnArray = this.createColumns("DOMAIN_CATALOG", "DOMAIN_SCHEMA", "DOMAIN_NAME", "COLUMN_DEFAULT", "IS_NULLABLE", "DATA_TYPE INT", "PRECISION INT", "SCALE INT", "TYPE_NAME", "SELECTIVITY INT", "CHECK_CONSTRAINT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 24: {
                this.setObjectName("TRIGGERS");
                columnArray = this.createColumns("TRIGGER_CATALOG", "TRIGGER_SCHEMA", "TRIGGER_NAME", "TRIGGER_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "BEFORE BIT", "JAVA_CLASS", "QUEUE_SIZE INT", "NO_WAIT BIT", "REMARKS", "SQL", "ID INT");
                break;
            }
            case 25: {
                this.setObjectName("SESSIONS");
                columnArray = this.createColumns("ID INT", "USER_NAME", "SESSION_START", "STATEMENT", "STATEMENT_START", "CONTAINS_UNCOMMITTED");
                break;
            }
            case 26: {
                this.setObjectName("LOCKS");
                columnArray = this.createColumns("TABLE_SCHEMA", "TABLE_NAME", "SESSION_ID INT", "LOCK_TYPE");
                break;
            }
            case 27: {
                this.setObjectName("SESSION_STATE");
                columnArray = this.createColumns("KEY", "SQL");
                break;
            }
            case 28: {
                this.setObjectName("QUERY_STATISTICS");
                columnArray = this.createColumns("SQL_STATEMENT", "EXECUTION_COUNT INT", "MIN_EXECUTION_TIME DOUBLE", "MAX_EXECUTION_TIME DOUBLE", "CUMULATIVE_EXECUTION_TIME DOUBLE", "AVERAGE_EXECUTION_TIME DOUBLE", "STD_DEV_EXECUTION_TIME DOUBLE", "MIN_ROW_COUNT INT", "MAX_ROW_COUNT INT", "CUMULATIVE_ROW_COUNT LONG", "AVERAGE_ROW_COUNT DOUBLE", "STD_DEV_ROW_COUNT DOUBLE");
                break;
            }
            case 29: {
                this.setObjectName("SYNONYMS");
                columnArray = this.createColumns("SYNONYM_CATALOG", "SYNONYM_SCHEMA", "SYNONYM_NAME", "SYNONYM_FOR", "SYNONYM_FOR_SCHEMA", "TYPE_NAME", "STATUS", "REMARKS", "ID INT");
                string2 = "SYNONYM_NAME";
                break;
            }
            case 30: {
                this.setObjectName("TABLE_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "CONSTRAINT_TYPE", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "IS_DEFERRABLE", "INITIALLY_DEFERRED");
                string2 = "TABLE_NAME";
                break;
            }
            case 31: {
                this.setObjectName("KEY_COLUMN_USAGE");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "TABLE_CATALOG", "TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME", "ORDINAL_POSITION", "POSITION_IN_UNIQUE_CONSTRAINT");
                string2 = "TABLE_NAME";
                break;
            }
            case 32: {
                this.setObjectName("REFERENTIAL_CONSTRAINTS");
                columnArray = this.createColumns("CONSTRAINT_CATALOG", "CONSTRAINT_SCHEMA", "CONSTRAINT_NAME", "UNIQUE_CONSTRAINT_CATALOG", "UNIQUE_CONSTRAINT_SCHEMA", "UNIQUE_CONSTRAINT_NAME", "MATCH_OPTION", "UPDATE_RULE", "DELETE_RULE");
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + n2);
            }
        }
        this.setColumns(columnArray);
        if (string2 == null) {
            this.indexColumn = -1;
            this.metaIndex = null;
        } else {
            this.indexColumn = this.getColumn(string2).getColumnId();
            IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{columnArray[this.indexColumn]});
            this.metaIndex = new MetaIndex(this, indexColumnArray, false);
        }
    }

    private Column[] createColumns(String ... stringArray) {
        Column[] columnArray = new Column[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            int n;
            String string3 = stringArray[i];
            int n2 = string3.indexOf(32);
            if (n2 < 0) {
                n = this.database.getMode().lowerCaseIdentifiers ? 14 : 13;
                string2 = string3;
            } else {
                n = DataType.getTypeByName((String)string3.substring((int)(n2 + 1)), (Mode)this.database.getMode()).type;
                string2 = string3.substring(0, n2);
            }
            columnArray[i] = new Column(string2, n);
        }
        return columnArray;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public Index addIndex(Session session, String string2, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string3) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public boolean lock(Session session, boolean bl, boolean bl2) {
        return false;
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    private String identifier(String string2) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string2 = string2 == null ? null : StringUtils.toLowerEnglish(string2);
        }
        return string2;
    }

    private ArrayList<Table> getAllTables(Session session) {
        ArrayList<Table> arrayList = this.database.getAllTablesAndViews(true);
        ArrayList<Table> arrayList2 = session.getLocalTempTables();
        arrayList.addAll(arrayList2);
        return arrayList;
    }

    private ArrayList<Table> getTablesByName(Session session, String string2) {
        if (this.database.getMode().lowerCaseIdentifiers) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        ArrayList<Table> arrayList = this.database.getTableOrViewByName(string2);
        for (Table table : session.getLocalTempTables()) {
            if (!table.getName().equals(string2)) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private boolean checkIndex(Session session, String string2, Value value2, Value value3) {
        if (string2 == null || value2 == null && value3 == null) {
            return true;
        }
        Database database = session.getDatabase();
        Value value4 = this.database.getMode().lowerCaseIdentifiers ? ValueStringIgnoreCase.get(string2) : ValueString.get(string2);
        if (value2 != null && database.compare(value4, value2) < 0) {
            return false;
        }
        return value3 == null || database.compare(value4, value3) <= 0;
    }

    private static String replaceNullWithEmpty(String string2) {
        return string2 == null ? "" : string2;
    }

    private boolean hideTable(Table table, Session session) {
        return table.isHidden() && session != this.database.getSystemSession();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public ArrayList<Row> generateRows(Session var1_1, SearchRow var2_2, SearchRow var3_3) {
        var4_4 = null;
        var5_5 = null;
        if (this.indexColumn >= 0) {
            if (var2_2 != null) {
                var4_4 = var2_2.getValue(this.indexColumn);
            }
            if (var3_3 != null) {
                var5_5 = var3_3.getValue(this.indexColumn);
            }
        }
        var6_6 = New.arrayList();
        var7_7 = this.identifier(this.database.getShortName());
        var8_8 = var1_1.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                for (Table var10_40 : this.getAllTables(var1_1)) {
                    var11_74 = this.identifier(var10_40.getName());
                    if (!this.checkIndex(var1_1, var11_74, var4_4, var5_5) || this.hideTable(var10_40, var1_1)) continue;
                    var12_105 = var10_40.isTemporary() ? (var10_40.isGlobalTemporary() ? "GLOBAL TEMPORARY" : "LOCAL TEMPORARY") : (var10_40.isPersistIndexes() != false ? "CACHED" : "MEMORY");
                    var13_131 = var10_40.getCreateSQL();
                    if (!var8_8 && var13_131 != null && var13_131.contains("--hide--")) {
                        var13_131 = "-";
                    }
                    this.add(var6_6, new String[]{var7_7, this.identifier(var10_40.getSchema().getName()), var11_74, var10_40.getTableType().toString(), var12_105, var13_131, MetaTable.replaceNullWithEmpty(var10_40.getComment()), "" + var10_40.getMaxDataModificationId(), "" + var10_40.getId(), null, var10_40.getClass().getName(), "" + var10_40.getRowCountApproximation()});
                }
                break;
            }
            case 1: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_41 = this.identifier(var4_4.getString());
                    var9_10 = this.getTablesByName(var1_1, var10_41);
                } else {
                    var9_10 = this.getAllTables(var1_1);
                }
                for (Table var11_75 : var9_10) {
                    var12_106 = this.identifier(var11_75.getName());
                    if (!this.checkIndex(var1_1, var12_106, var4_4, var5_5) || this.hideTable(var11_75, var1_1)) continue;
                    var13_132 = var11_75.getColumns();
                    var14_152 = this.database.getCompareMode().getName();
                    for (var15_167 = 0; var15_167 < var13_132.length; ++var15_167) {
                        var16_178 = var13_132[var15_167];
                        var17_191 = var16_178.getSequence();
                        this.add(var6_6, new String[]{var7_7, this.identifier(var11_75.getSchema().getName()), var12_106, this.identifier(var16_178.getName()), String.valueOf(var15_167 + 1), var16_178.getDefaultSQL(), var16_178.isNullable() != false ? "YES" : "NO", "" + DataType.convertTypeToSQLType(var16_178.getType()), "" + var16_178.getPrecisionAsInt(), "" + var16_178.getPrecisionAsInt(), "" + var16_178.getPrecisionAsInt(), "10", "" + var16_178.getScale(), "Unicode", var14_152, this.identifier(DataType.getDataType((int)var16_178.getType()).name), "" + (var16_178.isNullable() != false ? 1 : 0), "" + (var16_178.getComputed() != false ? "TRUE" : "FALSE"), "" + var16_178.getSelectivity(), var16_178.getCheckConstraintSQL(var1_1, var16_178.getName()), var17_191 == null ? null : var17_191.getName(), MetaTable.replaceNullWithEmpty(var16_178.getComment()), null, var16_178.getCreateSQLWithoutName(), var16_178.getOnUpdateSQL()});
                    }
                }
                break;
            }
            case 2: {
                if (var4_4 != null && var4_4.equals(var5_5)) {
                    var10_42 = this.identifier(var4_4.getString());
                    var9_11 = this.getTablesByName(var1_1, var10_42);
                } else {
                    var9_11 = this.getAllTables(var1_1);
                }
                for (Table var11_76 : var9_11) {
                    var12_107 = this.identifier(var11_76.getName());
                    if (!this.checkIndex(var1_1, var12_107, var4_4, var5_5) || this.hideTable(var11_76, var1_1)) continue;
                    var13_133 = var11_76.getIndexes();
                    var14_153 = var11_76.getConstraints();
                    for (var15_168 = 0; var13_133 != null && var15_168 < var13_133.size(); ++var15_168) {
                        var16_179 = var13_133.get(var15_168);
                        if (var16_179.getCreateSQL() == null) continue;
                        var17_192 = null;
                        for (var18_202 = 0; var14_153 != null && var18_202 < var14_153.size(); ++var18_202) {
                            var19_209 = var14_153.get(var18_202);
                            if (!var19_209.usesIndex(var16_179)) continue;
                            if (var16_179.getIndexType().isPrimaryKey()) {
                                if (var19_209.getConstraintType() != Constraint.Type.PRIMARY_KEY) continue;
                                var17_192 = var19_209.getName();
                                continue;
                            }
                            var17_192 = var19_209.getName();
                        }
                        var18_201 = var16_179.getIndexColumns();
                        var19_209 = var16_179 instanceof MultiVersionIndex != false ? ((MultiVersionIndex)var16_179).getBaseIndex().getClass().getName() : var16_179.getClass().getName();
                        for (var20_215 = 0; var20_215 < var18_201.length; ++var20_215) {
                            var21_220 = var18_201[var20_215];
                            var22_224 = var21_220.column;
                            this.add(var6_6, new String[]{var7_7, this.identifier(var11_76.getSchema().getName()), var12_107, var16_179.getIndexType().isUnique() != false ? "FALSE" : "TRUE", this.identifier(var16_179.getName()), "" + (var20_215 + 1), this.identifier(var22_224.getName()), "0", var16_179.getIndexType().isPrimaryKey() != false ? "TRUE" : "FALSE", var16_179.getIndexType().getSQL(), var16_179.getIndexType().getBelongsToConstraint() != false ? "TRUE" : "FALSE", "3", (var21_220.sortType & 1) != 0 ? "D" : "A", "0", "", MetaTable.replaceNullWithEmpty(var16_179.getComment()), var16_179.getCreateSQL(), "" + var16_179.getId(), "" + var21_220.sortType, var17_192, var19_209, var16_179.getIndexType().isAffinity() != false ? "TRUE" : "FALSE"});
                        }
                    }
                }
                break;
            }
            case 3: {
                this.add(var6_6, new String[]{TableType.TABLE.toString()});
                this.add(var6_6, new String[]{TableType.TABLE_LINK.toString()});
                this.add(var6_6, new String[]{TableType.SYSTEM_TABLE.toString()});
                this.add(var6_6, new String[]{TableType.VIEW.toString()});
                this.add(var6_6, new String[]{TableType.EXTERNAL_TABLE_ENGINE.toString()});
                break;
            }
            case 5: {
                this.add(var6_6, new String[]{var7_7});
                break;
            }
            case 6: {
                var9_12 = this.database.getAllSettings().iterator();
                while (var9_12.hasNext()) {
                    var10_43 = var9_12.next();
                    var11_77 = var10_43.getStringValue();
                    if (var11_77 == null) {
                        var11_77 = "" + var10_43.getIntValue();
                    }
                    this.add(var6_6, new String[]{this.identifier(var10_43.getName()), var11_77});
                }
                this.add(var6_6, new String[]{"info.BUILD_ID", "197"});
                this.add(var6_6, new String[]{"info.VERSION_MAJOR", "1"});
                this.add(var6_6, new String[]{"info.VERSION_MINOR", "4"});
                this.add(var6_6, new String[]{"info.VERSION", "" + Constants.getFullVersion()});
                if (var8_8) {
                    for (Object var13_134 : var9_12 = new String[]{"java.runtime.version", "java.vm.name", "java.vendor", "os.name", "os.arch", "os.version", "sun.os.patch.level", "file.separator", "path.separator", "line.separator", "user.country", "user.language", "user.variant", "file.encoding"}) {
                        this.add(var6_6, new String[]{"property." + (String)var13_134, Utils.getProperty((String)var13_134, "")});
                    }
                }
                this.add(var6_6, new String[]{"EXCLUSIVE", this.database.getExclusiveSession() == null ? "FALSE" : "TRUE"});
                this.add(var6_6, new String[]{"MODE", this.database.getMode().getName()});
                this.add(var6_6, new String[]{"MULTI_THREADED", this.database.isMultiThreaded() != false ? "1" : "0"});
                this.add(var6_6, new String[]{"MVCC", this.database.isMultiVersion() != false ? "TRUE" : "FALSE"});
                this.add(var6_6, new String[]{"QUERY_TIMEOUT", "" + var1_1.getQueryTimeout()});
                this.add(var6_6, new String[]{"RETENTION_TIME", "" + this.database.getRetentionTime()});
                this.add(var6_6, new String[]{"LOG", "" + this.database.getLogMode()});
                var9_12 = New.arrayList();
                var10_43 = this.database.getSettings().getSettings();
                var9_12.addAll(var10_43.keySet());
                Collections.sort(var9_12);
                var11_79 = var9_12.iterator();
                while (var11_79.hasNext()) {
                    var12_110 = (String)var11_79.next();
                    this.add(var6_6, new String[]{var12_110, (String)var10_43.get(var12_110)});
                }
                if (!this.database.isPersistent()) break;
                var11_79 = this.database.getPageStore();
                if (var11_79 != null) {
                    this.add(var6_6, new String[]{"info.FILE_WRITE_TOTAL", "" + var11_79.getWriteCountTotal()});
                    this.add(var6_6, new String[]{"info.FILE_WRITE", "" + var11_79.getWriteCount()});
                    this.add(var6_6, new String[]{"info.FILE_READ", "" + var11_79.getReadCount()});
                    this.add(var6_6, new String[]{"info.PAGE_COUNT", "" + var11_79.getPageCount()});
                    this.add(var6_6, new String[]{"info.PAGE_SIZE", "" + var11_79.getPageSize()});
                    this.add(var6_6, new String[]{"info.CACHE_MAX_SIZE", "" + var11_79.getCache().getMaxMemory()});
                    this.add(var6_6, new String[]{"info.CACHE_SIZE", "" + var11_79.getCache().getMemory()});
                }
                if ((var12_111 = this.database.getMvStore()) == null) break;
                var13_134 = var12_111.getStore().getFileStore();
                this.add(var6_6, new String[]{"info.FILE_WRITE", "" + var13_134.getWriteCount()});
                this.add(var6_6, new String[]{"info.FILE_READ", "" + var13_134.getReadCount()});
                try {
                    var14_154 = var13_134.getFile().size();
                }
                catch (IOException var16_180) {
                    throw DbException.convertIOException(var16_180, "Can not get size");
                }
                var16_181 = 4096;
                var17_193 = var14_154 / (long)var16_181;
                this.add(var6_6, new String[]{"info.PAGE_COUNT", "" + var17_193});
                this.add(var6_6, new String[]{"info.PAGE_SIZE", "" + var16_181});
                this.add(var6_6, new String[]{"info.CACHE_MAX_SIZE", "" + var12_111.getStore().getCacheSize()});
                this.add(var6_6, new String[]{"info.CACHE_SIZE", "" + var12_111.getStore().getCacheSizeUsed()});
                break;
            }
            case 4: {
                for (DataType var10_44 : DataType.getTypes()) {
                    if (var10_44.hidden || var10_44.sqlType == 0) continue;
                    this.add(var6_6, new String[]{var10_44.name, String.valueOf(var10_44.sqlType), String.valueOf(MathUtils.convertLongToInt(var10_44.maxPrecision)), var10_44.prefix, var10_44.suffix, var10_44.params, String.valueOf(var10_44.autoIncrement), String.valueOf(var10_44.minScale), String.valueOf(var10_44.maxScale), var10_44.decimal != false ? "10" : null, String.valueOf(var10_44.sqlTypePos), String.valueOf(var10_44.caseSensitive), "1", "3"});
                }
                break;
            }
            case 7: {
                var9_14 = "/org/h2/res/help.csv";
                try {
                    var10_45 = Utils.getResource(var9_14);
                    var11_80 = new InputStreamReader(new ByteArrayInputStream(var10_45));
                    var12_112 = new Csv();
                    var12_112.setLineCommentCharacter('#');
                    var13_135 = var12_112.read(var11_80, null);
                    var14_155 = 0;
                    while (var13_135.next()) {
                        this.add(var6_6, new String[]{String.valueOf(var14_155), var13_135.getString(1).trim(), var13_135.getString(2).trim(), var13_135.getString(3).trim(), var13_135.getString(4).trim()});
                        ++var14_155;
                    }
                    break;
                }
                catch (Exception var10_46) {
                    throw DbException.convert(var10_46);
                }
            }
            case 8: {
                for (SchemaObject var10_47 : this.database.getAllSchemaObjects(3)) {
                    var11_81 = (Sequence)var10_47;
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_81.getSchema().getName()), this.identifier(var11_81.getName()), String.valueOf(var11_81.getCurrentValue()), String.valueOf(var11_81.getIncrement()), var11_81.getBelongsToTable() != false ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(var11_81.getComment()), String.valueOf(var11_81.getCacheSize()), String.valueOf(var11_81.getMinValue()), String.valueOf(var11_81.getMaxValue()), var11_81.getCycle() != false ? "TRUE" : "FALSE", "" + var11_81.getId()});
                }
                break;
            }
            case 9: {
                for (User var10_48 : this.database.getAllUsers()) {
                    if (!var8_8 && var1_1.getUser() != var10_48) continue;
                    this.add(var6_6, new String[]{this.identifier(var10_48.getName()), String.valueOf(var10_48.isAdmin()), MetaTable.replaceNullWithEmpty(var10_48.getComment()), "" + var10_48.getId()});
                }
                break;
            }
            case 10: {
                for (Role var10_49 : this.database.getAllRoles()) {
                    if (!var8_8 && !var1_1.getUser().isRoleGranted(var10_49)) continue;
                    this.add(var6_6, new String[]{this.identifier(var10_49.getName()), MetaTable.replaceNullWithEmpty(var10_49.getComment()), "" + var10_49.getId()});
                }
                break;
            }
            case 11: {
                if (!var8_8) break;
                for (Right var10_50 : this.database.getAllRights()) {
                    var11_82 = var10_50.getGrantedRole();
                    var12_113 = var10_50.getGrantee();
                    v0 = var13_136 = var12_113.getType() == 2 ? "USER" : "ROLE";
                    if (var11_82 == null) {
                        var14_156 = var10_50.getGrantedObject();
                        var15_169 = null;
                        var16_182 = null;
                        if (var14_156 != null) {
                            if (var14_156 instanceof Schema) {
                                var15_169 = (Schema)var14_156;
                            } else if (var14_156 instanceof Table) {
                                var16_182 = (Table)var14_156;
                                var15_169 = var16_182.getSchema();
                            }
                        }
                        var17_194 = var16_182 != null ? this.identifier(var16_182.getName()) : "";
                        v1 = var18_203 = var15_169 != null ? this.identifier(var15_169.getName()) : "";
                        if (!this.checkIndex(var1_1, var17_194, var4_4, var5_5)) continue;
                        this.add(var6_6, new String[]{this.identifier(var12_113.getName()), var13_136, "", var10_50.getRights(), var18_203, var17_194, "" + var10_50.getId()});
                        continue;
                    }
                    this.add(var6_6, new String[]{this.identifier(var12_113.getName()), var13_136, this.identifier(var11_82.getName()), "", "", "", "" + var10_50.getId()});
                }
                break;
            }
            case 12: {
                for (DbObject var10_51 : this.database.getAllSchemaObjects(9)) {
                    var11_83 = (FunctionAlias)var10_51;
                    try {
                        var12_114 = var11_83.getJavaMethods();
                    }
                    catch (DbException var13_138) {
                        var12_114 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_183 : var12_114) {
                        var17_195 = var16_183.getDataType() == 0 ? 1 : 2;
                        this.add(var6_6, new String[]{var7_7, var11_83.getSchema().getName(), this.identifier(var11_83.getName()), var11_83.getJavaClassName(), var11_83.getJavaMethodName(), "" + DataType.convertTypeToSQLType(var16_183.getDataType()), DataType.getDataType((int)var16_183.getDataType()).name, "" + var16_183.getParameterCount(), "" + var17_195, MetaTable.replaceNullWithEmpty(var11_83.getComment()), "" + var11_83.getId(), var11_83.getSource()});
                    }
                }
                for (DbObject var10_51 : this.database.getAllAggregates()) {
                    var11_84 = 2;
                    this.add(var6_6, new String[]{var7_7, "PUBLIC", this.identifier(var10_51.getName()), var10_51.getJavaClassName(), "", "" + DataType.convertTypeToSQLType(0), DataType.getDataType((int)0).name, "1", "" + var11_84, MetaTable.replaceNullWithEmpty(var10_51.getComment()), "" + var10_51.getId(), ""});
                }
                break;
            }
            case 21: {
                for (SchemaObject var10_52 : this.database.getAllSchemaObjects(9)) {
                    var11_85 = (FunctionAlias)var10_52;
                    try {
                        var12_115 = var11_85.getJavaMethods();
                    }
                    catch (DbException var13_140) {
                        var12_115 = new FunctionAlias.JavaMethod[]{};
                    }
                    for (FunctionAlias.JavaMethod var16_184 : var12_115) {
                        if (var16_184.getDataType() != 0) {
                            var17_196 /* !! */  = DataType.getDataType(var16_184.getDataType());
                            this.add(var6_6, new String[]{var7_7, var11_85.getSchema().getName(), this.identifier(var11_85.getName()), var11_85.getJavaClassName(), var11_85.getJavaMethodName(), "" + var16_184.getParameterCount(), "0", "P0", "" + DataType.convertTypeToSQLType(var16_184.getDataType()), var17_196 /* !! */ .name, "" + MathUtils.convertLongToInt(var17_196 /* !! */ .defaultPrecision), "" + var17_196 /* !! */ .defaultScale, "10", "2", "5", "", null});
                        }
                        var17_196 /* !! */  = var16_184.getColumnClasses();
                        for (var18_204 = 0; var18_204 < var17_196 /* !! */ .length; ++var18_204) {
                            if (var16_184.hasConnectionParam() && var18_204 == 0) continue;
                            var19_210 = var17_196 /* !! */ [var18_204];
                            var20_216 = DataType.getTypeFromClass(var19_210);
                            var21_221 = DataType.getDataType(var20_216);
                            var22_225 = var19_210.isPrimitive() != false ? 0 : 1;
                            this.add(var6_6, new String[]{var7_7, var11_85.getSchema().getName(), this.identifier(var11_85.getName()), var11_85.getJavaClassName(), var11_85.getJavaMethodName(), "" + var16_184.getParameterCount(), "" + (var18_204 + (var16_184.hasConnectionParam() != false ? 0 : 1)), "P" + (var18_204 + 1), "" + DataType.convertTypeToSQLType(var21_221.type), var21_221.name, "" + MathUtils.convertLongToInt(var21_221.defaultPrecision), "" + var21_221.defaultScale, "10", "" + var22_225, "1", "", null});
                        }
                    }
                }
                break;
            }
            case 13: {
                var9_21 = this.database.getCompareMode().getName();
                for (Schema var11_86 : this.database.getAllSchemas()) {
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_86.getName()), this.identifier(var11_86.getOwner().getName()), "Unicode", var9_21, "PUBLIC".equals(var11_86.getName()) != false ? "TRUE" : "FALSE", MetaTable.replaceNullWithEmpty(var11_86.getComment()), "" + var11_86.getId()});
                }
                break;
            }
            case 14: {
                for (Right var10_54 : this.database.getAllRights()) {
                    var11_87 = var10_54.getGrantedObject();
                    if (!(var11_87 instanceof Table) || this.hideTable(var12_116 = (Table)var11_87, var1_1) || !this.checkIndex(var1_1, var13_141 = this.identifier(var12_116.getName()), var4_4, var5_5)) continue;
                    this.addPrivileges(var6_6, var10_54.getGrantee(), var7_7, var12_116, null, var10_54.getRightMask());
                }
                break;
            }
            case 15: {
                for (Right var10_55 : this.database.getAllRights()) {
                    var11_88 = var10_55.getGrantedObject();
                    if (!(var11_88 instanceof Table) || this.hideTable(var12_117 = (Table)var11_88, var1_1) || !this.checkIndex(var1_1, var13_142 = this.identifier(var12_117.getName()), var4_4, var5_5)) continue;
                    var14_159 = var10_55.getGrantee();
                    var15_172 = var10_55.getRightMask();
                    for (Column var19_211 : var12_117.getColumns()) {
                        this.addPrivileges(var6_6, var14_159, var7_7, var12_117, var19_211.getName(), var15_172);
                    }
                }
                break;
            }
            case 16: {
                for (Locale var12_118 : Collator.getAvailableLocales()) {
                    this.add(var6_6, new String[]{CompareMode.getName(var12_118), var12_118.toString()});
                }
                break;
            }
            case 17: {
                for (Table var10_57 : this.getAllTables(var1_1)) {
                    if (var10_57.getTableType() != TableType.VIEW || !this.checkIndex(var1_1, var11_90 = this.identifier(var10_57.getName()), var4_4, var5_5)) continue;
                    var12_119 = (TableView)var10_57;
                    this.add(var6_6, new String[]{var7_7, this.identifier(var10_57.getSchema().getName()), var11_90, var10_57.getCreateSQL(), "NONE", "NO", var12_119.isInvalid() != false ? "INVALID" : "VALID", MetaTable.replaceNullWithEmpty(var12_119.getComment()), "" + var12_119.getId()});
                }
                break;
            }
            case 18: {
                var9_26 = this.database.getInDoubtTransactions();
                if (var9_26 == null || !var8_8) break;
                for (InDoubtTransaction var11_91 : var9_26) {
                    this.add(var6_6, new String[]{var11_91.getTransactionName(), var11_91.getState()});
                }
                break;
            }
            case 19: {
                for (SchemaObject var10_59 : this.database.getAllSchemaObjects(5)) {
                    var11_92 = (Constraint)var10_59;
                    if (var11_92.getConstraintType() != Constraint.Type.REFERENTIAL) continue;
                    var12_120 = (ConstraintReferential)var11_92;
                    var13_143 = var12_120.getColumns();
                    var14_160 = var12_120.getRefColumns();
                    var15_173 = var12_120.getTable();
                    var16_186 = var12_120.getRefTable();
                    var17_198 = this.identifier(var16_186.getName());
                    if (!this.checkIndex(var1_1, var17_198, var4_4, var5_5)) continue;
                    var18_206 = MetaTable.getRefAction(var12_120.getUpdateAction());
                    var19_212 = MetaTable.getRefAction(var12_120.getDeleteAction());
                    for (var20_217 = 0; var20_217 < var13_143.length; ++var20_217) {
                        this.add(var6_6, new String[]{var7_7, this.identifier(var16_186.getSchema().getName()), this.identifier(var16_186.getName()), this.identifier(var14_160[var20_217].column.getName()), var7_7, this.identifier(var15_173.getSchema().getName()), this.identifier(var15_173.getName()), this.identifier(var13_143[var20_217].column.getName()), String.valueOf(var20_217 + 1), String.valueOf(var18_206), String.valueOf(var19_212), this.identifier(var12_120.getName()), this.identifier(var12_120.getUniqueIndex().getName()), "7"});
                    }
                }
                break;
            }
            case 20: {
                for (SchemaObject var10_60 : this.database.getAllSchemaObjects(5)) {
                    var11_93 = (Constraint)var10_60;
                    var12_121 = var11_93.getConstraintType();
                    var13_144 = null;
                    var14_161 = null;
                    var15_174 = var11_93.getTable();
                    if (this.hideTable(var15_174, var1_1)) continue;
                    var16_187 = var11_93.getUniqueIndex();
                    var17_199 = null;
                    if (var16_187 != null) {
                        var17_199 = var16_187.getName();
                    }
                    if (!this.checkIndex(var1_1, var18_207 = this.identifier(var15_174.getName()), var4_4, var5_5)) continue;
                    if (var12_121 == Constraint.Type.CHECK) {
                        var13_144 = ((ConstraintCheck)var11_93).getExpression().getSQL();
                    } else if (var12_121 == Constraint.Type.UNIQUE || var12_121 == Constraint.Type.PRIMARY_KEY) {
                        var14_161 = ((ConstraintUnique)var11_93).getColumns();
                    } else if (var12_121 == Constraint.Type.REFERENTIAL) {
                        var14_161 = ((ConstraintReferential)var11_93).getColumns();
                    }
                    var19_213 = null;
                    if (var14_161 != null) {
                        var20_218 = new StatementBuilder();
                        for (IndexColumn var24_230 : var14_161) {
                            var20_218.appendExceptFirst(",");
                            var20_218.append(var24_230.column.getName());
                        }
                        var19_213 = var20_218.toString();
                    }
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_93.getSchema().getName()), this.identifier(var11_93.getName()), var12_121.toString(), var7_7, this.identifier(var15_174.getSchema().getName()), var18_207, var17_199, var13_144, var19_213, MetaTable.replaceNullWithEmpty(var11_93.getComment()), var11_93.getCreateSQL(), "" + var11_93.getId()});
                }
                break;
            }
            case 22: {
                for (SchemaObject var10_61 : this.database.getAllSchemaObjects(11)) {
                    var11_94 = (Constant)var10_61;
                    var12_122 = var11_94.getValue();
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_94.getSchema().getName()), this.identifier(var11_94.getName()), "" + DataType.convertTypeToSQLType(var12_122.getType()), MetaTable.replaceNullWithEmpty(var11_94.getComment()), var12_122.getSQL(), "" + var11_94.getId()});
                }
                break;
            }
            case 23: {
                for (UserDataType var10_62 : this.database.getAllUserDataTypes()) {
                    var11_95 = var10_62.getColumn();
                    this.add(var6_6, new String[]{var7_7, "PUBLIC", this.identifier(var10_62.getName()), var11_95.getDefaultSQL(), var11_95.isNullable() != false ? "YES" : "NO", "" + var11_95.getDataType().sqlType, "" + var11_95.getPrecisionAsInt(), "" + var11_95.getScale(), var11_95.getDataType().name, "" + var11_95.getSelectivity(), "" + var11_95.getCheckConstraintSQL(var1_1, "VALUE"), MetaTable.replaceNullWithEmpty(var10_62.getComment()), "" + var10_62.getCreateSQL(), "" + var10_62.getId()});
                }
                break;
            }
            case 24: {
                for (SchemaObject var10_63 : this.database.getAllSchemaObjects(4)) {
                    var11_96 = (TriggerObject)var10_63;
                    var12_123 = var11_96.getTable();
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_96.getSchema().getName()), this.identifier(var11_96.getName()), var11_96.getTypeNameList(), var7_7, this.identifier(var12_123.getSchema().getName()), this.identifier(var12_123.getName()), "" + var11_96.isBefore(), var11_96.getTriggerClassName(), "" + var11_96.getQueueSize(), "" + var11_96.isNoWait(), MetaTable.replaceNullWithEmpty(var11_96.getComment()), var11_96.getCreateSQL(), "" + var11_96.getId()});
                }
                break;
            }
            case 25: {
                var9_32 = System.currentTimeMillis();
                for (Session var14_162 : this.database.getSessions(false)) {
                    if (!var8_8 && var14_162 != var1_1) continue;
                    var15_175 = var14_162.getCurrentCommand();
                    var16_188 = var14_162.getCurrentCommandStart();
                    if (var16_188 == 0L) {
                        var16_188 = var9_32;
                    }
                    this.add(var6_6, new String[]{"" + var14_162.getId(), var14_162.getUser().getName(), new Timestamp(var14_162.getSessionStart()).toString(), var15_175 == null ? null : var15_175.toString(), new Timestamp(var16_188).toString(), "" + var14_162.containsUncommitted()});
                }
                break;
            }
            case 26: {
                for (Session var12_125 : this.database.getSessions(false)) {
                    if (!var8_8 && var12_125 != var1_1) continue;
                    for (Table var16_189 : var12_125.getLocks()) {
                        this.add(var6_6, new String[]{var16_189.getSchema().getName(), var16_189.getName(), "" + var12_125.getId(), var16_189.isLockedExclusivelyBy(var12_125) != false ? "WRITE" : "READ"});
                    }
                }
                break;
            }
            case 27: {
                for (String var12_126 : var1_1.getVariableNames()) {
                    var13_147 = var1_1.getVariable(var12_126);
                    this.add(var6_6, new String[]{"@" + var12_126, "SET @" + var12_126 + " " + var13_147.getSQL()});
                }
                for (Table var10_66 : var1_1.getLocalTempTables()) {
                    this.add(var6_6, new String[]{"TABLE " + var10_66.getName(), var10_66.getCreateSQL()});
                }
                var9_34 = var1_1.getSchemaSearchPath();
                if (var9_34 != null && var9_34.length > 0) {
                    var10_67 = new StatementBuilder("SET SCHEMA_SEARCH_PATH ");
                    for (Object var14_164 : var9_34) {
                        var10_67.appendExceptFirst(", ");
                        var10_67.append(StringUtils.quoteIdentifier((String)var14_164));
                    }
                    this.add(var6_6, new String[]{"SCHEMA_SEARCH_PATH", var10_67.toString()});
                }
                if ((var10_68 = var1_1.getCurrentSchemaName()) == null) break;
                this.add(var6_6, new String[]{"SCHEMA", "SET SCHEMA " + StringUtils.quoteIdentifier(var10_68)});
                break;
            }
            case 28: {
                var9_35 = this.database.getQueryStatisticsData();
                if (var9_35 == null) break;
                for (QueryStatisticsData.QueryEntry var11_101 : var9_35.getQueries()) {
                    this.add(var6_6, new String[]{var11_101.sqlStatement, "" + var11_101.count, "" + (double)var11_101.executionTimeMinNanos / 1000.0 / 1000.0, "" + (double)var11_101.executionTimeMaxNanos / 1000.0 / 1000.0, "" + (double)var11_101.executionTimeCumulativeNanos / 1000.0 / 1000.0, "" + var11_101.executionTimeMeanNanos / 1000.0 / 1000.0, "" + var11_101.getExecutionTimeStandardDeviation() / 1000.0 / 1000.0, "" + var11_101.rowCountMin, "" + var11_101.rowCountMax, "" + var11_101.rowCountCumulative, "" + var11_101.rowCountMean, "" + var11_101.getRowCountStandardDeviation()});
                }
                break;
            }
            case 29: {
                for (TableSynonym var10_70 : this.database.getAllSynonyms()) {
                    this.add(var6_6, new String[]{var7_7, this.identifier(var10_70.getSchema().getName()), this.identifier(var10_70.getName()), var10_70.getSynonymForName(), var10_70.getSynonymForSchema().getName(), "SYNONYM", "VALID", MetaTable.replaceNullWithEmpty(var10_70.getComment()), "" + var10_70.getId()});
                }
                break;
            }
            case 30: {
                for (SchemaObject var10_71 : this.database.getAllSchemaObjects(5)) {
                    var11_102 = (Constraint)var10_71;
                    var12_128 = var11_102.getConstraintType();
                    var13_149 = var11_102.getTable();
                    if (this.hideTable(var13_149, var1_1) || !this.checkIndex(var1_1, var14_165 = this.identifier(var13_149.getName()), var4_4, var5_5)) continue;
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_102.getSchema().getName()), this.identifier(var11_102.getName()), var12_128.getSqlName(), var7_7, this.identifier(var13_149.getSchema().getName()), var14_165, "NO", "NO"});
                }
                break;
            }
            case 31: {
                for (SchemaObject var10_72 : this.database.getAllSchemaObjects(5)) {
                    var11_103 = (Constraint)var10_72;
                    var12_129 = var11_103.getConstraintType();
                    var13_150 = null;
                    var14_166 = var11_103.getTable();
                    if (this.hideTable(var14_166, var1_1) || !this.checkIndex(var1_1, var15_177 = this.identifier(var14_166.getName()), var4_4, var5_5)) continue;
                    if (var12_129 == Constraint.Type.UNIQUE || var12_129 == Constraint.Type.PRIMARY_KEY) {
                        var13_150 = ((ConstraintUnique)var11_103).getColumns();
                    } else if (var12_129 == Constraint.Type.REFERENTIAL) {
                        var13_150 = ((ConstraintReferential)var11_103).getColumns();
                    }
                    if (var13_150 == null) continue;
                    var16_190 = var12_129 == Constraint.Type.REFERENTIAL ? MetaTable.lookupUniqueForReferential((ConstraintReferential)var11_103) : null;
                    for (var17_200 = 0; var17_200 < var13_150.length; ++var17_200) {
                        var18_208 = var13_150[var17_200];
                        var19_214 = Integer.toString(var17_200 + 1);
                        if (var12_129 != Constraint.Type.REFERENTIAL) ** GOTO lbl454
                        var20_219 = var19_214;
                        if (var16_190 == null) ** GOTO lbl455
                        var21_223 = ((ConstraintReferential)var11_103).getRefColumns()[var17_200].column;
                        var22_227 = var16_190.getColumns();
                        for (var23_229 = 0; var23_229 < var22_227.length; ++var23_229) {
                            if (!var22_227[var23_229].column.equals(var21_223)) continue;
                            var20_219 = Integer.toString(var23_229 + 1);
                            ** GOTO lbl455
                        }
                        ** GOTO lbl455
lbl454:
                        // 1 sources

                        var20_219 = null;
lbl455:
                        // 4 sources

                        this.add(var6_6, new String[]{var7_7, this.identifier(var11_103.getSchema().getName()), this.identifier(var11_103.getName()), var7_7, this.identifier(var14_166.getSchema().getName()), var15_177, var18_208.columnName, var19_214, var20_219});
                    }
                }
                break;
            }
            case 32: {
                for (SchemaObject var10_73 : this.database.getAllSchemaObjects(5)) {
                    if (((Constraint)var10_73).getConstraintType() != Constraint.Type.REFERENTIAL || this.hideTable(var12_130 = (var11_104 = (ConstraintReferential)var10_73).getTable(), var1_1)) continue;
                    var13_151 = MetaTable.lookupUniqueForReferential(var11_104);
                    if (var13_151 == null) {
                        var13_151 = var11_104.getUniqueIndex();
                    }
                    this.add(var6_6, new String[]{var7_7, this.identifier(var11_104.getSchema().getName()), this.identifier(var11_104.getName()), var7_7, this.identifier(var13_151.getSchema().getName()), var13_151.getName(), "NONE", var11_104.getUpdateAction().getSqlName(), var11_104.getDeleteAction().getSqlName()});
                }
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        return var6_6;
    }

    private static int getRefAction(ConstraintActionType constraintActionType) {
        switch (constraintActionType) {
            case CASCADE: {
                return 0;
            }
            case RESTRICT: {
                return 1;
            }
            case SET_DEFAULT: {
                return 4;
            }
            case SET_NULL: {
                return 2;
            }
        }
        throw DbException.throwInternalError("action=" + (Object)((Object)constraintActionType));
    }

    private static ConstraintUnique lookupUniqueForReferential(ConstraintReferential constraintReferential) {
        Table table = constraintReferential.getRefTable();
        for (Constraint constraint : table.getConstraints()) {
            ConstraintUnique constraintUnique;
            if (constraint.getConstraintType() != Constraint.Type.UNIQUE || !(constraintUnique = (ConstraintUnique)constraint).getReferencedColumns(table).equals(constraintReferential.getReferencedColumns(table))) continue;
            return constraintUnique;
        }
        return null;
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    private void addPrivileges(ArrayList<Row> arrayList, DbObject dbObject, String string2, Table table, String string3, int n) {
        if ((n & 1) != 0) {
            this.addPrivilege(arrayList, dbObject, string2, table, string3, "SELECT");
        }
        if ((n & 4) != 0) {
            this.addPrivilege(arrayList, dbObject, string2, table, string3, "INSERT");
        }
        if ((n & 8) != 0) {
            this.addPrivilege(arrayList, dbObject, string2, table, string3, "UPDATE");
        }
        if ((n & 2) != 0) {
            this.addPrivilege(arrayList, dbObject, string2, table, string3, "DELETE");
        }
    }

    private void addPrivilege(ArrayList<Row> arrayList, DbObject dbObject, String string2, Table table, String string3, String string4) {
        User user;
        String string5 = "NO";
        if (dbObject.getType() == 2 && (user = (User)dbObject).isAdmin()) {
            string5 = "YES";
        }
        if (string3 == null) {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string2, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), string4, string5);
        } else {
            this.add(arrayList, null, this.identifier(dbObject.getName()), string2, this.identifier(table.getSchema().getName()), this.identifier(table.getName()), this.identifier(string3), string4, string5);
        }
    }

    private void add(ArrayList<Row> arrayList, String ... stringArray) {
        Value[] valueArray = new Value[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Value value2 = string2 == null ? ValueNull.INSTANCE : ValueString.get(string2);
            Column column = this.columns[i];
            value2 = column.convert(value2);
            valueArray[i] = value2;
        }
        Row row = this.database.createRow(valueArray, 1);
        row.setKey(arrayList.size());
        arrayList.add(row);
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("META");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return false;
    }

    @Override
    public TableType getTableType() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index getScanIndex(Session session) {
        return new MetaIndex(this, IndexColumn.wrap(this.columns), true);
    }

    @Override
    public ArrayList<Index> getIndexes() {
        ArrayList<Index> arrayList = New.arrayList();
        if (this.metaIndex == null) {
            return arrayList;
        }
        arrayList.add(new MetaIndex(this, IndexColumn.wrap(this.columns), true));
        arrayList.add(this.metaIndex);
        return arrayList;
    }

    @Override
    public long getMaxDataModificationId() {
        switch (this.type) {
            case 6: 
            case 18: 
            case 25: 
            case 26: 
            case 27: {
                return Long.MAX_VALUE;
            }
        }
        return this.database.getModificationDataId();
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    public static int getMetaTableTypeCount() {
        return 33;
    }

    @Override
    public long getRowCountApproximation() {
        return 1000L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canReference() {
        return false;
    }
}

