/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class UpdatableRow {
    private final JdbcConnection conn;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ArrayList<String> key;
    private boolean isUpdatable;

    public UpdatableRow(JdbcConnection jdbcConnection, ResultInterface resultInterface) throws SQLException {
        String string2;
        Object object;
        this.conn = jdbcConnection;
        this.result = resultInterface;
        this.columnCount = resultInterface.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            object = resultInterface.getTableName(i);
            string2 = resultInterface.getSchemaName(i);
            if (object == null || string2 == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = object;
            } else if (!this.tableName.equals(object)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = string2;
                continue;
            }
            if (this.schemaName.equals(string2)) continue;
            return;
        }
        DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
        object = databaseMetaData.getTables(null, StringUtils.escapeMetaDataPattern(this.schemaName), StringUtils.escapeMetaDataPattern(this.tableName), new String[]{"TABLE"});
        if (!object.next()) {
            return;
        }
        if (object.getString("SQL") == null) {
            return;
        }
        string2 = object.getString("TABLE_NAME");
        boolean bl = !string2.equals(this.tableName) && string2.equalsIgnoreCase(this.tableName);
        this.key = New.arrayList();
        object = databaseMetaData.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName);
        while (object.next()) {
            String string3 = object.getString("COLUMN_NAME");
            this.key.add(bl ? StringUtils.toUpperEnglish(string3) : string3);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key.clear();
        object = databaseMetaData.getIndexInfo(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName, true, true);
        while (object.next()) {
            short s2 = object.getShort("ORDINAL_POSITION");
            if (s2 == 1) {
                if (this.isIndexUsable(this.key)) {
                    this.isUpdatable = true;
                    return;
                }
                this.key.clear();
            }
            String string4 = object.getString("COLUMN_NAME");
            this.key.add(bl ? StringUtils.toUpperEnglish(string4) : string4);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key = null;
    }

    private boolean isIndexUsable(ArrayList<String> arrayList) {
        if (arrayList.isEmpty()) {
            return false;
        }
        for (String string2 : arrayList) {
            if (this.findColumnIndex(string2) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int findColumnIndex(String string2) {
        for (int i = 0; i < this.columnCount; ++i) {
            String string3 = this.result.getColumnName(i);
            if (!string3.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    private int getColumnIndex(String string2) {
        int n = this.findColumnIndex(string2);
        if (n < 0) {
            throw DbException.get(42122, string2);
        }
        return n;
    }

    private void appendColumnList(StatementBuilder statementBuilder, boolean bl) {
        statementBuilder.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            statementBuilder.appendExceptFirst(",");
            String string2 = this.result.getColumnName(i);
            statementBuilder.append(StringUtils.quoteIdentifier(string2));
            if (!bl) continue;
            statementBuilder.append("=? ");
        }
    }

    private void appendKeyCondition(StatementBuilder statementBuilder) {
        statementBuilder.append(" WHERE ");
        statementBuilder.resetCount();
        for (String string2 : this.key) {
            statementBuilder.appendExceptFirst(" AND ");
            statementBuilder.append(StringUtils.quoteIdentifier(string2)).append("=?");
        }
    }

    private void setKey(PreparedStatement preparedStatement, int n, Value[] valueArray) throws SQLException {
        int n2 = this.key.size();
        for (int i = 0; i < n2; ++i) {
            String string2 = this.key.get(i);
            int n3 = this.getColumnIndex(string2);
            Value value2 = valueArray[n3];
            if (value2 == null || value2 == ValueNull.INSTANCE) {
                throw DbException.get(2000);
            }
            value2.set(preparedStatement, n + i);
        }
    }

    private void appendTableName(StatementBuilder statementBuilder) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            statementBuilder.append(StringUtils.quoteIdentifier(this.schemaName)).append('.');
        }
        statementBuilder.append(StringUtils.quoteIdentifier(this.tableName));
    }

    public Value[] readRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(" FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw DbException.get(2000);
        }
        Value[] valueArray2 = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int n = this.result.getColumnType(i);
            valueArray2[i] = DataType.readValue(this.conn.getSession(), resultSet, i + 1, n);
        }
        return valueArray2;
    }

    public void deleteRow(Value[] valueArray) throws SQLException {
        StatementBuilder statementBuilder = new StatementBuilder("DELETE FROM ");
        this.appendTableName(statementBuilder);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        this.setKey(preparedStatement, 1, valueArray);
        int n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }

    public void updateRow(Value[] valueArray, Value[] valueArray2) throws SQLException {
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        this.appendTableName(statementBuilder);
        statementBuilder.append(" SET ");
        this.appendColumnList(statementBuilder, true);
        this.appendKeyCondition(statementBuilder);
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        int n2 = 1;
        for (n = 0; n < this.columnCount; ++n) {
            Value value2 = valueArray2[n];
            if (value2 == null) {
                value2 = valueArray[n];
            }
            value2.set(preparedStatement, n2++);
        }
        this.setKey(preparedStatement, n2, valueArray);
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }

    public void insertRow(Value[] valueArray) throws SQLException {
        int n;
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        this.appendTableName(statementBuilder);
        statementBuilder.append('(');
        this.appendColumnList(statementBuilder, false);
        statementBuilder.append(")VALUES(");
        statementBuilder.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            statementBuilder.appendExceptFirst(",");
            Value value2 = valueArray[i];
            if (value2 == null) {
                statementBuilder.append("DEFAULT");
                continue;
            }
            statementBuilder.append('?');
        }
        statementBuilder.append(')');
        PreparedStatement preparedStatement = this.conn.prepareStatement(statementBuilder.toString());
        int n2 = 0;
        for (n = 0; n < this.columnCount; ++n) {
            Value value3 = valueArray[n];
            if (value3 == null) continue;
            value3.set(preparedStatement, n2++ + 1);
        }
        n = preparedStatement.executeUpdate();
        if (n != 1) {
            throw DbException.get(2000);
        }
    }
}

