/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import java.util.ArrayList;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultColumn;
import org.h2.result.ResultInterface;
import org.h2.util.New;
import org.h2.value.Transfer;
import org.h2.value.Value;

public class ResultRemote
implements ResultInterface {
    private int fetchSize;
    private SessionRemote session;
    private Transfer transfer;
    private int id;
    private final ResultColumn[] columns;
    private Value[] currentRow;
    private final int rowCount;
    private int rowId;
    private int rowOffset;
    private ArrayList<Value[]> result;
    private final Trace trace;

    public ResultRemote(SessionRemote sessionRemote, Transfer transfer, int n, int n2, int n3) throws IOException {
        this.session = sessionRemote;
        this.trace = sessionRemote.getTrace();
        this.transfer = transfer;
        this.id = n;
        this.columns = new ResultColumn[n2];
        this.rowCount = transfer.readInt();
        for (int i = 0; i < n2; ++i) {
            this.columns[i] = new ResultColumn(transfer);
        }
        this.rowId = -1;
        this.result = New.arrayList();
        this.fetchSize = n3;
        this.fetchRows(false);
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public String getAlias(int n) {
        return this.columns[n].alias;
    }

    @Override
    public String getSchemaName(int n) {
        return this.columns[n].schemaName;
    }

    @Override
    public String getTableName(int n) {
        return this.columns[n].tableName;
    }

    @Override
    public String getColumnName(int n) {
        return this.columns[n].columnName;
    }

    @Override
    public int getColumnType(int n) {
        return this.columns[n].columnType;
    }

    @Override
    public long getColumnPrecision(int n) {
        return this.columns[n].precision;
    }

    @Override
    public int getColumnScale(int n) {
        return this.columns[n].scale;
    }

    @Override
    public int getDisplaySize(int n) {
        return this.columns[n].displaySize;
    }

    @Override
    public boolean isAutoIncrement(int n) {
        return this.columns[n].autoIncrement;
    }

    @Override
    public int getNullable(int n) {
        return this.columns[n].nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.rowId = -1;
        this.currentRow = null;
        if (this.session == null) {
            return;
        }
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                this.session.traceOperation("RESULT_RESET", this.id);
                this.transfer.writeInt(6).writeInt(this.id).flush();
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (this.rowId < this.rowCount) {
            ++this.rowId;
            this.remapIfOld();
            if (this.rowId < this.rowCount) {
                if (this.rowId - this.rowOffset >= this.result.size()) {
                    this.fetchRows(true);
                }
                this.currentRow = this.result.get(this.rowId - this.rowOffset);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rowCount;
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean hasNext() {
        return this.rowId < this.rowCount - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClose() {
        if (this.session == null) {
            return;
        }
        try {
            SessionRemote sessionRemote = this.session;
            synchronized (sessionRemote) {
                this.session.traceOperation("RESULT_CLOSE", this.id);
                this.transfer.writeInt(7).writeInt(this.id);
            }
        }
        catch (IOException iOException) {
            this.trace.error(iOException, "close");
        }
        finally {
            this.transfer = null;
            this.session = null;
        }
    }

    @Override
    public void close() {
        this.result = null;
        this.sendClose();
    }

    private void remapIfOld() {
        if (this.session == null) {
            return;
        }
        try {
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS / 2) {
                int n = this.session.getNextId();
                this.session.traceOperation("CHANGE_ID", this.id);
                this.transfer.writeInt(9).writeInt(this.id).writeInt(n);
                this.id = n;
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRows(boolean bl) {
        SessionRemote sessionRemote = this.session;
        synchronized (sessionRemote) {
            this.session.checkClosed();
            try {
                boolean bl2;
                this.rowOffset += this.result.size();
                this.result.clear();
                int n = Math.min(this.fetchSize, this.rowCount - this.rowOffset);
                if (bl) {
                    this.session.traceOperation("RESULT_FETCH_ROWS", this.id);
                    this.transfer.writeInt(5).writeInt(this.id).writeInt(n);
                    this.session.done(this.transfer);
                }
                for (int i = 0; i < n && (bl2 = this.transfer.readBoolean()); ++i) {
                    int n2 = this.columns.length;
                    Value[] valueArray = new Value[n2];
                    for (int j = 0; j < n2; ++j) {
                        Value value2;
                        valueArray[j] = value2 = this.transfer.readValue();
                    }
                    this.result.add(valueArray);
                }
                if (this.rowOffset + this.result.size() >= this.rowCount) {
                    this.sendClose();
                }
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    public String toString() {
        return "columns: " + this.columns.length + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    @Override
    public boolean needToClose() {
        return true;
    }

    @Override
    public ResultInterface createShallowCopy(SessionInterface sessionInterface) {
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.result == null;
    }

    @Override
    public boolean containsDistinct(Value[] valueArray) {
        throw DbException.throwInternalError();
    }
}

