/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import org.h2.message.Trace;
import org.h2.message.TraceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceWriterAdapter
implements TraceWriter {
    private String name;
    private final Logger logger = LoggerFactory.getLogger("h2database");

    @Override
    public void setName(String string2) {
        this.name = string2;
    }

    @Override
    public boolean isEnabled(int n) {
        switch (n) {
            case 3: {
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isInfoEnabled();
            }
            case 1: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void write(int n, int n2, String string2, Throwable throwable2) {
        this.write(n, Trace.MODULE_NAMES[n2], string2, throwable2);
    }

    @Override
    public void write(int n, String string2, String string3, Throwable throwable2) {
        if (this.isEnabled(n)) {
            string3 = this.name != null ? this.name + ":" + string2 + " " + string3 : string2 + " " + string3;
            switch (n) {
                case 3: {
                    this.logger.debug(string3, throwable2);
                    break;
                }
                case 2: {
                    this.logger.info(string3, throwable2);
                    break;
                }
                case 1: {
                    this.logger.error(string3, throwable2);
                    break;
                }
            }
        }
    }
}

