/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.h2.api.ErrorCode;
import org.h2.jdbc.JdbcSQLException;
import org.h2.util.SortedProperties;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

public class DbException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final Properties MESSAGES = new Properties();
    private Object source;

    private DbException(SQLException sQLException) {
        super(sQLException.getMessage(), sQLException);
    }

    private static String translate(String string2, String ... stringArray) {
        String string3 = null;
        if (MESSAGES != null) {
            string3 = MESSAGES.getProperty(string2);
        }
        if (string3 == null) {
            string3 = "(Message " + string2 + " not found)";
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4 == null || string4.length() <= 0) continue;
                stringArray[i] = StringUtils.quoteIdentifier(string4);
            }
            string3 = MessageFormat.format(string3, stringArray);
        }
        return string3;
    }

    public SQLException getSQLException() {
        return (SQLException)this.getCause();
    }

    public int getErrorCode() {
        return this.getSQLException().getErrorCode();
    }

    public DbException addSQL(String string2) {
        SQLException sQLException = this.getSQLException();
        if (sQLException instanceof JdbcSQLException) {
            JdbcSQLException jdbcSQLException = (JdbcSQLException)sQLException;
            if (jdbcSQLException.getSQL() == null) {
                jdbcSQLException.setSQL(string2);
            }
            return this;
        }
        sQLException = new JdbcSQLException(sQLException.getMessage(), string2, sQLException.getSQLState(), sQLException.getErrorCode(), sQLException, null);
        return new DbException(sQLException);
    }

    public static DbException get(int n) {
        return DbException.get(n, (String)null);
    }

    public static DbException get(int n, String string2) {
        return DbException.get(n, new String[]{string2});
    }

    public static DbException get(int n, Throwable throwable2, String ... stringArray) {
        return new DbException(DbException.getJdbcSQLException(n, throwable2, stringArray));
    }

    public static DbException get(int n, String ... stringArray) {
        return new DbException(DbException.getJdbcSQLException(n, null, stringArray));
    }

    public static DbException fromUser(String string2, String string3) {
        return new DbException(new JdbcSQLException(string3, null, string2, 0, null, null));
    }

    public static DbException getSyntaxError(String string2, int n) {
        string2 = StringUtils.addAsterisk(string2, n);
        return DbException.get(42000, string2);
    }

    public static DbException getSyntaxError(String string2, int n, String string3) {
        string2 = StringUtils.addAsterisk(string2, n);
        return new DbException(DbException.getJdbcSQLException(42001, null, string2, string3));
    }

    public static DbException getUnsupportedException(String string2) {
        return DbException.get(50100, string2);
    }

    public static DbException getInvalidValueException(String string2, Object object) {
        return DbException.get(90008, object == null ? "null" : object.toString(), string2);
    }

    public static RuntimeException throwInternalError(String string2) {
        RuntimeException runtimeException = new RuntimeException(string2);
        DbException.traceThrowable(runtimeException);
        throw runtimeException;
    }

    public static RuntimeException throwInternalError() {
        return DbException.throwInternalError("Unexpected code path");
    }

    public static SQLException toSQLException(Throwable throwable2) {
        if (throwable2 instanceof SQLException) {
            return (SQLException)throwable2;
        }
        return DbException.convert(throwable2).getSQLException();
    }

    public static DbException convert(Throwable throwable2) {
        if (throwable2 instanceof DbException) {
            return (DbException)throwable2;
        }
        if (throwable2 instanceof SQLException) {
            return new DbException((SQLException)throwable2);
        }
        if (throwable2 instanceof InvocationTargetException) {
            return DbException.convertInvocation((InvocationTargetException)throwable2, null);
        }
        if (throwable2 instanceof IOException) {
            return DbException.get(90028, throwable2, throwable2.toString());
        }
        if (throwable2 instanceof OutOfMemoryError) {
            return DbException.get(90108, throwable2, new String[0]);
        }
        if (throwable2 instanceof StackOverflowError || throwable2 instanceof LinkageError) {
            return DbException.get(50000, throwable2, throwable2.toString());
        }
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        return DbException.get(50000, throwable2, throwable2.toString());
    }

    public static DbException convertInvocation(InvocationTargetException invocationTargetException, String string2) {
        Throwable throwable2 = invocationTargetException.getTargetException();
        if (throwable2 instanceof SQLException || throwable2 instanceof DbException) {
            return DbException.convert(throwable2);
        }
        string2 = string2 == null ? throwable2.getMessage() : string2 + ": " + throwable2.getMessage();
        return DbException.get(90105, throwable2, string2);
    }

    public static DbException convertIOException(IOException iOException, String string2) {
        if (string2 == null) {
            Throwable throwable2 = iOException.getCause();
            if (throwable2 instanceof DbException) {
                return (DbException)throwable2;
            }
            return DbException.get(90028, iOException, iOException.toString());
        }
        return DbException.get(90031, iOException, iOException.toString(), string2);
    }

    private static JdbcSQLException getJdbcSQLException(int n, Throwable throwable2, String ... stringArray) {
        String string2 = ErrorCode.getState(n);
        String string3 = DbException.translate(string2, stringArray);
        return new JdbcSQLException(string3, null, string2, n, throwable2, null);
    }

    public static IOException convertToIOException(Throwable throwable2) {
        JdbcSQLException jdbcSQLException;
        if (throwable2 instanceof IOException) {
            return (IOException)throwable2;
        }
        if (throwable2 instanceof JdbcSQLException && (jdbcSQLException = (JdbcSQLException)throwable2).getOriginalCause() != null) {
            throwable2 = jdbcSQLException.getOriginalCause();
        }
        return new IOException(throwable2.toString(), throwable2);
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public static void traceThrowable(Throwable throwable2) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            throwable2.printStackTrace(printWriter);
        }
    }

    static {
        try {
            byte[] byArray;
            String string2;
            byte[] byArray2 = Utils.getResource("/org/h2/res/_messages_en.prop");
            if (byArray2 != null) {
                MESSAGES.load(new ByteArrayInputStream(byArray2));
            }
            if (!"en".equals(string2 = Locale.getDefault().getLanguage()) && (byArray = Utils.getResource("/org/h2/res/_messages_" + string2 + ".prop")) != null) {
                SortedProperties sortedProperties = SortedProperties.fromLines(new String(byArray, StandardCharsets.UTF_8));
                for (Map.Entry<Object, Object> entry2 : sortedProperties.entrySet()) {
                    String string3 = (String)entry2.getKey();
                    String string4 = (String)entry2.getValue();
                    if (string4 == null || string4.startsWith("#")) continue;
                    String string5 = MESSAGES.getProperty(string3);
                    String string6 = string4 + "\n" + string5;
                    MESSAGES.put(string3, string6);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            DbException.traceThrowable(outOfMemoryError);
        }
        catch (IOException iOException) {
            DbException.traceThrowable(iOException);
        }
    }
}

