/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexCondition;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;

public class IndexCursor
implements Cursor {
    private Session session;
    private final TableFilter tableFilter;
    private Index index;
    private Table table;
    private IndexColumn[] indexColumns;
    private boolean alwaysFalse;
    private SearchRow start;
    private SearchRow end;
    private SearchRow intersects;
    private Cursor cursor;
    private Column inColumn;
    private int inListIndex;
    private Value[] inList;
    private ResultInterface inResult;
    private HashSet<Value> inResultTested;

    public IndexCursor(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setIndex(Index index2) {
        this.index = index2;
        this.table = index2.getTable();
        Column[] columnArray = this.table.getColumns();
        this.indexColumns = new IndexColumn[columnArray.length];
        IndexColumn[] indexColumnArray = index2.getIndexColumns();
        if (indexColumnArray != null) {
            int n = columnArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = index2.getColumnIndex(columnArray[i]);
                if (n2 < 0) continue;
                this.indexColumns[i] = indexColumnArray[n2];
            }
        }
    }

    public void prepare(Session session, ArrayList<IndexCondition> arrayList) {
        this.session = session;
        this.alwaysFalse = false;
        this.end = null;
        this.start = null;
        this.inList = null;
        this.inColumn = null;
        this.inResult = null;
        this.inResultTested = null;
        this.intersects = null;
        for (IndexCondition indexCondition : arrayList) {
            IndexColumn indexColumn;
            if (indexCondition.isAlwaysFalse()) {
                this.alwaysFalse = true;
                break;
            }
            if (this.index.isFindUsingFullTableScan()) continue;
            Column column = indexCondition.getColumn();
            if (indexCondition.getCompareType() == 9) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inList = indexCondition.getCurrentValueList(session);
                this.inListIndex = 0;
                continue;
            }
            if (indexCondition.getCompareType() == 10) {
                if (this.start != null || this.end != null || !this.canUseIndexForIn(column)) continue;
                this.inColumn = column;
                this.inResult = indexCondition.getCurrentResult();
                continue;
            }
            Value value2 = indexCondition.getCurrentValue(session);
            boolean bl = indexCondition.isStart();
            boolean bl2 = indexCondition.isEnd();
            boolean bl3 = indexCondition.isSpatialIntersects();
            int n = column.getColumnId();
            if (n >= 0 && (indexColumn = this.indexColumns[n]) != null && (indexColumn.sortType & 1) != 0) {
                boolean bl4 = bl;
                bl = bl2;
                bl2 = bl4;
            }
            if (bl) {
                this.start = this.getSearchRow(this.start, n, value2, true);
            }
            if (bl2) {
                this.end = this.getSearchRow(this.end, n, value2, false);
            }
            if (bl3) {
                this.intersects = this.getSpatialSearchRow(this.intersects, n, value2);
            }
            if ((bl || bl2) && !this.canUseIndexFor(this.inColumn)) {
                this.inColumn = null;
                this.inList = null;
                this.inResult = null;
            }
            if (this.session.getDatabase().getSettings().optimizeIsNull || !bl || !bl2 || value2 != ValueNull.INSTANCE) continue;
            this.alwaysFalse = true;
        }
        if (this.inColumn != null) {
            this.start = this.table.getTemplateRow();
        }
    }

    public void find(Session session, ArrayList<IndexCondition> arrayList) {
        this.prepare(session, arrayList);
        if (this.inColumn != null) {
            return;
        }
        if (!this.alwaysFalse) {
            this.cursor = this.intersects != null && this.index instanceof SpatialIndex ? ((SpatialIndex)this.index).findByGeometry(this.tableFilter, this.start, this.end, this.intersects) : this.index.find(this.tableFilter, this.start, this.end);
        }
    }

    private boolean canUseIndexForIn(Column column) {
        if (this.inColumn != null) {
            return false;
        }
        return this.canUseIndexFor(column);
    }

    private boolean canUseIndexFor(Column column) {
        IndexColumn[] indexColumnArray = this.index.getIndexColumns();
        if (indexColumnArray == null) {
            return true;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        return indexColumn == null || indexColumn.column == column;
    }

    private SearchRow getSpatialSearchRow(SearchRow searchRow, int n, Value value2) {
        if (searchRow == null) {
            searchRow = this.table.getTemplateRow();
        } else if (searchRow.getValue(n) != null) {
            ValueGeometry valueGeometry = (ValueGeometry)searchRow.getValue(n).convertTo(22);
            value2 = ((ValueGeometry)value2.convertTo(22)).getEnvelopeUnion(valueGeometry);
        }
        if (n < 0) {
            searchRow.setKey(value2.getLong());
        } else {
            searchRow.setValue(n, value2);
        }
        return searchRow;
    }

    private SearchRow getSearchRow(SearchRow searchRow, int n, Value value2, boolean bl) {
        if (searchRow == null) {
            searchRow = this.table.getTemplateRow();
        } else {
            value2 = this.getMax(searchRow.getValue(n), value2, bl);
        }
        if (n < 0) {
            searchRow.setKey(value2.getLong());
        } else {
            searchRow.setValue(n, value2);
        }
        return searchRow;
    }

    private Value getMax(Value value2, Value value3, boolean bl) {
        int n;
        if (value2 == null) {
            return value3;
        }
        if (value3 == null) {
            return value2;
        }
        if (this.session.getDatabase().getSettings().optimizeIsNull) {
            if (value2 == ValueNull.INSTANCE) {
                return value3;
            }
            if (value3 == ValueNull.INSTANCE) {
                return value2;
            }
        }
        if ((n = value2.compareTo(value3, this.table.getDatabase().getCompareMode())) == 0) {
            return value2;
        }
        if ((value2 == ValueNull.INSTANCE || value3 == ValueNull.INSTANCE) && this.session.getDatabase().getSettings().optimizeIsNull) {
            return null;
        }
        if (!bl) {
            n = -n;
        }
        return n > 0 ? value2 : value3;
    }

    public boolean isAlwaysFalse() {
        return this.alwaysFalse;
    }

    public SearchRow getStart() {
        return this.start;
    }

    public SearchRow getEnd() {
        return this.end;
    }

    @Override
    public Row get() {
        if (this.cursor == null) {
            return null;
        }
        return this.cursor.get();
    }

    @Override
    public SearchRow getSearchRow() {
        return this.cursor.getSearchRow();
    }

    @Override
    public boolean next() {
        while (true) {
            if (this.cursor == null) {
                this.nextCursor();
                if (this.cursor == null) {
                    return false;
                }
            }
            if (this.cursor.next()) {
                return true;
            }
            this.cursor = null;
        }
    }

    private void nextCursor() {
        block3: {
            block4: {
                if (this.inList == null) break block4;
                while (this.inListIndex < this.inList.length) {
                    Value value2;
                    if ((value2 = this.inList[this.inListIndex++]) == ValueNull.INSTANCE) continue;
                    this.find(value2);
                    break block3;
                }
                break block3;
            }
            if (this.inResult == null) break block3;
            while (this.inResult.next()) {
                Value value3 = this.inResult.currentRow()[0];
                if (value3 == ValueNull.INSTANCE) continue;
                if (this.inResultTested == null) {
                    this.inResultTested = new HashSet();
                }
                if (!this.inResultTested.add(value3)) continue;
                this.find(value3);
                break;
            }
        }
    }

    private void find(Value value2) {
        value2 = this.inColumn.convert(value2);
        int n = this.inColumn.getColumnId();
        this.start.setValue(n, value2);
        this.cursor = this.index.find(this.tableFilter, this.start, this.start);
    }

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

