/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Function;
import org.h2.expression.FunctionInfo;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.tools.SimpleResultSet;
import org.h2.util.MathUtils;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;

public class TableFunction
extends Function {
    private final boolean distinct;
    private final long rowCount;
    private Column[] columnList;

    TableFunction(Database database, FunctionInfo functionInfo, long l) {
        super(database, functionInfo);
        this.distinct = functionInfo.type == 224;
        this.rowCount = l;
    }

    @Override
    public Value getValue(Session session) {
        return this.getTable(session, this.args, false, this.distinct);
    }

    @Override
    protected void checkParameterCount(int n) {
        if (n < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder(this.getName());
        statementBuilder.append('(');
        int n = 0;
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(this.columnList[n++].getCreateSQL()).append('=').append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getName() {
        return this.distinct ? "TABLE_DISTINCT" : "TABLE";
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        return this.getTable(session, this.args, true, false);
    }

    public void setColumns(ArrayList<Column> arrayList) {
        this.columnList = arrayList.toArray(new Column[0]);
    }

    private ValueResultSet getTable(Session session, Expression[] expressionArray, boolean bl, boolean bl2) {
        Value[][] valueArrayArray;
        int n = this.columnList.length;
        Expression[] expressionArray2 = new Expression[n];
        Database database = session.getDatabase();
        for (int i = 0; i < n; ++i) {
            valueArrayArray = this.columnList[i];
            ExpressionColumn expressionColumn = new ExpressionColumn(database, (Column)valueArrayArray);
            expressionArray2[i] = expressionColumn;
        }
        LocalResult localResult = new LocalResult(session, expressionArray2, n);
        if (bl2) {
            localResult.setDistinct();
        }
        if (!bl) {
            Value[] valueArray;
            Value[] valueArray2;
            int n2;
            valueArrayArray = new Value[n][];
            int n3 = 0;
            for (n2 = 0; n2 < n; ++n2) {
                valueArray2 = expressionArray[n2].getValue(session);
                if (valueArray2 == ValueNull.INSTANCE) {
                    valueArrayArray[n2] = new Value[0];
                    continue;
                }
                ValueArray valueArray3 = (ValueArray)valueArray2.convertTo(17);
                valueArray = valueArray3.getList();
                valueArrayArray[n2] = valueArray;
                n3 = Math.max(n3, valueArray.length);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                valueArray2 = new Value[n];
                for (int i = 0; i < n; ++i) {
                    Value value2;
                    valueArray = valueArrayArray[i];
                    if (valueArray.length <= n2) {
                        value2 = ValueNull.INSTANCE;
                    } else {
                        Column column = this.columnList[i];
                        value2 = valueArray[n2];
                        value2 = column.convert(value2);
                        value2 = value2.convertPrecision(column.getPrecision(), false);
                        value2 = value2.convertScale(true, column.getScale());
                    }
                    valueArray2[i] = value2;
                }
                localResult.addRow(valueArray2);
            }
        }
        localResult.done();
        return ValueResultSet.get(TableFunction.getSimpleResultSet(localResult, Integer.MAX_VALUE));
    }

    private static SimpleResultSet getSimpleResultSet(LocalResult localResult, int n) {
        int n2;
        Object[] objectArray;
        int n3;
        int n4 = localResult.getVisibleColumnCount();
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.setAutoClose(false);
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray = localResult.getColumnName(n3);
            n2 = DataType.convertTypeToSQLType(localResult.getColumnType(n3));
            int n5 = MathUtils.convertLongToInt(localResult.getColumnPrecision(n3));
            int n6 = localResult.getColumnScale(n3);
            simpleResultSet.addColumn((String)objectArray, n2, n5, n6);
        }
        localResult.reset();
        for (n3 = 0; n3 < n && localResult.next(); ++n3) {
            objectArray = new Object[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                objectArray[n2] = localResult.currentRow()[n2].getObject();
            }
            simpleResultSet.addRow(objectArray);
        }
        return simpleResultSet;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        return TableFunction.getExpressionColumns(session, this.getTable(session, this.getArgs(), true, false).getResultSet());
    }
}

