/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import java.util.Comparator;
import org.h2.engine.Database;
import org.h2.expression.AggregateData;
import org.h2.util.ValueHashMap;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;

class AggregateDataHistogram
extends AggregateData {
    private long count;
    private ValueHashMap<AggregateDataHistogram> distinctValues;

    AggregateDataHistogram() {
    }

    @Override
    void add(Database database, int n, boolean bl, Value value2) {
        AggregateDataHistogram aggregateDataHistogram;
        if (this.distinctValues == null) {
            this.distinctValues = ValueHashMap.newInstance();
        }
        if ((aggregateDataHistogram = this.distinctValues.get(value2)) == null && this.distinctValues.size() < 10000) {
            aggregateDataHistogram = new AggregateDataHistogram();
            this.distinctValues.put(value2, aggregateDataHistogram);
        }
        if (aggregateDataHistogram != null) {
            ++aggregateDataHistogram.count;
        }
    }

    @Override
    Value getValue(Database database, int n, boolean bl) {
        Value value22;
        if (bl) {
            this.count = 0L;
            this.groupDistinct(database, n);
        }
        Value[] valueArray = new ValueArray[this.distinctValues.size()];
        int n2 = 0;
        for (Value value22 : this.distinctValues.keys()) {
            AggregateDataHistogram aggregateDataHistogram = this.distinctValues.get(value22);
            valueArray[n2] = ValueArray.get(new Value[]{value22, ValueLong.get(aggregateDataHistogram.count)});
            ++n2;
        }
        final CompareMode compareMode = database.getCompareMode();
        Arrays.sort(valueArray, new Comparator<ValueArray>(){

            @Override
            public int compare(ValueArray valueArray, ValueArray valueArray2) {
                Value value2 = valueArray.getList()[0];
                Value value3 = valueArray2.getList()[0];
                return value2.compareTo(value3, compareMode);
            }
        });
        value22 = ValueArray.get(valueArray);
        return value22.convertTo(n);
    }

    private void groupDistinct(Database database, int n) {
        if (this.distinctValues == null) {
            return;
        }
        this.count = 0L;
        for (Value value2 : this.distinctValues.keys()) {
            this.add(database, n, false, value2);
        }
    }
}

