/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.engine.Session;
import org.h2.expression.AggregateData;
import org.h2.expression.AggregateDataArrayCollecting;
import org.h2.expression.AggregateDataMedian;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Aggregate
extends Expression {
    private static final HashMap<String, AggregateType> AGGREGATES = new HashMap(26);
    private final AggregateType type;
    private final Select select;
    private final boolean distinct;
    private Expression on;
    private Expression groupConcatSeparator;
    private ArrayList<SelectOrderBy> groupConcatOrderList;
    private ArrayList<SelectOrderBy> arrayAggOrderList;
    private SortOrder groupConcatSort;
    private SortOrder arrayOrderSort;
    private int dataType;
    private int scale;
    private long precision;
    private int displaySize;
    private int lastGroupRowId;
    private Expression filterCondition;

    public Aggregate(AggregateType aggregateType, Expression expression, Select select, boolean bl) {
        this.type = aggregateType;
        this.on = expression;
        this.select = select;
        this.distinct = bl;
    }

    private static void addAggregate(String string2, AggregateType aggregateType) {
        AGGREGATES.put(string2, aggregateType);
    }

    public static AggregateType getAggregateType(String string2) {
        return AGGREGATES.get(string2);
    }

    public void setGroupConcatOrder(ArrayList<SelectOrderBy> arrayList) {
        this.groupConcatOrderList = arrayList;
    }

    public void setArrayAggOrder(ArrayList<SelectOrderBy> arrayList) {
        this.arrayAggOrderList = arrayList;
    }

    public void setGroupConcatSeparator(Expression expression) {
        this.groupConcatSeparator = expression;
    }

    public void setFilterCondition(Expression expression) {
        this.filterCondition = expression;
    }

    private SortOrder initOrder(ArrayList<SelectOrderBy> arrayList, Session session) {
        int n = arrayList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            SelectOrderBy selectOrderBy = arrayList.get(i);
            nArray[i] = i + 1;
            nArray2[i] = n2 = selectOrderBy.descending ? 1 : 0;
        }
        return new SortOrder(session.getDatabase(), nArray, nArray2, null);
    }

    @Override
    public void updateAggregate(Session session) {
        SelectOrderBy selectOrderBy;
        int n;
        Value[] valueArray;
        int n2;
        Value value2;
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n3 = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == n3) {
            return;
        }
        this.lastGroupRowId = n3;
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = AggregateData.create(this.type);
            hashMap.put(this, aggregateData);
        }
        Value value3 = value2 = this.on == null ? null : this.on.getValue(session);
        if (this.type == AggregateType.GROUP_CONCAT && value2 != ValueNull.INSTANCE) {
            value2 = value2.convertTo(13);
            if (this.groupConcatOrderList != null) {
                n2 = this.groupConcatOrderList.size();
                valueArray = new Value[1 + n2];
                valueArray[0] = value2;
                for (n = 0; n < n2; ++n) {
                    selectOrderBy = this.groupConcatOrderList.get(n);
                    valueArray[n + 1] = selectOrderBy.expression.getValue(session);
                }
                value2 = ValueArray.get(valueArray);
            }
        }
        if (this.type == AggregateType.ARRAY_AGG && value2 != ValueNull.INSTANCE && this.arrayAggOrderList != null) {
            n2 = this.arrayAggOrderList.size();
            valueArray = new Value[1 + n2];
            valueArray[0] = value2;
            for (n = 0; n < n2; ++n) {
                selectOrderBy = this.arrayAggOrderList.get(n);
                valueArray[n + 1] = selectOrderBy.expression.getValue(session);
            }
            value2 = ValueArray.get(valueArray);
        }
        if (this.filterCondition != null && !this.filterCondition.getBooleanValue(session)) {
            return;
        }
        aggregateData.add(session.getDatabase(), this.dataType, this.distinct, value2);
    }

    @Override
    public Value getValue(Session session) {
        HashMap<Expression, Object> hashMap;
        if (this.select.isQuickAggregateQuery()) {
            switch (this.type) {
                case COUNT: 
                case COUNT_ALL: {
                    Table table = this.select.getTopTableFilter().getTable();
                    return ValueLong.get(table.getRowCount(session));
                }
                case MIN: 
                case MAX: {
                    Cursor cursor;
                    SearchRow searchRow;
                    boolean bl = this.type == AggregateType.MIN;
                    Index index2 = this.getMinMaxColumnIndex();
                    int n = index2.getIndexColumns()[0].sortType;
                    if ((n & 1) != 0) {
                        bl = !bl;
                    }
                    Value value2 = (searchRow = (cursor = index2.findFirstOrLast(session, bl)).getSearchRow()) == null ? ValueNull.INSTANCE : searchRow.getValue(index2.getColumns()[0].getColumnId());
                    return value2;
                }
                case MEDIAN: {
                    return AggregateDataMedian.getResultFromIndex(session, this.on, this.dataType);
                }
            }
            DbException.throwInternalError("type=" + (Object)((Object)this.type));
        }
        if ((hashMap = this.select.getCurrentGroup()) == null) {
            throw DbException.get(90054, this.getSQL());
        }
        AggregateData aggregateData = (AggregateData)hashMap.get(this);
        if (aggregateData == null) {
            aggregateData = AggregateData.create(this.type);
        }
        Value value3 = aggregateData.getValue(session.getDatabase(), this.dataType, this.distinct);
        if (this.type == AggregateType.GROUP_CONCAT) {
            Object object;
            ArrayList<Value> arrayList = ((AggregateDataArrayCollecting)aggregateData).getList();
            if (arrayList == null || arrayList.isEmpty()) {
                return ValueNull.INSTANCE;
            }
            if (this.groupConcatOrderList != null) {
                object = this.groupConcatSort;
                Collections.sort(arrayList, new Comparator<Value>((SortOrder)object){
                    final /* synthetic */ SortOrder val$sortOrder;
                    {
                        this.val$sortOrder = sortOrder;
                    }

                    @Override
                    public int compare(Value value2, Value value3) {
                        Value[] valueArray = ((ValueArray)value2).getList();
                        Value[] valueArray2 = ((ValueArray)value3).getList();
                        return this.val$sortOrder.compare(valueArray, valueArray2);
                    }
                });
            }
            object = new StatementBuilder();
            String string2 = this.groupConcatSeparator == null ? "," : this.groupConcatSeparator.getValue(session).getString();
            for (Value value4 : arrayList) {
                String string3 = value4.getType() == 17 ? ((ValueArray)value4).getList()[0].getString() : value4.getString();
                if (string3 == null) continue;
                if (string2 != null) {
                    ((StatementBuilder)object).appendExceptFirst(string2);
                }
                ((StatementBuilder)object).append(string3);
            }
            value3 = ValueString.get(((StatementBuilder)object).toString());
        } else if (this.type == AggregateType.ARRAY_AGG) {
            ArrayList<Value> arrayList = ((AggregateDataArrayCollecting)aggregateData).getList();
            if (arrayList == null || arrayList.isEmpty()) {
                return ValueNull.INSTANCE;
            }
            if (this.arrayAggOrderList != null) {
                final SortOrder sortOrder = this.arrayOrderSort;
                Collections.sort(arrayList, new Comparator<Value>(){

                    @Override
                    public int compare(Value value2, Value value3) {
                        Value[] valueArray = ((ValueArray)value2).getList();
                        Value[] valueArray2 = ((ValueArray)value3).getList();
                        return sortOrder.compare(valueArray, valueArray2);
                    }
                });
            }
            value3 = ValueArray.get(arrayList.toArray(new Value[arrayList.size()]));
        }
        return value3;
    }

    @Override
    public int getType() {
        return this.dataType;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        if (this.on != null) {
            this.on.mapColumns(columnResolver, n);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression.mapColumns(columnResolver, n);
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.arrayAggOrderList) {
                selectOrderBy.expression.mapColumns(columnResolver, n);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.mapColumns(columnResolver, n);
        }
        if (this.filterCondition != null) {
            this.filterCondition.mapColumns(columnResolver, n);
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (this.on != null) {
            this.on = this.on.optimize(session);
            this.dataType = this.on.getType();
            this.scale = this.on.getScale();
            this.precision = this.on.getPrecision();
            this.displaySize = this.on.getDisplaySize();
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session);
            }
            this.groupConcatSort = this.initOrder(this.groupConcatOrderList, session);
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.arrayAggOrderList) {
                selectOrderBy.expression = selectOrderBy.expression.optimize(session);
            }
            this.arrayOrderSort = this.initOrder(this.arrayAggOrderList, session);
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator = this.groupConcatSeparator.optimize(session);
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(session);
        }
        switch (this.type) {
            case GROUP_CONCAT: {
                this.dataType = 13;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case COUNT: 
            case COUNT_ALL: {
                this.dataType = 5;
                this.scale = 0;
                this.precision = 19L;
                this.displaySize = 20;
                break;
            }
            case SELECTIVITY: {
                this.dataType = 4;
                this.scale = 0;
                this.precision = 10L;
                this.displaySize = 11;
                break;
            }
            case HISTOGRAM: {
                this.dataType = 17;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case SUM: {
                if (this.dataType == 1) {
                    this.dataType = 5;
                    break;
                }
                if (!DataType.supportsAdd(this.dataType)) {
                    throw DbException.get(90015, this.getSQL());
                }
                this.dataType = DataType.getAddProofType(this.dataType);
                break;
            }
            case AVG: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case MIN: 
            case MAX: 
            case MEDIAN: {
                break;
            }
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VAR_POP: 
            case VAR_SAMP: {
                this.dataType = 7;
                this.precision = 17L;
                this.displaySize = 24;
                this.scale = 0;
                break;
            }
            case BOOL_AND: 
            case BOOL_OR: {
                this.dataType = 1;
                this.precision = 1L;
                this.displaySize = 5;
                this.scale = 0;
                break;
            }
            case BIT_AND: 
            case BIT_OR: {
                if (DataType.supportsAdd(this.dataType)) break;
                throw DbException.get(90015, this.getSQL());
            }
            case ARRAY_AGG: {
                this.dataType = 17;
                this.scale = 0;
                this.displaySize = Integer.MAX_VALUE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.type));
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        if (this.on != null) {
            this.on.setEvaluatable(tableFilter, bl);
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.arrayAggOrderList) {
                selectOrderBy.expression.setEvaluatable(tableFilter, bl);
            }
        }
        if (this.groupConcatSeparator != null) {
            this.groupConcatSeparator.setEvaluatable(tableFilter, bl);
        }
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public int getDisplaySize() {
        return this.displaySize;
    }

    private String getSQLGroupConcat() {
        StatementBuilder statementBuilder = new StatementBuilder("GROUP_CONCAT(");
        if (this.distinct) {
            statementBuilder.append("DISTINCT ");
        }
        statementBuilder.append(this.on.getSQL());
        if (this.groupConcatOrderList != null) {
            statementBuilder.append(" ORDER BY ");
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(selectOrderBy.expression.getSQL());
                if (!selectOrderBy.descending) continue;
                statementBuilder.append(" DESC");
            }
        }
        if (this.groupConcatSeparator != null) {
            statementBuilder.append(" SEPARATOR ").append(this.groupConcatSeparator.getSQL());
        }
        statementBuilder.append(')');
        if (this.filterCondition != null) {
            statementBuilder.append(" FILTER (WHERE ").append(this.filterCondition.getSQL()).append(')');
        }
        return statementBuilder.toString();
    }

    private String getSQLArrayAggregate() {
        StatementBuilder statementBuilder = new StatementBuilder("ARRAY_AGG(");
        if (this.distinct) {
            statementBuilder.append("DISTINCT ");
        }
        statementBuilder.append(this.on.getSQL());
        if (this.arrayAggOrderList != null) {
            statementBuilder.append(" ORDER BY ");
            for (SelectOrderBy selectOrderBy : this.arrayAggOrderList) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(selectOrderBy.expression.getSQL());
                if (!selectOrderBy.descending) continue;
                statementBuilder.append(" DESC");
            }
        }
        statementBuilder.append(')');
        if (this.filterCondition != null) {
            statementBuilder.append(" FILTER (WHERE ").append(this.filterCondition.getSQL()).append(')');
        }
        return statementBuilder.toString();
    }

    @Override
    public String getSQL() {
        String string2;
        switch (this.type) {
            case GROUP_CONCAT: {
                return this.getSQLGroupConcat();
            }
            case COUNT_ALL: {
                return "COUNT(*)";
            }
            case COUNT: {
                string2 = "COUNT";
                break;
            }
            case SELECTIVITY: {
                string2 = "SELECTIVITY";
                break;
            }
            case HISTOGRAM: {
                string2 = "HISTOGRAM";
                break;
            }
            case SUM: {
                string2 = "SUM";
                break;
            }
            case MIN: {
                string2 = "MIN";
                break;
            }
            case MAX: {
                string2 = "MAX";
                break;
            }
            case AVG: {
                string2 = "AVG";
                break;
            }
            case STDDEV_POP: {
                string2 = "STDDEV_POP";
                break;
            }
            case STDDEV_SAMP: {
                string2 = "STDDEV_SAMP";
                break;
            }
            case VAR_POP: {
                string2 = "VAR_POP";
                break;
            }
            case VAR_SAMP: {
                string2 = "VAR_SAMP";
                break;
            }
            case BOOL_AND: {
                string2 = "BOOL_AND";
                break;
            }
            case BOOL_OR: {
                string2 = "BOOL_OR";
                break;
            }
            case BIT_AND: {
                string2 = "BIT_AND";
                break;
            }
            case BIT_OR: {
                string2 = "BIT_OR";
                break;
            }
            case MEDIAN: {
                string2 = "MEDIAN";
                break;
            }
            case ARRAY_AGG: {
                return this.getSQLArrayAggregate();
            }
            default: {
                throw DbException.throwInternalError("type=" + (Object)((Object)this.type));
            }
        }
        string2 = this.distinct ? string2 + "(DISTINCT " + this.on.getSQL() + ')' : string2 + StringUtils.enclose(this.on.getSQL());
        if (this.filterCondition != null) {
            string2 = string2 + " FILTER (WHERE " + this.filterCondition.getSQL() + ')';
        }
        return string2;
    }

    private Index getMinMaxColumnIndex() {
        if (this.on instanceof ExpressionColumn) {
            ExpressionColumn expressionColumn = (ExpressionColumn)this.on;
            Column column = expressionColumn.getColumn();
            TableFilter tableFilter = expressionColumn.getTableFilter();
            if (tableFilter != null) {
                Table table = tableFilter.getTable();
                return table.getIndexForColumn(column, true, false);
            }
        }
        return null;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (this.filterCondition != null && !this.filterCondition.isEverything(expressionVisitor)) {
            return false;
        }
        if (expressionVisitor.getType() == 1) {
            switch (this.type) {
                case COUNT: {
                    if (!this.distinct && this.on.getNullable() == 0) {
                        return expressionVisitor.getTable().canGetRowCount();
                    }
                    return false;
                }
                case COUNT_ALL: {
                    return expressionVisitor.getTable().canGetRowCount();
                }
                case MIN: 
                case MAX: {
                    Index index2 = this.getMinMaxColumnIndex();
                    return index2 != null;
                }
                case MEDIAN: {
                    if (this.distinct) {
                        return false;
                    }
                    return AggregateDataMedian.getMedianColumnIndex(this.on) != null;
                }
            }
            return false;
        }
        if (this.on != null && !this.on.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.groupConcatSeparator != null && !this.groupConcatSeparator.isEverything(expressionVisitor)) {
            return false;
        }
        if (this.groupConcatOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.groupConcatOrderList) {
                if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
                return false;
            }
        }
        if (this.arrayAggOrderList != null) {
            for (SelectOrderBy selectOrderBy : this.arrayAggOrderList) {
                if (selectOrderBy.expression.isEverything(expressionVisitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = 1;
        if (this.on != null) {
            n += this.on.getCost();
        }
        if (this.filterCondition != null) {
            n += this.filterCondition.getCost();
        }
        return n;
    }

    static {
        Aggregate.addAggregate("COUNT", AggregateType.COUNT);
        Aggregate.addAggregate("SUM", AggregateType.SUM);
        Aggregate.addAggregate("MIN", AggregateType.MIN);
        Aggregate.addAggregate("MAX", AggregateType.MAX);
        Aggregate.addAggregate("AVG", AggregateType.AVG);
        Aggregate.addAggregate("GROUP_CONCAT", AggregateType.GROUP_CONCAT);
        Aggregate.addAggregate("STRING_AGG", AggregateType.GROUP_CONCAT);
        Aggregate.addAggregate("STDDEV_SAMP", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV", AggregateType.STDDEV_SAMP);
        Aggregate.addAggregate("STDDEV_POP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("STDDEVP", AggregateType.STDDEV_POP);
        Aggregate.addAggregate("VAR_POP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VARP", AggregateType.VAR_POP);
        Aggregate.addAggregate("VAR_SAMP", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VAR", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("VARIANCE", AggregateType.VAR_SAMP);
        Aggregate.addAggregate("BOOL_OR", AggregateType.BOOL_OR);
        Aggregate.addAggregate("SOME", AggregateType.BOOL_OR);
        Aggregate.addAggregate("BOOL_AND", AggregateType.BOOL_AND);
        Aggregate.addAggregate("EVERY", AggregateType.BOOL_AND);
        Aggregate.addAggregate("SELECTIVITY", AggregateType.SELECTIVITY);
        Aggregate.addAggregate("HISTOGRAM", AggregateType.HISTOGRAM);
        Aggregate.addAggregate("BIT_OR", AggregateType.BIT_OR);
        Aggregate.addAggregate("BIT_AND", AggregateType.BIT_AND);
        Aggregate.addAggregate("MEDIAN", AggregateType.MEDIAN);
        Aggregate.addAggregate("ARRAY_AGG", AggregateType.ARRAY_AGG);
    }

    public static enum AggregateType {
        COUNT_ALL,
        COUNT,
        GROUP_CONCAT,
        SUM,
        MIN,
        MAX,
        AVG,
        STDDEV_POP,
        STDDEV_SAMP,
        VAR_POP,
        VAR_SAMP,
        BOOL_OR,
        BOOL_AND,
        BIT_OR,
        BIT_AND,
        SELECTIVITY,
        HISTOGRAM,
        MEDIAN,
        ARRAY_AGG;

    }
}

