/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.ResultSet;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

public class Call
extends Prepared {
    private boolean isResultSet;
    private Expression expression;
    private Expression[] expressions;

    public Call(Session session) {
        super(session);
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult localResult;
        if (this.isResultSet) {
            Expression[] expressionArray = this.expression.getExpressionColumns(this.session);
            localResult = new LocalResult(this.session, expressionArray, expressionArray.length);
        } else {
            localResult = new LocalResult(this.session, this.expressions, 1);
        }
        localResult.done();
        return localResult;
    }

    @Override
    public int update() {
        Value value2 = this.expression.getValue(this.session);
        int n = value2.getType();
        switch (n) {
            case 18: {
                return super.update();
            }
            case -1: 
            case 0: {
                return 0;
            }
        }
        return value2.getInt();
    }

    @Override
    public ResultInterface query(int n) {
        this.setCurrentRowNumber(1);
        Value value2 = this.expression.getValue(this.session);
        if (this.isResultSet) {
            value2 = value2.convertTo(18);
            ResultSet resultSet = value2.getResultSet();
            return LocalResult.read(this.session, resultSet, n);
        }
        LocalResult localResult = new LocalResult(this.session, this.expressions, 1);
        Value[] valueArray = new Value[]{value2};
        localResult.addRow(valueArray);
        localResult.done();
        return localResult;
    }

    @Override
    public void prepare() {
        this.expression = this.expression.optimize(this.session);
        this.expressions = new Expression[]{this.expression};
        boolean bl = this.isResultSet = this.expression.getType() == 18;
        if (this.isResultSet) {
            this.prepareAlways = true;
        }
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return this.expression.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    public boolean isCacheable() {
        return !this.isResultSet;
    }
}

