/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class AlterTableRename
extends SchemaCommand {
    private boolean ifTableExists;
    private String oldTableName;
    private String newTableName;
    private boolean hidden;

    public AlterTableRename(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfTableExists(boolean bl) {
        this.ifTableExists = bl;
    }

    public void setOldTableName(String string2) {
        this.oldTableName = string2;
    }

    public void setNewTableName(String string2) {
        this.newTableName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.oldTableName);
        if (table == null) {
            if (this.ifTableExists) {
                return 0;
            }
            throw DbException.get(42102, this.oldTableName);
        }
        this.session.getUser().checkRight(table, 15);
        Table table2 = this.getSchema().findTableOrView(this.session, this.newTableName);
        if (table2 != null && this.hidden && this.newTableName.equals(table.getName())) {
            if (!table2.isHidden()) {
                table2.setHidden(this.hidden);
                table.setHidden(true);
                database.updateMeta(this.session, table);
            }
            return 0;
        }
        if (table2 != null || this.newTableName.equals(table.getName())) {
            throw DbException.get(42101, this.newTableName);
        }
        if (table.isTemporary()) {
            throw DbException.getUnsupportedException("temp table");
        }
        database.renameSchemaObject(this.session, table, this.newTableName);
        return 0;
    }

    @Override
    public int getType() {
        return 15;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }
}

