/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Query;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.table.TableView;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    CommandContainer(Parser parser, String string2, Prepared prepared) {
        super(parser, string2);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    @Override
    public void prepareJoinBatch() {
        if (this.session.isJoinBatchEnabled()) {
            CommandContainer.prepareJoinBatch(this.prepared);
        }
    }

    private static void prepareJoinBatch(Prepared prepared) {
        if (prepared.isQuery()) {
            int n = prepared.getType();
            if (n == 66) {
                ((Query)prepared).prepareJoinBatch();
            } else if (n == 60 || n == 86) {
                CommandContainer.prepareJoinBatch(((Explain)prepared).getCommand());
            }
        }
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string2 = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string2);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList.get(i);
                if (!parameter.isValueSet()) continue;
                Value value2 = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(i);
                parameter2.setValue(value2);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
            this.prepareJoinBatch();
        }
    }

    @Override
    public int update() {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        int n = this.prepared.update();
        this.prepared.trace(this.startTimeNanos, n);
        this.setProgress(6);
        return n;
    }

    @Override
    public ResultInterface query(int n) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTimeNanos, resultInterface.isLazy() ? 0 : resultInterface.getRowCount());
        this.setProgress(6);
        return resultInterface;
    }

    @Override
    public void stop() {
        super.stop();
        if (this.prepared.getCteCleanups() != null) {
            for (TableView tableView : this.prepared.getCteCleanups()) {
                if (tableView.getName() == null) continue;
                this.session.removeLocalTempTable(tableView);
            }
        }
    }

    @Override
    public boolean canReuse() {
        return super.canReuse() && this.prepared.getCteCleanups() == null;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

