/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf.context;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.bnf.context.DbContents;

public class DbColumn {
    private final String name;
    private final String quotedName;
    private final String dataType;
    private final int position;

    private DbColumn(DbContents dbContents, ResultSet resultSet, boolean bl) throws SQLException {
        this.name = resultSet.getString("COLUMN_NAME");
        this.quotedName = dbContents.quoteIdentifier(this.name);
        String string2 = resultSet.getString("TYPE_NAME");
        String string3 = bl ? "PRECISION" : "COLUMN_SIZE";
        int n = resultSet.getInt(string3);
        this.position = resultSet.getInt("ORDINAL_POSITION");
        boolean bl2 = dbContents.isSQLite();
        if (n > 0 && !bl2) {
            string2 = string2 + "(" + n;
            String string4 = bl ? "SCALE" : "DECIMAL_DIGITS";
            int n2 = resultSet.getInt(string4);
            if (n2 > 0) {
                string2 = string2 + ", " + n2;
            }
            string2 = string2 + ")";
        }
        if (resultSet.getInt("NULLABLE") == 0) {
            string2 = string2 + " NOT NULL";
        }
        this.dataType = string2;
    }

    public static DbColumn getProcedureColumn(DbContents dbContents, ResultSet resultSet) throws SQLException {
        return new DbColumn(dbContents, resultSet, true);
    }

    public static DbColumn getColumn(DbContents dbContents, ResultSet resultSet) throws SQLException {
        return new DbColumn(dbContents, resultSet, false);
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quotedName;
    }

    public int getPosition() {
        return this.position;
    }
}

