/*
 * Decompiled with CFR 0.152.
 */
package org.h2.bnf;

import java.util.HashMap;
import org.h2.bnf.Bnf;
import org.h2.bnf.BnfVisitor;
import org.h2.bnf.Rule;
import org.h2.bnf.RuleHead;
import org.h2.bnf.Sentence;
import org.h2.util.StringUtils;

public class RuleElement
implements Rule {
    private final boolean keyword;
    private final String name;
    private Rule link;
    private final int type;

    public RuleElement(String string2, String string3) {
        this.name = string2;
        this.keyword = string2.length() == 1 || string2.equals(StringUtils.toUpperEnglish(string2));
        string3 = StringUtils.toLowerEnglish(string3);
        this.type = string3.startsWith("function") ? 2 : 1;
    }

    @Override
    public void accept(BnfVisitor bnfVisitor) {
        bnfVisitor.visitRuleElement(this.keyword, this.name, this.link);
    }

    @Override
    public void setLinks(HashMap<String, RuleHead> hashMap) {
        if (this.link != null) {
            this.link.setLinks(hashMap);
        }
        if (this.keyword) {
            return;
        }
        String string2 = Bnf.getRuleMapKey(this.name);
        for (int i = 0; i < string2.length(); ++i) {
            String string3 = string2.substring(i);
            RuleHead ruleHead = hashMap.get(string3);
            if (ruleHead == null) continue;
            this.link = ruleHead.getRule();
            return;
        }
        throw new AssertionError((Object)("Unknown " + this.name + "/" + string2));
    }

    @Override
    public boolean autoComplete(Sentence sentence) {
        sentence.stopIfRequired();
        if (this.keyword) {
            String string2 = sentence.getQuery();
            String string3 = string2.trim();
            String string4 = sentence.getQueryUpper().trim();
            if (string4.startsWith(this.name)) {
                string2 = string2.substring(this.name.length());
                while (!"_".equals(this.name) && Bnf.startWithSpace(string2)) {
                    string2 = string2.substring(1);
                }
                sentence.setQuery(string2);
                return true;
            }
            if ((string3.length() == 0 || this.name.startsWith(string4)) && string3.length() < this.name.length()) {
                sentence.add(this.name, this.name.substring(string3.length()), this.type);
            }
            return false;
        }
        return this.link.autoComplete(sentence);
    }
}

