/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.ignite;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.zeppelin.ignite.IgniteInterpreterUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Console;
import scala.Some;
import scala.collection.JavaConversions;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.IMain;
import scala.tools.nsc.interpreter.Results;
import scala.tools.nsc.interpreter.Results$Incomplete$;
import scala.tools.nsc.interpreter.Results$Success$;
import scala.tools.nsc.settings.MutableSettings;

public class IgniteInterpreter
extends Interpreter {
    static final String IGNITE_ADDRESSES = "ignite.addresses";
    static final String IGNITE_CLIENT_MODE = "ignite.clientMode";
    static final String IGNITE_PEER_CLASS_LOADING_ENABLED = "ignite.peerClassLoadingEnabled";
    static final String IGNITE_CFG_URL = "ignite.config.url";
    private Logger logger = LoggerFactory.getLogger(IgniteInterpreter.class);
    private Ignite ignite;
    private ByteArrayOutputStream out;
    private IMain imain;
    private Throwable initEx;

    public IgniteInterpreter(Properties property) {
        super(property);
    }

    public void open() {
        Settings settings2 = new Settings();
        URL[] urls = this.getClassloaderUrls();
        MutableSettings.PathSetting pathSettings = settings2.classpath();
        StringBuilder sb = new StringBuilder();
        for (File f2 : this.currentClassPath()) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(f2.getAbsolutePath());
        }
        if (urls != null) {
            for (URL u : urls) {
                if (sb.length() > 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(u.getFile());
            }
        }
        pathSettings.v_$eq(sb.toString());
        settings2.scala$tools$nsc$settings$ScalaSettings$_setter_$classpath_$eq(pathSettings);
        settings2.explicitParentLoader_$eq(new Some<ClassLoader>(Thread.currentThread().getContextClassLoader()));
        MutableSettings.BooleanSetting b = (MutableSettings.BooleanSetting)settings2.usejavacp();
        b.v_$eq(true);
        settings2.scala$tools$nsc$settings$StandardScalaSettings$_setter_$usejavacp_$eq(b);
        this.out = new ByteArrayOutputStream();
        this.imain = new IMain(settings2, new PrintWriter(this.out));
        this.initIgnite();
    }

    private List<File> currentClassPath() {
        String[] cps;
        List<File> paths = this.classPath(Thread.currentThread().getContextClassLoader());
        for (String cp : cps = System.getProperty("java.class.path").split(File.pathSeparator)) {
            paths.add(new File(cp));
        }
        return paths;
    }

    private List<File> classPath(ClassLoader cl) {
        URLClassLoader ucl;
        URL[] urls;
        LinkedList<File> paths = new LinkedList<File>();
        if (cl == null) {
            return paths;
        }
        if (cl instanceof URLClassLoader && (urls = (ucl = (URLClassLoader)cl).getURLs()) != null) {
            for (URL url : urls) {
                paths.add(new File(url.getFile()));
            }
        }
        return paths;
    }

    public Object getLastObject() {
        Object obj = this.imain.lastRequest().lineRep().call("$result", JavaConversions.asScalaBuffer(new LinkedList()));
        return obj;
    }

    private Ignite getIgnite() {
        if (this.ignite == null) {
            try {
                String cfgUrl = this.getProperty(IGNITE_CFG_URL);
                if (cfgUrl != null && !cfgUrl.isEmpty()) {
                    this.ignite = Ignition.start(new URL(cfgUrl));
                } else {
                    IgniteConfiguration conf = new IgniteConfiguration();
                    conf.setClientMode(Boolean.parseBoolean(this.getProperty(IGNITE_CLIENT_MODE)));
                    TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder();
                    ipFinder.setAddresses(this.getAddresses());
                    TcpDiscoverySpi discoSpi = new TcpDiscoverySpi();
                    discoSpi.setIpFinder(ipFinder);
                    conf.setDiscoverySpi(discoSpi);
                    conf.setPeerClassLoadingEnabled(Boolean.parseBoolean(this.getProperty(IGNITE_PEER_CLASS_LOADING_ENABLED)));
                    this.ignite = Ignition.start(conf);
                }
                this.initEx = null;
            }
            catch (Exception e) {
                this.logger.error("Error in IgniteInterpreter while getIgnite: ", e);
                this.initEx = e;
            }
        }
        return this.ignite;
    }

    private void initIgnite() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            this.imain.interpret("@transient var _binder = new java.util.HashMap[String, Object]()");
            Map binder = (Map)this.getLastObject();
            if (this.getIgnite() != null) {
                binder.put("ignite", this.ignite);
                this.imain.interpret("@transient val ignite = _binder.get(\"ignite\").asInstanceOf[org.apache.ignite.Ignite]");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public void close() {
        this.initEx = null;
        if (this.ignite != null) {
            this.ignite.close();
            this.ignite = null;
        }
        if (this.imain != null) {
            this.imain.close();
            this.imain = null;
        }
    }

    private List<String> getAddresses() {
        String prop = this.getProperty(IGNITE_ADDRESSES);
        if (prop == null || prop.isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = prop.split(",");
        ArrayList<String> addresses = new ArrayList<String>(tokens.length);
        Collections.addAll(addresses, tokens);
        return addresses;
    }

    public InterpreterResult interpret(String line, InterpreterContext context) {
        if (this.initEx != null) {
            return IgniteInterpreterUtils.buildErrorResult(this.initEx);
        }
        if (line == null || line.trim().length() == 0) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        return this.interpret(line.split("\n"));
    }

    public void cancel(InterpreterContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult interpret(String[] lines2) {
        String[] linesToRun = new String[lines2.length + 1];
        System.arraycopy(lines2, 0, linesToRun, 0, lines2.length);
        linesToRun[lines2.length] = "print(\"\")";
        Console.setOut(this.out);
        this.out.reset();
        InterpreterResult.Code code2 = null;
        String incomplete = "";
        for (int l = 0; l < linesToRun.length; ++l) {
            String nextLine;
            String s2 = linesToRun[l];
            if (l + 1 < linesToRun.length && (nextLine = linesToRun[l + 1].trim()).startsWith(".") && !nextLine.startsWith("..") && !nextLine.startsWith("./")) {
                incomplete = incomplete + s2 + "\n";
                continue;
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                code2 = this.getResultCode(this.imain.interpret(incomplete + s2));
            }
            catch (Exception e) {
                this.logger.info("Interpreter exception", e);
                InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, InterpreterUtils.getMostRelevantMessage((Exception)e));
                return interpreterResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            if (code2 == InterpreterResult.Code.ERROR) {
                return new InterpreterResult(code2, this.out.toString());
            }
            incomplete = code2 == InterpreterResult.Code.INCOMPLETE ? incomplete + s2 + '\n' : "";
        }
        if (code2 == InterpreterResult.Code.INCOMPLETE) {
            return new InterpreterResult(code2, "Incomplete expression");
        }
        return new InterpreterResult(code2, this.out.toString());
    }

    private InterpreterResult.Code getResultCode(Results.Result res) {
        if (res instanceof Results$Success$) {
            return InterpreterResult.Code.SUCCESS;
        }
        if (res instanceof Results$Incomplete$) {
            return InterpreterResult.Code.INCOMPLETE;
        }
        return InterpreterResult.Code.ERROR;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) {
        return new LinkedList<InterpreterCompletion>();
    }

    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler(IgniteInterpreter.class.getName() + ((Object)((Object)this)).hashCode());
    }
}

