/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.AbstractPagedMutable;
import org.apache.lucene.util.packed.PackedInts;

public final class PagedMutable
extends AbstractPagedMutable<PagedMutable> {
    final PackedInts.Format format;

    public PagedMutable(long size2, int pageSize, int bitsPerValue, float acceptableOverheadRatio) {
        this(size2, pageSize, PackedInts.fastestFormatAndBits(pageSize, bitsPerValue, acceptableOverheadRatio));
        this.fillPages();
    }

    PagedMutable(long size2, int pageSize, PackedInts.FormatAndBits formatAndBits) {
        this(size2, pageSize, formatAndBits.bitsPerValue, formatAndBits.format);
    }

    PagedMutable(long size2, int pageSize, int bitsPerValue, PackedInts.Format format2) {
        super(bitsPerValue, size2, pageSize);
        this.format = format2;
    }

    @Override
    protected PackedInts.Mutable newMutable(int valueCount, int bitsPerValue) {
        assert (this.bitsPerValue >= bitsPerValue);
        return PackedInts.getMutable(valueCount, this.bitsPerValue, this.format);
    }

    @Override
    protected PagedMutable newUnfilledCopy(long newSize) {
        return new PagedMutable(newSize, this.pageSize(), this.bitsPerValue, this.format);
    }

    @Override
    protected long baseRamBytesUsed() {
        return super.baseRamBytesUsed() + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    }
}

