/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MonotonicLongValues
extends DeltaPackedLongValues {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MonotonicLongValues.class);
    final float[] averages;

    MonotonicLongValues(int pageShift, int pageMask, PackedInts.Reader[] values2, long[] mins, float[] averages, long size2, long ramBytesUsed) {
        super(pageShift, pageMask, values2, mins, size2, ramBytesUsed);
        assert (values2.length == averages.length);
        this.averages = averages;
    }

    @Override
    long get(int block, int element) {
        return MonotonicBlockPackedReader.expected(this.mins[block], this.averages[block], element) + this.values[block].get(element);
    }

    @Override
    int decodeBlock(int block, long[] dest) {
        int count2 = super.decodeBlock(block, dest);
        float average = this.averages[block];
        for (int i = 0; i < count2; ++i) {
            int n = i;
            dest[n] = dest[n] + MonotonicBlockPackedReader.expected(0L, average, i);
        }
        return count2;
    }

    static class Builder
    extends DeltaPackedLongValues.Builder {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        float[] averages;

        Builder(int pageSize, float acceptableOverheadRatio) {
            super(pageSize, acceptableOverheadRatio);
            this.averages = new float[this.values.length];
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }

        @Override
        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public MonotonicLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values2 = Arrays.copyOf(this.values, this.valuesOff);
            long[] mins = Arrays.copyOf(this.mins, this.valuesOff);
            float[] averages = Arrays.copyOf(this.averages, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values2) + RamUsageEstimator.sizeOf(mins) + RamUsageEstimator.sizeOf(averages);
            return new MonotonicLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values2, mins, averages, this.size, ramBytesUsed);
        }

        @Override
        void pack(long[] values2, int numValues, int block, float acceptableOverheadRatio) {
            float average = numValues == 1 ? 0.0f : (float)(values2[numValues - 1] - values2[0]) / (float)(numValues - 1);
            for (int i = 0; i < numValues; ++i) {
                int n = i;
                values2[n] = values2[n] - MonotonicBlockPackedReader.expected(0L, average, i);
            }
            super.pack(values2, numValues, block, acceptableOverheadRatio);
            this.averages[block] = average;
        }

        @Override
        void grow(int newBlockCount) {
            super.grow(newBlockCount);
            this.ramBytesUsed -= RamUsageEstimator.sizeOf(this.averages);
            this.averages = Arrays.copyOf(this.averages, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.sizeOf(this.averages);
        }
    }
}

