/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NodeHash;
import org.apache.lucene.util.fst.Outputs;

public class Builder<T> {
    private final NodeHash<T> dedupHash;
    final FST<T> fst;
    private final T NO_OUTPUT;
    private final int minSuffixCount1;
    private final int minSuffixCount2;
    private final boolean doShareNonSingletonNodes;
    private final int shareMaxTailLength;
    private final IntsRefBuilder lastInput = new IntsRefBuilder();
    private UnCompiledNode<T>[] frontier;
    long lastFrozenNode;
    int[] reusedBytesPerArc = new int[4];
    long arcCount;
    long nodeCount;
    boolean allowArrayArcs;
    BytesStore bytes;

    public Builder(FST.INPUT_TYPE inputType, Outputs<T> outputs) {
        this(inputType, 0, 0, true, true, Integer.MAX_VALUE, outputs, true, 15);
    }

    public Builder(FST.INPUT_TYPE inputType, int minSuffixCount1, int minSuffixCount2, boolean doShareSuffix, boolean doShareNonSingletonNodes, int shareMaxTailLength, Outputs<T> outputs, boolean allowArrayArcs, int bytesPageBits) {
        this.minSuffixCount1 = minSuffixCount1;
        this.minSuffixCount2 = minSuffixCount2;
        this.doShareNonSingletonNodes = doShareNonSingletonNodes;
        this.shareMaxTailLength = shareMaxTailLength;
        this.allowArrayArcs = allowArrayArcs;
        this.fst = new FST<T>(inputType, outputs, bytesPageBits);
        this.bytes = this.fst.bytes;
        assert (this.bytes != null);
        this.dedupHash = doShareSuffix ? new NodeHash<T>(this.fst, this.bytes.getReverseReader(false)) : null;
        this.NO_OUTPUT = outputs.getNoOutput();
        UnCompiledNode[] f2 = new UnCompiledNode[10];
        this.frontier = f2;
        for (int idx = 0; idx < this.frontier.length; ++idx) {
            this.frontier[idx] = new UnCompiledNode(this, idx);
        }
    }

    public long getTermCount() {
        return this.frontier[0].inputCount;
    }

    public long getNodeCount() {
        return 1L + this.nodeCount;
    }

    public long getArcCount() {
        return this.arcCount;
    }

    public long getMappedStateCount() {
        return this.dedupHash == null ? 0L : this.nodeCount;
    }

    private CompiledNode compileNode(UnCompiledNode<T> nodeIn, int tailLength) throws IOException {
        long node;
        long bytesPosStart = this.bytes.getPosition();
        if (this.dedupHash != null && (this.doShareNonSingletonNodes || nodeIn.numArcs <= 1) && tailLength <= this.shareMaxTailLength) {
            if (nodeIn.numArcs == 0) {
                this.lastFrozenNode = node = this.fst.addNode(this, nodeIn);
            } else {
                node = this.dedupHash.add(this, nodeIn);
            }
        } else {
            node = this.fst.addNode(this, nodeIn);
        }
        assert (node != -2L);
        long bytesPosEnd = this.bytes.getPosition();
        if (bytesPosEnd != bytesPosStart) {
            assert (bytesPosEnd > bytesPosStart);
            this.lastFrozenNode = node;
        }
        nodeIn.clear();
        CompiledNode fn2 = new CompiledNode();
        fn2.node = node;
        return fn2;
    }

    private void freezeTail(int prefixLenPlus1) throws IOException {
        int downTo = Math.max(1, prefixLenPlus1);
        for (int idx = this.lastInput.length(); idx >= downTo; --idx) {
            boolean isFinal;
            boolean doPrune = false;
            boolean doCompile = false;
            UnCompiledNode<T> node = this.frontier[idx];
            UnCompiledNode parent = this.frontier[idx - 1];
            if (node.inputCount < (long)this.minSuffixCount1) {
                doPrune = true;
                doCompile = true;
            } else if (idx > prefixLenPlus1) {
                doPrune = parent.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && parent.inputCount == 1L && idx > 1;
                doCompile = true;
            } else {
                boolean bl = doCompile = this.minSuffixCount2 == 0;
            }
            if (node.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && node.inputCount == 1L && idx > 1) {
                for (int arcIdx = 0; arcIdx < node.numArcs; ++arcIdx) {
                    UnCompiledNode target = (UnCompiledNode)node.arcs[arcIdx].target;
                    target.clear();
                }
                node.numArcs = 0;
            }
            if (doPrune) {
                node.clear();
                parent.deleteLast(this.lastInput.intAt(idx - 1), node);
                continue;
            }
            if (this.minSuffixCount2 != 0) {
                this.compileAllTargets(node, this.lastInput.length() - idx);
            }
            Object nextFinalOutput = node.output;
            boolean bl = isFinal = node.isFinal || node.numArcs == 0;
            if (doCompile) {
                parent.replaceLast(this.lastInput.intAt(idx - 1), this.compileNode(node, 1 + this.lastInput.length() - idx), nextFinalOutput, isFinal);
                continue;
            }
            parent.replaceLast(this.lastInput.intAt(idx - 1), node, nextFinalOutput, isFinal);
            this.frontier[idx] = new UnCompiledNode(this, idx);
        }
    }

    public void add(IntsRef input2, T output) throws IOException {
        int idx;
        if (output.equals(this.NO_OUTPUT)) {
            output = this.NO_OUTPUT;
        }
        assert (this.lastInput.length() == 0 || input2.compareTo(this.lastInput.get()) >= 0) : "inputs are added out of order lastInput=" + this.lastInput.get() + " vs input=" + input2;
        assert (this.validOutput(output));
        if (input2.length == 0) {
            ++this.frontier[0].inputCount;
            this.frontier[0].isFinal = true;
            this.fst.setEmptyOutput(output);
            return;
        }
        int pos1 = 0;
        int pos2 = input2.offset;
        int pos1Stop = Math.min(this.lastInput.length(), input2.length);
        while (true) {
            ++this.frontier[pos1].inputCount;
            if (pos1 >= pos1Stop || this.lastInput.intAt(pos1) != input2.ints[pos2]) break;
            ++pos1;
            ++pos2;
        }
        int prefixLenPlus1 = pos1 + 1;
        if (this.frontier.length < input2.length + 1) {
            UnCompiledNode<T>[] next2 = ArrayUtil.grow(this.frontier, input2.length + 1);
            for (idx = this.frontier.length; idx < next2.length; ++idx) {
                next2[idx] = new UnCompiledNode(this, idx);
            }
            this.frontier = next2;
        }
        this.freezeTail(prefixLenPlus1);
        for (int idx2 = prefixLenPlus1; idx2 <= input2.length; ++idx2) {
            this.frontier[idx2 - 1].addArc(input2.ints[input2.offset + idx2 - 1], this.frontier[idx2]);
            ++this.frontier[idx2].inputCount;
        }
        UnCompiledNode<T> lastNode = this.frontier[input2.length];
        if (this.lastInput.length() != input2.length || prefixLenPlus1 != input2.length + 1) {
            lastNode.isFinal = true;
            lastNode.output = this.NO_OUTPUT;
        }
        for (idx = 1; idx < prefixLenPlus1; ++idx) {
            T wordSuffix;
            T commonOutputPrefix;
            UnCompiledNode<T> node = this.frontier[idx];
            UnCompiledNode<T> parentNode = this.frontier[idx - 1];
            T lastOutput = parentNode.getLastOutput(input2.ints[input2.offset + idx - 1]);
            assert (this.validOutput(lastOutput));
            if (lastOutput != this.NO_OUTPUT) {
                commonOutputPrefix = this.fst.outputs.common(output, lastOutput);
                assert (this.validOutput(commonOutputPrefix));
                wordSuffix = this.fst.outputs.subtract(lastOutput, commonOutputPrefix);
                assert (this.validOutput(wordSuffix));
                parentNode.setLastOutput(input2.ints[input2.offset + idx - 1], commonOutputPrefix);
                node.prependOutput(wordSuffix);
            } else {
                commonOutputPrefix = wordSuffix = this.NO_OUTPUT;
            }
            output = this.fst.outputs.subtract(output, commonOutputPrefix);
            assert (this.validOutput(output));
        }
        if (this.lastInput.length() == input2.length && prefixLenPlus1 == 1 + input2.length) {
            lastNode.output = this.fst.outputs.merge(lastNode.output, output);
        } else {
            this.frontier[prefixLenPlus1 - 1].setLastOutput(input2.ints[input2.offset + prefixLenPlus1 - 1], output);
        }
        this.lastInput.copyInts(input2);
    }

    private boolean validOutput(T output) {
        return output == this.NO_OUTPUT || !output.equals(this.NO_OUTPUT);
    }

    public FST<T> finish() throws IOException {
        UnCompiledNode<T> root2 = this.frontier[0];
        this.freezeTail(0);
        if (root2.inputCount < (long)this.minSuffixCount1 || root2.inputCount < (long)this.minSuffixCount2 || root2.numArcs == 0) {
            if (this.fst.emptyOutput == null) {
                return null;
            }
            if (this.minSuffixCount1 > 0 || this.minSuffixCount2 > 0) {
                return null;
            }
        } else if (this.minSuffixCount2 != 0) {
            this.compileAllTargets(root2, this.lastInput.length());
        }
        this.fst.finish(this.compileNode(root2, (int)this.lastInput.length()).node);
        return this.fst;
    }

    private void compileAllTargets(UnCompiledNode<T> node, int tailLength) throws IOException {
        for (int arcIdx = 0; arcIdx < node.numArcs; ++arcIdx) {
            Arc arc = node.arcs[arcIdx];
            if (arc.target.isCompiled()) continue;
            UnCompiledNode n = (UnCompiledNode)arc.target;
            if (n.numArcs == 0) {
                n.isFinal = true;
                arc.isFinal = true;
            }
            arc.target = this.compileNode(n, tailLength - 1);
        }
    }

    public long fstRamBytesUsed() {
        return this.fst.ramBytesUsed();
    }

    public static final class UnCompiledNode<T>
    implements Node {
        final Builder<T> owner;
        public int numArcs;
        public Arc<T>[] arcs;
        public T output;
        public boolean isFinal;
        public long inputCount;
        public final int depth;

        public UnCompiledNode(Builder<T> owner2, int depth) {
            this.owner = owner2;
            this.arcs = new Arc[1];
            this.arcs[0] = new Arc();
            this.output = ((Builder)owner2).NO_OUTPUT;
            this.depth = depth;
        }

        @Override
        public boolean isCompiled() {
            return false;
        }

        public void clear() {
            this.numArcs = 0;
            this.isFinal = false;
            this.output = ((Builder)this.owner).NO_OUTPUT;
            this.inputCount = 0L;
        }

        public T getLastOutput(int labelToMatch) {
            assert (this.numArcs > 0);
            assert (this.arcs[this.numArcs - 1].label == labelToMatch);
            return this.arcs[this.numArcs - 1].output;
        }

        public void addArc(int label, Node target) {
            assert (label >= 0);
            assert (this.numArcs == 0 || label > this.arcs[this.numArcs - 1].label) : "arc[-1].label=" + this.arcs[this.numArcs - 1].label + " new label=" + label + " numArcs=" + this.numArcs;
            if (this.numArcs == this.arcs.length) {
                Arc<T>[] newArcs = ArrayUtil.grow(this.arcs, this.numArcs + 1);
                for (int arcIdx = this.numArcs; arcIdx < newArcs.length; ++arcIdx) {
                    newArcs[arcIdx] = new Arc();
                }
                this.arcs = newArcs;
            }
            Arc<T> arc = this.arcs[this.numArcs++];
            arc.label = label;
            arc.target = target;
            arc.nextFinalOutput = ((Builder)this.owner).NO_OUTPUT;
            arc.output = arc.nextFinalOutput;
            arc.isFinal = false;
        }

        public void replaceLast(int labelToMatch, Node target, T nextFinalOutput, boolean isFinal) {
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == labelToMatch) : "arc.label=" + arc.label + " vs " + labelToMatch;
            arc.target = target;
            arc.nextFinalOutput = nextFinalOutput;
            arc.isFinal = isFinal;
        }

        public void deleteLast(int label, Node target) {
            assert (this.numArcs > 0);
            assert (label == this.arcs[this.numArcs - 1].label);
            assert (target == this.arcs[this.numArcs - 1].target);
            --this.numArcs;
        }

        public void setLastOutput(int labelToMatch, T newOutput) {
            assert (((Builder)this.owner).validOutput(newOutput));
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == labelToMatch);
            arc.output = newOutput;
        }

        public void prependOutput(T outputPrefix) {
            assert (((Builder)this.owner).validOutput(outputPrefix));
            for (int arcIdx = 0; arcIdx < this.numArcs; ++arcIdx) {
                this.arcs[arcIdx].output = this.owner.fst.outputs.add(outputPrefix, this.arcs[arcIdx].output);
                assert (((Builder)this.owner).validOutput(this.arcs[arcIdx].output));
            }
            if (this.isFinal) {
                this.output = this.owner.fst.outputs.add(outputPrefix, this.output);
                assert (((Builder)this.owner).validOutput(this.output));
            }
        }
    }

    static final class CompiledNode
    implements Node {
        long node;

        CompiledNode() {
        }

        @Override
        public boolean isCompiled() {
            return true;
        }
    }

    static interface Node {
        public boolean isCompiled();
    }

    public static class Arc<T> {
        public int label;
        public Node target;
        public boolean isFinal;
        public T output;
        public T nextFinalOutput;
    }
}

