/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;

class DocIdsWriter {
    private DocIdsWriter() {
    }

    static void writeDocIds(int[] docIds, int start, int count2, DataOutput out) throws IOException {
        boolean sorted2 = true;
        for (int i = 1; i < count2; ++i) {
            if (docIds[start + i - 1] <= docIds[start + i]) continue;
            sorted2 = false;
            break;
        }
        if (sorted2) {
            out.writeByte((byte)0);
            int previous = 0;
            for (int i = 0; i < count2; ++i) {
                int doc = docIds[start + i];
                out.writeVInt(doc - previous);
                previous = doc;
            }
        } else {
            int i;
            long max2 = 0L;
            for (i = 0; i < count2; ++i) {
                max2 |= Integer.toUnsignedLong(docIds[start + i]);
            }
            if (max2 <= 0xFFFFFFL) {
                out.writeByte((byte)24);
                for (i = 0; i < count2; ++i) {
                    out.writeShort((short)(docIds[start + i] >>> 8));
                    out.writeByte((byte)docIds[start + i]);
                }
            } else {
                out.writeByte((byte)32);
                for (i = 0; i < count2; ++i) {
                    out.writeInt(docIds[start + i]);
                }
            }
        }
    }

    static void readInts(IndexInput in, int count2, int[] docIDs) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                DocIdsWriter.readDeltaVInts(in, count2, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count2, docIDs);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count2, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readDeltaVInts(IndexInput in, int count2, int[] docIDs) throws IOException {
        int doc = 0;
        for (int i = 0; i < count2; ++i) {
            docIDs[i] = doc += in.readVInt();
        }
    }

    static <T> void readInts32(IndexInput in, int count2, int[] docIDs) throws IOException {
        for (int i = 0; i < count2; ++i) {
            docIDs[i] = in.readInt();
        }
    }

    private static void readInts24(IndexInput in, int count2, int[] docIDs) throws IOException {
        int i;
        for (i = 0; i < count2 - 7; i += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            docIDs[i] = (int)(l1 >>> 40);
            docIDs[i + 1] = (int)(l1 >>> 16) & 0xFFFFFF;
            docIDs[i + 2] = (int)((l1 & 0xFFFFL) << 8 | l2 >>> 56);
            docIDs[i + 3] = (int)(l2 >>> 32) & 0xFFFFFF;
            docIDs[i + 4] = (int)(l2 >>> 8) & 0xFFFFFF;
            docIDs[i + 5] = (int)((l2 & 0xFFL) << 16 | l3 >>> 48);
            docIDs[i + 6] = (int)(l3 >>> 24) & 0xFFFFFF;
            docIDs[i + 7] = (int)l3 & 0xFFFFFF;
        }
        while (i < count2) {
            docIDs[i] = Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte());
            ++i;
        }
    }

    static void readInts(IndexInput in, int count2, PointValues.IntersectVisitor visitor) throws IOException {
        byte bpv = in.readByte();
        switch (bpv) {
            case 0: {
                DocIdsWriter.readDeltaVInts(in, count2, visitor);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count2, visitor);
                break;
            }
            case 24: {
                DocIdsWriter.readInts24(in, count2, visitor);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private static void readDeltaVInts(IndexInput in, int count2, PointValues.IntersectVisitor visitor) throws IOException {
        int doc = 0;
        for (int i = 0; i < count2; ++i) {
            visitor.visit(doc += in.readVInt());
        }
    }

    static void readInts32(IndexInput in, int count2, PointValues.IntersectVisitor visitor) throws IOException {
        for (int i = 0; i < count2; ++i) {
            visitor.visit(in.readInt());
        }
    }

    private static void readInts24(IndexInput in, int count2, PointValues.IntersectVisitor visitor) throws IOException {
        int i;
        for (i = 0; i < count2 - 7; i += 8) {
            long l1 = in.readLong();
            long l2 = in.readLong();
            long l3 = in.readLong();
            visitor.visit((int)(l1 >>> 40));
            visitor.visit((int)(l1 >>> 16) & 0xFFFFFF);
            visitor.visit((int)((l1 & 0xFFFFL) << 8 | l2 >>> 56));
            visitor.visit((int)(l2 >>> 32) & 0xFFFFFF);
            visitor.visit((int)(l2 >>> 8) & 0xFFFFFF);
            visitor.visit((int)((l2 & 0xFFL) << 16 | l3 >>> 48));
            visitor.visit((int)(l3 >>> 24) & 0xFFFFFF);
            visitor.visit((int)l3 & 0xFFFFFF);
        }
        while (i < count2) {
            visitor.visit(Short.toUnsignedInt(in.readShort()) << 8 | Byte.toUnsignedInt(in.readByte()));
            ++i;
        }
    }
}

