/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import org.apache.lucene.util.automaton.Operations;

public final class Automata {
    private Automata() {
    }

    public static Automaton makeEmpty() {
        Automaton a = new Automaton();
        a.finishState();
        return a;
    }

    public static Automaton makeEmptyString() {
        Automaton a = new Automaton();
        a.createState();
        a.setAccept(0, true);
        return a;
    }

    public static Automaton makeAnyString() {
        Automaton a = new Automaton();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s2, s2, 0, 0x10FFFF);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyBinary() {
        Automaton a = new Automaton();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s2, s2, 0, 255);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyChar() {
        return Automata.makeCharRange(0, 0x10FFFF);
    }

    public static int appendAnyChar(Automaton a, int state) {
        int newState = a.createState();
        a.addTransition(state, newState, 0, 0x10FFFF);
        return newState;
    }

    public static Automaton makeChar(int c) {
        return Automata.makeCharRange(c, c);
    }

    public static int appendChar(Automaton a, int state, int c) {
        int newState = a.createState();
        a.addTransition(state, newState, c, c);
        return newState;
    }

    public static Automaton makeCharRange(int min2, int max2) {
        if (min2 > max2) {
            return Automata.makeEmpty();
        }
        Automaton a = new Automaton();
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, min2, max2);
        a.finishState();
        return a;
    }

    private static int anyOfRightLength(Automaton.Builder builder, String x, int n) {
        int s2 = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s2, true);
        } else {
            builder.addTransition(s2, Automata.anyOfRightLength(builder, x, n + 1), 48, 57);
        }
        return s2;
    }

    private static int atLeast(Automaton.Builder builder, String x, int n, Collection<Integer> initials, boolean zeros) {
        int s2 = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s2, true);
        } else {
            if (zeros) {
                initials.add(s2);
            }
            char c = x.charAt(n);
            builder.addTransition(s2, Automata.atLeast(builder, x, n + 1, initials, zeros && c == '0'), c);
            if (c < '9') {
                builder.addTransition(s2, Automata.anyOfRightLength(builder, x, n + 1), (char)(c + '\u0001'), 57);
            }
        }
        return s2;
    }

    private static int atMost(Automaton.Builder builder, String x, int n) {
        int s2 = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s2, true);
        } else {
            char c = x.charAt(n);
            builder.addTransition(s2, Automata.atMost(builder, x, (char)n + '\u0001'), c);
            if (c > '0') {
                builder.addTransition(s2, Automata.anyOfRightLength(builder, x, n + 1), 48, (char)(c - '\u0001'));
            }
        }
        return s2;
    }

    private static int between(Automaton.Builder builder, String x, String y, int n, Collection<Integer> initials, boolean zeros) {
        int s2 = builder.createState();
        if (x.length() == n) {
            builder.setAccept(s2, true);
        } else {
            char cy;
            char cx;
            if (zeros) {
                initials.add(s2);
            }
            if ((cx = x.charAt(n)) == (cy = y.charAt(n))) {
                builder.addTransition(s2, Automata.between(builder, x, y, n + 1, initials, zeros && cx == '0'), cx);
            } else {
                builder.addTransition(s2, Automata.atLeast(builder, x, n + 1, initials, zeros && cx == '0'), cx);
                builder.addTransition(s2, Automata.atMost(builder, y, n + 1), cy);
                if (cx + '\u0001' < cy) {
                    builder.addTransition(s2, Automata.anyOfRightLength(builder, x, n + 1), (char)(cx + '\u0001'), (char)(cy - '\u0001'));
                }
            }
        }
        return s2;
    }

    private static boolean suffixIsZeros(BytesRef br, int len) {
        for (int i = len; i < br.length; ++i) {
            if (br.bytes[br.offset + i] == 0) continue;
            return false;
        }
        return true;
    }

    public static Automaton makeBinaryInterval(BytesRef min2, boolean minInclusive, BytesRef max2, boolean maxInclusive) {
        int i;
        int cmp;
        if (min2 == null && !minInclusive) {
            throw new IllegalArgumentException("minInclusive must be true when min is null (open ended)");
        }
        if (max2 == null && !maxInclusive) {
            throw new IllegalArgumentException("maxInclusive must be true when max is null (open ended)");
        }
        if (min2 == null) {
            min2 = new BytesRef();
            minInclusive = true;
        }
        if (max2 != null) {
            cmp = min2.compareTo(max2);
        } else {
            cmp = -1;
            if (min2.length == 0 && minInclusive) {
                return Automata.makeAnyBinary();
            }
        }
        if (cmp == 0) {
            if (!minInclusive || !maxInclusive) {
                return Automata.makeEmpty();
            }
            return Automata.makeBinary(min2);
        }
        if (cmp > 0) {
            return Automata.makeEmpty();
        }
        if (max2 != null && StringHelper.startsWith(max2, min2) && Automata.suffixIsZeros(max2, min2.length)) {
            int state;
            int i2;
            int maxLength = max2.length;
            assert (maxLength > min2.length);
            if (!maxInclusive) {
                --maxLength;
            }
            if (maxLength == min2.length) {
                if (!minInclusive) {
                    return Automata.makeEmpty();
                }
                return Automata.makeBinary(min2);
            }
            Automaton a = new Automaton();
            int lastState = a.createState();
            for (i2 = 0; i2 < min2.length; ++i2) {
                state = a.createState();
                int label = min2.bytes[min2.offset + i2] & 0xFF;
                a.addTransition(lastState, state, label);
                lastState = state;
            }
            if (minInclusive) {
                a.setAccept(lastState, true);
            }
            for (i2 = min2.length; i2 < maxLength; ++i2) {
                state = a.createState();
                a.addTransition(lastState, state, 0);
                a.setAccept(state, true);
                lastState = state;
            }
            a.finishState();
            return a;
        }
        Automaton a = new Automaton();
        int startState = a.createState();
        int sinkState = a.createState();
        a.setAccept(sinkState, true);
        a.addTransition(sinkState, sinkState, 0, 255);
        boolean equalPrefix = true;
        int lastState = startState;
        int firstMaxState = -1;
        int sharedPrefixLength = 0;
        for (i = 0; i < min2.length; ++i) {
            int minLabel = min2.bytes[min2.offset + i] & 0xFF;
            int maxLabel = max2 != null && equalPrefix && i < max2.length ? max2.bytes[max2.offset + i] & 0xFF : -1;
            int nextState = minInclusive && i == min2.length - 1 && (!equalPrefix || minLabel != maxLabel) ? sinkState : a.createState();
            if (equalPrefix) {
                if (minLabel == maxLabel) {
                    a.addTransition(lastState, nextState, minLabel);
                } else if (max2 == null) {
                    equalPrefix = false;
                    sharedPrefixLength = 0;
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                    a.addTransition(lastState, nextState, minLabel);
                } else {
                    assert (maxLabel > minLabel);
                    a.addTransition(lastState, nextState, minLabel);
                    if (maxLabel > minLabel + 1) {
                        a.addTransition(lastState, sinkState, minLabel + 1, maxLabel - 1);
                    }
                    if (maxInclusive || i < max2.length - 1) {
                        firstMaxState = a.createState();
                        if (i < max2.length - 1) {
                            a.setAccept(firstMaxState, true);
                        }
                        a.addTransition(lastState, firstMaxState, maxLabel);
                    }
                    equalPrefix = false;
                    sharedPrefixLength = i;
                }
            } else {
                a.addTransition(lastState, nextState, minLabel);
                if (minLabel < 255) {
                    a.addTransition(lastState, sinkState, minLabel + 1, 255);
                }
            }
            lastState = nextState;
        }
        if (!equalPrefix && lastState != sinkState && lastState != startState) {
            a.addTransition(lastState, sinkState, 0, 255);
        }
        if (minInclusive) {
            a.setAccept(lastState, true);
        }
        if (max2 != null) {
            if (firstMaxState == -1) {
                sharedPrefixLength = min2.length;
            } else {
                lastState = firstMaxState;
                ++sharedPrefixLength;
            }
            for (i = sharedPrefixLength; i < max2.length; ++i) {
                int maxLabel = max2.bytes[max2.offset + i] & 0xFF;
                if (maxLabel > 0) {
                    a.addTransition(lastState, sinkState, 0, maxLabel - 1);
                }
                if (!maxInclusive && i >= max2.length - 1) continue;
                int nextState = a.createState();
                if (i < max2.length - 1) {
                    a.setAccept(nextState, true);
                }
                a.addTransition(lastState, nextState, maxLabel);
                lastState = nextState;
            }
            if (maxInclusive) {
                a.setAccept(lastState, true);
            }
        }
        a.finishState();
        assert (a.isDeterministic()) : a.toDot();
        return a;
    }

    public static Automaton makeDecimalInterval(int min2, int max2, int digits) throws IllegalArgumentException {
        String x = Integer.toString(min2);
        String y = Integer.toString(max2);
        if (min2 > max2 || digits > 0 && y.length() > digits) {
            throw new IllegalArgumentException();
        }
        int d = digits > 0 ? digits : y.length();
        StringBuilder bx = new StringBuilder();
        for (int i = x.length(); i < d; ++i) {
            bx.append('0');
        }
        bx.append(x);
        x = bx.toString();
        StringBuilder by2 = new StringBuilder();
        for (int i = y.length(); i < d; ++i) {
            by2.append('0');
        }
        by2.append(y);
        y = by2.toString();
        Automaton.Builder builder = new Automaton.Builder();
        if (digits <= 0) {
            builder.createState();
        }
        ArrayList<Integer> initials = new ArrayList<Integer>();
        Automata.between(builder, x, y, 0, initials, digits <= 0);
        Automaton a1 = builder.finish();
        if (digits <= 0) {
            a1.addTransition(0, 0, 48);
            Iterator iterator2 = initials.iterator();
            while (iterator2.hasNext()) {
                int p = (Integer)iterator2.next();
                a1.addEpsilon(0, p);
            }
            a1.finishState();
        }
        return a1;
    }

    public static Automaton makeString(String s2) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
            int state = a.createState();
            cp = s2.codePointAt(i);
            a.addTransition(lastState, state, cp);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeBinary(BytesRef term) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        for (int i = 0; i < term.length; ++i) {
            int state = a.createState();
            int label = term.bytes[term.offset + i] & 0xFF;
            a.addTransition(lastState, state, label);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeString(int[] word, int offset, int length) {
        Automaton a = new Automaton();
        a.createState();
        int s2 = 0;
        for (int i = offset; i < offset + length; ++i) {
            int s22 = a.createState();
            a.addTransition(s2, s22, word[i]);
            s2 = s22;
        }
        a.setAccept(s2, true);
        a.finishState();
        return a;
    }

    public static Automaton makeStringUnion(Collection<BytesRef> utf8Strings) {
        if (utf8Strings.isEmpty()) {
            return Automata.makeEmpty();
        }
        return DaciukMihovAutomatonBuilder.build(utf8Strings);
    }
}

