/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Sorter;

public abstract class TimSorter
extends Sorter {
    static final int MINRUN = 32;
    static final int THRESHOLD = 64;
    static final int STACKSIZE = 49;
    static final int MIN_GALLOP = 7;
    final int maxTempSlots;
    int minRun;
    int to;
    int stackSize;
    int[] runEnds = new int[50];

    protected TimSorter(int maxTempSlots) {
        this.maxTempSlots = maxTempSlots;
    }

    static int minRun(int length) {
        int n;
        assert (length >= 32);
        int r = 0;
        for (n = length; n >= 64; n >>>= 1) {
            r |= n & 1;
        }
        int minRun = n + r;
        assert (minRun >= 32 && minRun <= 64);
        return minRun;
    }

    int runLen(int i) {
        int off = this.stackSize - i;
        return this.runEnds[off] - this.runEnds[off - 1];
    }

    int runBase(int i) {
        return this.runEnds[this.stackSize - i - 1];
    }

    int runEnd(int i) {
        return this.runEnds[this.stackSize - i];
    }

    void setRunEnd(int i, int runEnd) {
        this.runEnds[this.stackSize - i] = runEnd;
    }

    void pushRunLen(int len) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + len;
        ++this.stackSize;
    }

    int nextRun() {
        int o;
        int runBase = this.runEnd(0);
        assert (runBase < this.to);
        if (runBase == this.to - 1) {
            return 1;
        }
        if (this.compare(runBase, runBase + 1) > 0) {
            for (o = runBase + 2; o < this.to && this.compare(o - 1, o) > 0; ++o) {
            }
            this.reverse(runBase, o);
        } else {
            while (o < this.to && this.compare(o - 1, o) <= 0) {
                ++o;
            }
        }
        int runHi = Math.max(o, Math.min(this.to, runBase + this.minRun));
        this.binarySort(runBase, runHi, o);
        return runHi - runBase;
    }

    void ensureInvariants() {
        while (this.stackSize > 1) {
            int runLen2;
            int runLen0 = this.runLen(0);
            int runLen1 = this.runLen(1);
            if (this.stackSize > 2 && (runLen2 = this.runLen(2)) <= runLen1 + runLen0) {
                if (runLen2 < runLen0) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (runLen1 > runLen0) break;
            this.mergeAt(0);
        }
    }

    void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    void reset(int from2, int to2) {
        this.stackSize = 0;
        Arrays.fill(this.runEnds, 0);
        this.runEnds[0] = from2;
        this.to = to2;
        int length = to2 - from2;
        this.minRun = length <= 64 ? length : TimSorter.minRun(length);
    }

    void mergeAt(int n) {
        assert (this.stackSize >= 2);
        this.merge(this.runBase(n + 1), this.runBase(n), this.runEnd(n));
        for (int j = n + 1; j > 0; --j) {
            this.setRunEnd(j, this.runEnd(j - 1));
        }
        --this.stackSize;
    }

    void merge(int lo2, int mid, int hi2) {
        if (this.compare(mid - 1, mid) <= 0) {
            return;
        }
        lo2 = this.upper2(lo2, mid, mid);
        if ((hi2 = this.lower2(mid, hi2, mid - 1)) - mid <= mid - lo2 && hi2 - mid <= this.maxTempSlots) {
            this.mergeHi(lo2, mid, hi2);
        } else if (mid - lo2 <= this.maxTempSlots) {
            this.mergeLo(lo2, mid, hi2);
        } else {
            this.mergeInPlace(lo2, mid, hi2);
        }
    }

    @Override
    public void sort(int from2, int to2) {
        this.checkRange(from2, to2);
        if (to2 - from2 <= 1) {
            return;
        }
        this.reset(from2, to2);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < to2);
        this.exhaustStack();
        assert (this.runEnd(0) == to2);
    }

    @Override
    void doRotate(int lo2, int mid, int hi2) {
        int len1 = mid - lo2;
        int len2 = hi2 - mid;
        if (len1 == len2) {
            while (mid < hi2) {
                this.swap(lo2++, mid++);
            }
        } else if (len2 < len1 && len2 <= this.maxTempSlots) {
            this.save(mid, len2);
            int i = lo2 + len1 - 1;
            int j = hi2 - 1;
            while (i >= lo2) {
                this.copy(i, j);
                --i;
                --j;
            }
            i = 0;
            j = lo2;
            while (i < len2) {
                this.restore(i, j);
                ++i;
                ++j;
            }
        } else if (len1 <= this.maxTempSlots) {
            this.save(lo2, len1);
            int i = mid;
            int j = lo2;
            while (i < hi2) {
                this.copy(i, j);
                ++i;
                ++j;
            }
            i = 0;
            for (j = lo2 + len2; j < hi2; ++j) {
                this.restore(i, j);
                ++i;
            }
        } else {
            this.reverse(lo2, mid);
            this.reverse(mid, hi2);
            this.reverse(lo2, hi2);
        }
    }

    void mergeLo(int lo2, int mid, int hi2) {
        assert (this.compare(lo2, mid) > 0);
        int len1 = mid - lo2;
        this.save(lo2, len1);
        this.copy(mid, lo2);
        int i = 0;
        int j = mid + 1;
        int dest = lo2 + 1;
        block0: while (true) {
            int count2 = 0;
            while (count2 < 7) {
                if (i >= len1 || j >= hi2) break block0;
                if (this.compareSaved(i, j) <= 0) {
                    this.restore(i++, dest++);
                    count2 = 0;
                    continue;
                }
                this.copy(j++, dest++);
                ++count2;
            }
            int next2 = this.lowerSaved3(j, hi2, i);
            while (j < next2) {
                this.copy(j++, dest);
                ++dest;
            }
            this.restore(i++, dest++);
        }
        while (i < len1) {
            this.restore(i++, dest);
            ++dest;
        }
        assert (j == dest);
    }

    void mergeHi(int lo2, int mid, int hi2) {
        assert (this.compare(mid - 1, hi2 - 1) > 0);
        int len2 = hi2 - mid;
        this.save(mid, len2);
        this.copy(mid - 1, hi2 - 1);
        int i = mid - 2;
        int j = len2 - 1;
        int dest = hi2 - 2;
        block0: while (true) {
            int count2 = 0;
            while (count2 < 7) {
                if (i < lo2 || j < 0) break block0;
                if (this.compareSaved(j, i) >= 0) {
                    this.restore(j--, dest--);
                    count2 = 0;
                    continue;
                }
                this.copy(i--, dest--);
                ++count2;
            }
            int next2 = this.upperSaved3(lo2, i + 1, j);
            while (i >= next2) {
                this.copy(i--, dest--);
            }
            this.restore(j--, dest--);
        }
        while (j >= 0) {
            this.restore(j--, dest);
            --dest;
        }
        assert (i == dest);
    }

    int lowerSaved(int from2, int to2, int val) {
        int len = to2 - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compareSaved(val, mid) > 0) {
                from2 = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from2;
    }

    int upperSaved(int from2, int to2, int val) {
        int len = to2 - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compareSaved(val, mid) < 0) {
                len = half;
                continue;
            }
            from2 = mid + 1;
            len = len - half - 1;
        }
        return from2;
    }

    int lowerSaved3(int from2, int to2, int val) {
        int delta;
        int f2 = from2;
        for (int t = f2 + 1; t < to2; t += delta << 1) {
            if (this.compareSaved(val, t) <= 0) {
                return this.lowerSaved(f2, t, val);
            }
            delta = t - f2;
            f2 = t;
        }
        return this.lowerSaved(f2, to2, val);
    }

    int upperSaved3(int from2, int to2, int val) {
        int delta;
        int t = to2;
        for (int f2 = to2 - 1; f2 > from2; f2 -= delta << 1) {
            if (this.compareSaved(val, f2) >= 0) {
                return this.upperSaved(f2, t, val);
            }
            delta = t - f2;
            t = f2;
        }
        return this.upperSaved(from2, t, val);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);
}

