/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.RamUsageEstimator;

public class SparseFixedBitSet
extends BitSet
implements Bits,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SparseFixedBitSet.class);
    private static final long SINGLE_ELEMENT_ARRAY_BYTES_USED = RamUsageEstimator.sizeOf(new long[1]);
    private static final int MASK_4096 = 4095;
    final long[] indices;
    final long[][] bits;
    final int length;
    int nonZeroLongCount;
    long ramBytesUsed;

    private static int blockCount(int length) {
        int blockCount = length >>> 12;
        if (blockCount << 12 < length) {
            ++blockCount;
        }
        assert (blockCount << 12 >= length);
        return blockCount;
    }

    public SparseFixedBitSet(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length needs to be >= 1");
        }
        this.length = length;
        int blockCount = SparseFixedBitSet.blockCount(length);
        this.indices = new long[blockCount];
        this.bits = new long[blockCount][];
        this.ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object)this.indices) + RamUsageEstimator.shallowSizeOf((Object[])this.bits);
    }

    @Override
    public int length() {
        return this.length;
    }

    private boolean consistent(int index2) {
        assert (index2 >= 0 && index2 < this.length) : "index=" + index2 + ",length=" + this.length;
        return true;
    }

    @Override
    public int cardinality() {
        int cardinality = 0;
        for (long[] bitArray : this.bits) {
            if (bitArray == null) continue;
            for (long bits2 : bitArray) {
                cardinality += Long.bitCount(bits2);
            }
        }
        return cardinality;
    }

    @Override
    public int approximateCardinality() {
        int totalLongs = this.length + 63 >>> 6;
        assert (totalLongs >= this.nonZeroLongCount);
        int zeroLongs = totalLongs - this.nonZeroLongCount;
        long estimate = Math.round((double)totalLongs * Math.log((double)totalLongs / (double)zeroLongs));
        return (int)Math.min((long)this.length, estimate);
    }

    @Override
    public boolean get(int i) {
        assert (this.consistent(i));
        int i4096 = i >>> 12;
        long index2 = this.indices[i4096];
        int i64 = i >>> 6;
        if ((index2 & 1L << i64) == 0L) {
            return false;
        }
        long bits2 = this.bits[i4096][Long.bitCount(index2 & (1L << i64) - 1L)];
        return (bits2 & 1L << i) != 0L;
    }

    private static int oversize(int s2) {
        int newSize = s2 + (s2 >>> 1);
        if (newSize > 50) {
            newSize = 64;
        }
        return newSize;
    }

    @Override
    public void set(int i) {
        assert (this.consistent(i));
        int i4096 = i >>> 12;
        long index2 = this.indices[i4096];
        int i64 = i >>> 6;
        if ((index2 & 1L << i64) != 0L) {
            long[] lArray = this.bits[i4096];
            int n = Long.bitCount(index2 & (1L << i64) - 1L);
            lArray[n] = lArray[n] | 1L << i;
        } else if (index2 == 0L) {
            this.insertBlock(i4096, i64, i);
        } else {
            this.insertLong(i4096, i64, i, index2);
        }
    }

    private void insertBlock(int i4096, int i64, int i) {
        this.indices[i4096] = 1L << i64;
        assert (this.bits[i4096] == null);
        this.bits[i4096] = new long[]{1L << i};
        ++this.nonZeroLongCount;
        this.ramBytesUsed += SINGLE_ELEMENT_ARRAY_BYTES_USED;
    }

    private void insertLong(int i4096, int i64, int i, long index2) {
        int n = i4096;
        this.indices[n] = this.indices[n] | 1L << i64;
        int o = Long.bitCount(index2 & (1L << i64) - 1L);
        long[] bitArray = this.bits[i4096];
        if (bitArray[bitArray.length - 1] == 0L) {
            System.arraycopy(bitArray, o, bitArray, o + 1, bitArray.length - o - 1);
            bitArray[o] = 1L << i;
        } else {
            int newSize = SparseFixedBitSet.oversize(bitArray.length + 1);
            long[] newBitArray = new long[newSize];
            System.arraycopy(bitArray, 0, newBitArray, 0, o);
            newBitArray[o] = 1L << i;
            System.arraycopy(bitArray, o, newBitArray, o + 1, bitArray.length - o);
            this.bits[i4096] = newBitArray;
            this.ramBytesUsed += RamUsageEstimator.sizeOf(newBitArray) - RamUsageEstimator.sizeOf(bitArray);
        }
        ++this.nonZeroLongCount;
    }

    @Override
    public void clear(int i) {
        assert (this.consistent(i));
        int i4096 = i >>> 12;
        int i64 = i >>> 6;
        this.and(i4096, i64, 1L << i ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void and(int i4096, int i64, long mask) {
        long index2 = this.indices[i4096];
        if ((index2 & 1L << i64) != 0L) {
            int o = Long.bitCount(index2 & (1L << i64) - 1L);
            long bits2 = this.bits[i4096][o] & mask;
            if (bits2 == 0L) {
                this.removeLong(i4096, i64, index2, o);
            } else {
                this.bits[i4096][o] = bits2;
            }
        }
    }

    private void removeLong(int i4096, int i64, long index2, int o) {
        this.indices[i4096] = index2 &= 1L << i64 ^ 0xFFFFFFFFFFFFFFFFL;
        if (index2 == 0L) {
            this.bits[i4096] = null;
        } else {
            int length = Long.bitCount(index2);
            long[] bitArray = this.bits[i4096];
            System.arraycopy(bitArray, o + 1, bitArray, o, length - o);
            bitArray[length] = 0L;
        }
        --this.nonZeroLongCount;
    }

    @Override
    public void clear(int from2, int to2) {
        assert (from2 >= 0);
        assert (to2 <= this.length);
        if (from2 >= to2) {
            return;
        }
        int firstBlock = from2 >>> 12;
        int lastBlock = to2 - 1 >>> 12;
        if (firstBlock == lastBlock) {
            this.clearWithinBlock(firstBlock, from2 & 0xFFF, to2 - 1 & 0xFFF);
        } else {
            this.clearWithinBlock(firstBlock, from2 & 0xFFF, 4095);
            for (int i = firstBlock + 1; i < lastBlock; ++i) {
                this.nonZeroLongCount -= Long.bitCount(this.indices[i]);
                this.indices[i] = 0L;
                this.bits[i] = null;
            }
            this.clearWithinBlock(lastBlock, 0, to2 - 1 & 0xFFF);
        }
    }

    private static long mask(int from2, int to2) {
        return (1L << to2 - from2 << 1) - 1L << from2;
    }

    private void clearWithinBlock(int i4096, int from2, int to2) {
        int firstLong = from2 >>> 6;
        int lastLong = to2 >>> 6;
        if (firstLong == lastLong) {
            this.and(i4096, firstLong, SparseFixedBitSet.mask(from2, to2) ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            assert (firstLong < lastLong);
            this.and(i4096, lastLong, SparseFixedBitSet.mask(0, to2) ^ 0xFFFFFFFFFFFFFFFFL);
            for (int i = lastLong - 1; i >= firstLong + 1; --i) {
                this.and(i4096, i, 0L);
            }
            this.and(i4096, firstLong, SparseFixedBitSet.mask(from2, 63) ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    private int firstDoc(int i4096) {
        long index2 = 0L;
        while (i4096 < this.indices.length) {
            index2 = this.indices[i4096];
            if (index2 != 0L) {
                int i64 = Long.numberOfTrailingZeros(index2);
                return i4096 << 12 | i64 << 6 | Long.numberOfTrailingZeros(this.bits[i4096][0]);
            }
            ++i4096;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextSetBit(int i) {
        long indexBits;
        assert (i < this.length);
        int i4096 = i >>> 12;
        long index2 = this.indices[i4096];
        long[] bitArray = this.bits[i4096];
        int i64 = i >>> 6;
        int o = Long.bitCount(index2 & (1L << i64) - 1L);
        if ((index2 & 1L << i64) != 0L) {
            long bits2 = bitArray[o] >>> i;
            if (bits2 != 0L) {
                return i + Long.numberOfTrailingZeros(bits2);
            }
            ++o;
        }
        if ((indexBits = index2 >>> i64 >>> 1) == 0L) {
            return this.firstDoc(i4096 + 1);
        }
        long bits3 = bitArray[o];
        return (i64 += 1 + Long.numberOfTrailingZeros(indexBits)) << 6 | Long.numberOfTrailingZeros(bits3);
    }

    private int lastDoc(int i4096) {
        while (i4096 >= 0) {
            long index2 = this.indices[i4096];
            if (index2 != 0L) {
                int i64 = 63 - Long.numberOfLeadingZeros(index2);
                long bits2 = this.bits[i4096][Long.bitCount(index2) - 1];
                return i4096 << 12 | i64 << 6 | 63 - Long.numberOfLeadingZeros(bits2);
            }
            --i4096;
        }
        return -1;
    }

    @Override
    public int prevSetBit(int i) {
        long bits2;
        assert (i >= 0);
        int i4096 = i >>> 12;
        long index2 = this.indices[i4096];
        long[] bitArray = this.bits[i4096];
        int i64 = i >>> 6;
        long indexBits = index2 & (1L << i64) - 1L;
        int o = Long.bitCount(indexBits);
        if ((index2 & 1L << i64) != 0L && (bits2 = bitArray[o] & (1L << i << 1) - 1L) != 0L) {
            return i64 << 6 | 63 - Long.numberOfLeadingZeros(bits2);
        }
        if (indexBits == 0L) {
            return this.lastDoc(i4096 - 1);
        }
        i64 = 63 - Long.numberOfLeadingZeros(indexBits);
        bits2 = bitArray[o - 1];
        return i4096 << 12 | i64 << 6 | 63 - Long.numberOfLeadingZeros(bits2);
    }

    private long longBits(long index2, long[] bits2, int i64) {
        if ((index2 & 1L << i64) == 0L) {
            return 0L;
        }
        return bits2[Long.bitCount(index2 & (1L << i64) - 1L)];
    }

    private void or(int i4096, long index2, long[] bits2, int nonZeroLongCount) {
        assert (Long.bitCount(index2) == nonZeroLongCount);
        long currentIndex = this.indices[i4096];
        if (currentIndex == 0L) {
            this.indices[i4096] = index2;
            this.bits[i4096] = Arrays.copyOf(bits2, nonZeroLongCount);
            this.nonZeroLongCount += nonZeroLongCount;
            return;
        }
        long[] currentBits = this.bits[i4096];
        long newIndex = currentIndex | index2;
        int requiredCapacity = Long.bitCount(newIndex);
        long[] newBits = currentBits.length >= requiredCapacity ? currentBits : new long[SparseFixedBitSet.oversize(requiredCapacity)];
        int i = Long.numberOfLeadingZeros(newIndex);
        int newO = Long.bitCount(newIndex) - 1;
        while (i < 64) {
            int bitIndex = 63 - i;
            assert (newO == Long.bitCount(newIndex & (1L << bitIndex) - 1L));
            newBits[newO] = this.longBits(currentIndex, currentBits, bitIndex) | this.longBits(index2, bits2, bitIndex);
            i += 1 + Long.numberOfLeadingZeros(newIndex << i + 1);
            --newO;
        }
        this.indices[i4096] = newIndex;
        this.bits[i4096] = newBits;
        this.nonZeroLongCount += nonZeroLongCount - Long.bitCount(currentIndex & index2);
    }

    private void or(SparseFixedBitSet other) {
        for (int i = 0; i < other.indices.length; ++i) {
            long index2 = other.indices[i];
            if (index2 == 0L) continue;
            this.or(i, index2, other.bits[i], Long.bitCount(index2));
        }
    }

    private void orDense(DocIdSetIterator it) throws IOException {
        this.checkUnpositioned(it);
        int firstDoc = it.nextDoc();
        if (firstDoc == Integer.MAX_VALUE) {
            return;
        }
        int i4096 = firstDoc >>> 12;
        int i64 = firstDoc >>> 6;
        long index2 = 1L << i64;
        long currentLong = 1L << firstDoc;
        long[] longs = new long[64];
        int numLongs = 0;
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int doc64 = doc >>> 6;
            if (doc64 == i64) {
                currentLong |= 1L << doc;
            } else {
                longs[numLongs++] = currentLong;
                int doc4096 = doc >>> 12;
                if (doc4096 == i4096) {
                    index2 |= 1L << doc64;
                } else {
                    this.or(i4096, index2, longs, numLongs);
                    i4096 = doc4096;
                    index2 = 1L << doc64;
                    numLongs = 0;
                }
                i64 = doc64;
                currentLong = 1L << doc;
            }
            doc = it.nextDoc();
        }
        longs[numLongs++] = currentLong;
        this.or(i4096, index2, longs, numLongs);
    }

    @Override
    public void or(DocIdSetIterator it) throws IOException {
        SparseFixedBitSet other = BitSetIterator.getSparseFixedBitSetOrNull(it);
        if (other != null) {
            this.checkUnpositioned(it);
            this.or(other);
            return;
        }
        if (it.cost() < (long)this.indices.length) {
            super.or(it);
        } else {
            this.orDense(it);
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public String toString() {
        return "SparseFixedBitSet(size=" + this.length + ",cardinality=~" + this.approximateCardinality();
    }
}

