/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public abstract class Sorter {
    static final int BINARY_SORT_THRESHOLD = 20;
    private int pivotIndex;

    protected Sorter() {
    }

    protected abstract int compare(int var1, int var2);

    protected abstract void swap(int var1, int var2);

    protected void setPivot(int i) {
        this.pivotIndex = i;
    }

    protected int comparePivot(int j) {
        return this.compare(this.pivotIndex, j);
    }

    public abstract void sort(int var1, int var2);

    void checkRange(int from2, int to2) {
        if (to2 < from2) {
            throw new IllegalArgumentException("'to' must be >= 'from', got from=" + from2 + " and to=" + to2);
        }
    }

    void mergeInPlace(int from2, int mid, int to2) {
        int len22;
        int second_cut;
        int first_cut;
        if (from2 == mid || mid == to2 || this.compare(mid - 1, mid) <= 0) {
            return;
        }
        if (to2 - from2 == 2) {
            this.swap(mid - 1, mid);
            return;
        }
        while (this.compare(from2, mid) <= 0) {
            ++from2;
        }
        while (this.compare(mid - 1, to2 - 1) <= 0) {
            --to2;
        }
        if (mid - from2 > to2 - mid) {
            int len11 = mid - from2 >>> 1;
            first_cut = from2 + len11;
            second_cut = this.lower(mid, to2, first_cut);
            len22 = second_cut - mid;
        } else {
            len22 = to2 - mid >>> 1;
            second_cut = mid + len22;
            first_cut = this.upper(from2, mid, second_cut);
            int len11 = first_cut - from2;
        }
        this.rotate(first_cut, mid, second_cut);
        int new_mid = first_cut + len22;
        this.mergeInPlace(from2, first_cut, new_mid);
        this.mergeInPlace(new_mid, second_cut, to2);
    }

    int lower(int from2, int to2, int val) {
        int len = to2 - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compare(mid, val) < 0) {
                from2 = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from2;
    }

    int upper(int from2, int to2, int val) {
        int len = to2 - from2;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from2 + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            from2 = mid + 1;
            len = len - half - 1;
        }
        return from2;
    }

    int lower2(int from2, int to2, int val) {
        int delta;
        int t = to2;
        for (int f2 = to2 - 1; f2 > from2; f2 -= delta << 1) {
            if (this.compare(f2, val) < 0) {
                return this.lower(f2, t, val);
            }
            delta = t - f2;
            t = f2;
        }
        return this.lower(from2, t, val);
    }

    int upper2(int from2, int to2, int val) {
        int delta;
        int f2 = from2;
        for (int t = f2 + 1; t < to2; t += delta << 1) {
            if (this.compare(t, val) > 0) {
                return this.upper(f2, t, val);
            }
            delta = t - f2;
            f2 = t;
        }
        return this.upper(f2, to2, val);
    }

    final void reverse(int from2, int to2) {
        --to2;
        while (from2 < to2) {
            this.swap(from2, to2);
            ++from2;
            --to2;
        }
    }

    final void rotate(int lo2, int mid, int hi2) {
        assert (lo2 <= mid && mid <= hi2);
        if (lo2 == mid || mid == hi2) {
            return;
        }
        this.doRotate(lo2, mid, hi2);
    }

    void doRotate(int lo2, int mid, int hi2) {
        if (mid - lo2 == hi2 - mid) {
            while (mid < hi2) {
                this.swap(lo2++, mid++);
            }
        } else {
            this.reverse(lo2, mid);
            this.reverse(mid, hi2);
            this.reverse(lo2, hi2);
        }
    }

    void binarySort(int from2, int to2) {
        this.binarySort(from2, to2, from2 + 1);
    }

    void binarySort(int from2, int to2, int i) {
        while (i < to2) {
            this.setPivot(i);
            int l = from2;
            int h = i - 1;
            while (l <= h) {
                int mid = l + h >>> 1;
                int cmp = this.comparePivot(mid);
                if (cmp < 0) {
                    h = mid - 1;
                    continue;
                }
                l = mid + 1;
            }
            for (int j = i; j > l; --j) {
                this.swap(j - 1, j);
            }
            ++i;
        }
    }

    void heapSort(int from2, int to2) {
        if (to2 - from2 <= 1) {
            return;
        }
        this.heapify(from2, to2);
        for (int end = to2 - 1; end > from2; --end) {
            this.swap(from2, end);
            this.siftDown(from2, from2, end);
        }
    }

    void heapify(int from2, int to2) {
        for (int i = Sorter.heapParent(from2, to2 - 1); i >= from2; --i) {
            this.siftDown(i, from2, to2);
        }
    }

    void siftDown(int i, int from2, int to2) {
        int leftChild = Sorter.heapChild(from2, i);
        while (leftChild < to2) {
            int rightChild = leftChild + 1;
            if (this.compare(i, leftChild) < 0) {
                if (rightChild < to2 && this.compare(leftChild, rightChild) < 0) {
                    this.swap(i, rightChild);
                    i = rightChild;
                } else {
                    this.swap(i, leftChild);
                    i = leftChild;
                }
            } else {
                if (rightChild >= to2 || this.compare(i, rightChild) >= 0) break;
                this.swap(i, rightChild);
                i = rightChild;
            }
            leftChild = Sorter.heapChild(from2, i);
        }
    }

    static int heapParent(int from2, int i) {
        return (i - 1 - from2 >>> 1) + from2;
    }

    static int heapChild(int from2, int i) {
        return (i - from2 << 1) + 1 + from2;
    }
}

