/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.math.BigInteger;
import java.util.Arrays;

public final class NumericUtils {
    private NumericUtils() {
    }

    public static long doubleToSortableLong(double value2) {
        return NumericUtils.sortableDoubleBits(Double.doubleToLongBits(value2));
    }

    public static double sortableLongToDouble(long encoded) {
        return Double.longBitsToDouble(NumericUtils.sortableDoubleBits(encoded));
    }

    public static int floatToSortableInt(float value2) {
        return NumericUtils.sortableFloatBits(Float.floatToIntBits(value2));
    }

    public static float sortableIntToFloat(int encoded) {
        return Float.intBitsToFloat(NumericUtils.sortableFloatBits(encoded));
    }

    public static long sortableDoubleBits(long bits2) {
        return bits2 ^ bits2 >> 63 & Long.MAX_VALUE;
    }

    public static int sortableFloatBits(int bits2) {
        return bits2 ^ bits2 >> 31 & Integer.MAX_VALUE;
    }

    public static void subtract(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result2) {
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int borrow = 0;
        for (int i = end - 1; i >= start; --i) {
            int diff2 = (a[i] & 0xFF) - (b[i] & 0xFF) - borrow;
            if (diff2 < 0) {
                diff2 += 256;
                borrow = 1;
            } else {
                borrow = 0;
            }
            result2[i - start] = (byte)diff2;
        }
        if (borrow != 0) {
            throw new IllegalArgumentException("a < b");
        }
    }

    public static void add(int bytesPerDim, int dim, byte[] a, byte[] b, byte[] result2) {
        int start = dim * bytesPerDim;
        int end = start + bytesPerDim;
        int carry = 0;
        for (int i = end - 1; i >= start; --i) {
            int digitSum = (a[i] & 0xFF) + (b[i] & 0xFF) + carry;
            if (digitSum > 255) {
                digitSum -= 256;
                carry = 1;
            } else {
                carry = 0;
            }
            result2[i - start] = (byte)digitSum;
        }
        if (carry != 0) {
            throw new IllegalArgumentException("a + b overflows bytesPerDim=" + bytesPerDim);
        }
    }

    public static void intToSortableBytes(int value2, byte[] result2, int offset) {
        result2[offset] = (byte)((value2 ^= Integer.MIN_VALUE) >> 24);
        result2[offset + 1] = (byte)(value2 >> 16);
        result2[offset + 2] = (byte)(value2 >> 8);
        result2[offset + 3] = (byte)value2;
    }

    public static int sortableBytesToInt(byte[] encoded, int offset) {
        int x = (encoded[offset] & 0xFF) << 24 | (encoded[offset + 1] & 0xFF) << 16 | (encoded[offset + 2] & 0xFF) << 8 | encoded[offset + 3] & 0xFF;
        return x ^ Integer.MIN_VALUE;
    }

    public static void longToSortableBytes(long value2, byte[] result2, int offset) {
        result2[offset] = (byte)((value2 ^= Long.MIN_VALUE) >> 56);
        result2[offset + 1] = (byte)(value2 >> 48);
        result2[offset + 2] = (byte)(value2 >> 40);
        result2[offset + 3] = (byte)(value2 >> 32);
        result2[offset + 4] = (byte)(value2 >> 24);
        result2[offset + 5] = (byte)(value2 >> 16);
        result2[offset + 6] = (byte)(value2 >> 8);
        result2[offset + 7] = (byte)value2;
    }

    public static long sortableBytesToLong(byte[] encoded, int offset) {
        long v = ((long)encoded[offset] & 0xFFL) << 56 | ((long)encoded[offset + 1] & 0xFFL) << 48 | ((long)encoded[offset + 2] & 0xFFL) << 40 | ((long)encoded[offset + 3] & 0xFFL) << 32 | ((long)encoded[offset + 4] & 0xFFL) << 24 | ((long)encoded[offset + 5] & 0xFFL) << 16 | ((long)encoded[offset + 6] & 0xFFL) << 8 | (long)encoded[offset + 7] & 0xFFL;
        return v ^= Long.MIN_VALUE;
    }

    public static void bigIntToSortableBytes(BigInteger bigInt, int bigIntSize, byte[] result2, int offset) {
        byte[] fullBigIntBytes;
        byte[] bigIntBytes = bigInt.toByteArray();
        if (bigIntBytes.length < bigIntSize) {
            fullBigIntBytes = new byte[bigIntSize];
            System.arraycopy(bigIntBytes, 0, fullBigIntBytes, bigIntSize - bigIntBytes.length, bigIntBytes.length);
            if ((bigIntBytes[0] & 0x80) != 0) {
                Arrays.fill(fullBigIntBytes, 0, bigIntSize - bigIntBytes.length, (byte)-1);
            }
        } else if (bigIntBytes.length == bigIntSize) {
            fullBigIntBytes = bigIntBytes;
        } else {
            throw new IllegalArgumentException("BigInteger: " + bigInt + " requires more than " + bigIntSize + " bytes storage");
        }
        fullBigIntBytes[0] = (byte)(fullBigIntBytes[0] ^ 0x80);
        System.arraycopy(fullBigIntBytes, 0, result2, offset, bigIntSize);
        assert (NumericUtils.sortableBytesToBigInt(result2, offset, bigIntSize).equals(bigInt)) : "bigInt=" + bigInt + " converted=" + NumericUtils.sortableBytesToBigInt(result2, offset, bigIntSize);
    }

    public static BigInteger sortableBytesToBigInt(byte[] encoded, int offset, int length) {
        byte[] bigIntBytes = new byte[length];
        System.arraycopy(encoded, offset, bigIntBytes, 0, length);
        bigIntBytes[0] = (byte)(bigIntBytes[0] ^ 0x80);
        return new BigInteger(bigIntBytes);
    }
}

