/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.Sorter;

public abstract class IntroSorter
extends Sorter {
    @Override
    public final void sort(int from2, int to2) {
        this.checkRange(from2, to2);
        this.quicksort(from2, to2, 2 * MathUtil.log(to2 - from2, 2));
    }

    void quicksort(int from2, int to2, int maxDepth2) {
        if (to2 - from2 < 20) {
            this.binarySort(from2, to2);
            return;
        }
        if (--maxDepth2 < 0) {
            this.heapSort(from2, to2);
            return;
        }
        int mid = from2 + to2 >>> 1;
        if (this.compare(from2, mid) > 0) {
            this.swap(from2, mid);
        }
        if (this.compare(mid, to2 - 1) > 0) {
            this.swap(mid, to2 - 1);
            if (this.compare(from2, mid) > 0) {
                this.swap(from2, mid);
            }
        }
        int left = from2 + 1;
        int right = to2 - 2;
        this.setPivot(mid);
        while (true) {
            if (this.comparePivot(right) < 0) {
                --right;
                continue;
            }
            while (left < right && this.comparePivot(left) >= 0) {
                ++left;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.quicksort(from2, left + 1, maxDepth2);
        this.quicksort(left + 1, to2, maxDepth2);
    }

    @Override
    protected abstract void setPivot(int var1);

    @Override
    protected abstract int comparePivot(int var1);

    @Override
    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }
}

