/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.Selector;
import org.apache.lucene.util.Sorter;

public abstract class IntroSelector
extends Selector {
    @Override
    public final void select(int from2, int to2, int k) {
        this.checkArgs(from2, to2, k);
        int maxDepth2 = 2 * MathUtil.log(to2 - from2, 2);
        this.quickSelect(from2, to2, k, maxDepth2);
    }

    void slowSelect(int from2, int to2, int k) {
        new Sorter(){

            @Override
            protected void swap(int i, int j) {
                IntroSelector.this.swap(i, j);
            }

            @Override
            protected int compare(int i, int j) {
                return IntroSelector.this.compare(i, j);
            }

            @Override
            public void sort(int from2, int to2) {
                this.heapSort(from2, to2);
            }
        }.sort(from2, to2);
    }

    private void quickSelect(int from2, int to2, int k, int maxDepth2) {
        assert (from2 <= k);
        assert (k < to2);
        if (to2 - from2 == 1) {
            return;
        }
        if (--maxDepth2 < 0) {
            this.slowSelect(from2, to2, k);
            return;
        }
        int mid = from2 + to2 >>> 1;
        if (this.compare(from2, to2 - 1) > 0) {
            this.swap(from2, to2 - 1);
        }
        if (this.compare(to2 - 1, mid) > 0) {
            this.swap(to2 - 1, mid);
            if (this.compare(from2, to2 - 1) > 0) {
                this.swap(from2, to2 - 1);
            }
        }
        this.setPivot(to2 - 1);
        int left = from2 + 1;
        int right = to2 - 2;
        while (true) {
            if (this.comparePivot(left) > 0) {
                ++left;
                continue;
            }
            while (left < right && this.comparePivot(right) <= 0) {
                --right;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.swap(left, to2 - 1);
        if (left == k) {
            return;
        }
        if (left < k) {
            this.quickSelect(left + 1, to2, k, maxDepth2);
        } else {
            this.quickSelect(from2, left, k, maxDepth2);
        }
    }

    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);
}

