/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class FutureObjects {
    private FutureObjects() {
    }

    public static int checkIndex(int index2, int length) {
        if (index2 < 0 || index2 >= length) {
            throw new IndexOutOfBoundsException("Index " + index2 + " out-of-bounds for length " + length);
        }
        return index2;
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0 || fromIndex > toIndex || toIndex > length) {
            throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + toIndex + ") out-of-bounds for length " + length);
        }
        return fromIndex;
    }

    public static int checkFromIndexSize(int fromIndex, int size2, int length) {
        int end = fromIndex + size2;
        if (fromIndex < 0 || fromIndex > end || end > length) {
            throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + fromIndex + " + " + size2 + ") out-of-bounds for length " + length);
        }
        return fromIndex;
    }
}

