/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefComparator;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SortableBytesRefArray;

final class FixedLengthBytesRefArray
implements SortableBytesRefArray {
    private final int valueLength;
    private final int valuesPerBlock;
    private int size;
    private int currentBlock = -1;
    private int nextEntry;
    private byte[][] blocks;

    public FixedLengthBytesRefArray(int valueLength) {
        this.valueLength = valueLength;
        this.nextEntry = this.valuesPerBlock = Math.max(1, 32768 / valueLength);
        this.blocks = new byte[0][];
    }

    @Override
    public void clear() {
        this.size = 0;
        this.blocks = new byte[0][];
        this.currentBlock = -1;
        this.nextEntry = this.valuesPerBlock;
    }

    @Override
    public int append(BytesRef bytes2) {
        if (bytes2.length != this.valueLength) {
            throw new IllegalArgumentException("value length is " + bytes2.length + " but is supposed to always be " + this.valueLength);
        }
        if (this.nextEntry == this.valuesPerBlock) {
            ++this.currentBlock;
            if (this.currentBlock == this.blocks.length) {
                int size2 = ArrayUtil.oversize(this.currentBlock + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
                byte[][] next2 = new byte[size2][];
                System.arraycopy(this.blocks, 0, next2, 0, this.blocks.length);
                this.blocks = next2;
            }
            this.blocks[this.currentBlock] = new byte[this.valuesPerBlock * this.valueLength];
            this.nextEntry = 0;
        }
        System.arraycopy(bytes2.bytes, bytes2.offset, this.blocks[this.currentBlock], this.nextEntry * this.valueLength, this.valueLength);
        ++this.nextEntry;
        return this.size++;
    }

    @Override
    public int size() {
        return this.size;
    }

    private int[] sort(final Comparator<BytesRef> comp) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        if (comp instanceof BytesRefComparator) {
            final BytesRefComparator bComp = (BytesRefComparator)comp;
            new MSBRadixSorter(bComp.comparedBytesCount){
                BytesRef scratch;
                {
                    super(maxLength);
                    this.scratch = new BytesRef();
                    this.scratch.length = FixedLengthBytesRefArray.this.valueLength;
                }

                @Override
                protected void swap(int i, int j) {
                    int o = orderedEntries[i];
                    orderedEntries[i] = orderedEntries[j];
                    orderedEntries[j] = o;
                }

                @Override
                protected int byteAt(int i, int k) {
                    int index1 = orderedEntries[i];
                    this.scratch.bytes = FixedLengthBytesRefArray.this.blocks[index1 / FixedLengthBytesRefArray.this.valuesPerBlock];
                    this.scratch.offset = index1 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                    return bComp.byteAt(this.scratch, k);
                }
            }.sort(0, this.size());
            return orderedEntries;
        }
        final BytesRef pivot = new BytesRef();
        final BytesRef scratch1 = new BytesRef();
        final BytesRef scratch2 = new BytesRef();
        pivot.length = this.valueLength;
        scratch1.length = this.valueLength;
        scratch2.length = this.valueLength;
        new IntroSorter(){

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            @Override
            protected int compare(int i, int j) {
                int index1 = orderedEntries[i];
                scratch1.bytes = FixedLengthBytesRefArray.this.blocks[index1 / FixedLengthBytesRefArray.this.valuesPerBlock];
                scratch1.offset = index1 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                int index2 = orderedEntries[j];
                scratch2.bytes = FixedLengthBytesRefArray.this.blocks[index2 / FixedLengthBytesRefArray.this.valuesPerBlock];
                scratch2.offset = index2 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                return comp.compare(scratch1, scratch2);
            }

            @Override
            protected void setPivot(int i) {
                int index2 = orderedEntries[i];
                pivot.bytes = FixedLengthBytesRefArray.this.blocks[index2 / FixedLengthBytesRefArray.this.valuesPerBlock];
                pivot.offset = index2 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
            }

            @Override
            protected int comparePivot(int j) {
                int index2 = orderedEntries[j];
                scratch2.bytes = FixedLengthBytesRefArray.this.blocks[index2 / FixedLengthBytesRefArray.this.valuesPerBlock];
                scratch2.offset = index2 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                return comp.compare(pivot, scratch2);
            }
        }.sort(0, this.size());
        return orderedEntries;
    }

    @Override
    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        final BytesRef result2 = new BytesRef();
        result2.length = this.valueLength;
        final int size2 = this.size();
        final int[] indices = this.sort(comp);
        return new BytesRefIterator(){
            int pos = 0;

            @Override
            public BytesRef next() {
                if (this.pos < size2) {
                    int index2 = indices[this.pos];
                    ++this.pos;
                    result2.bytes = FixedLengthBytesRefArray.this.blocks[index2 / FixedLengthBytesRefArray.this.valuesPerBlock];
                    result2.offset = index2 % FixedLengthBytesRefArray.this.valuesPerBlock * FixedLengthBytesRefArray.this.valueLength;
                    return result2;
                }
                return null;
            }
        };
    }
}

