/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntArrayDocIdSet;
import org.apache.lucene.util.LSBRadixSorter;
import org.apache.lucene.util.packed.PackedInts;

public final class DocIdSetBuilder {
    private final int maxDoc;
    private final int threshold;
    final boolean multivalued;
    final double numValuesPerDoc;
    private List<Buffer> buffers = new ArrayList<Buffer>();
    private int totalAllocated;
    private FixedBitSet bitSet;
    private long counter = -1L;
    private BulkAdder adder;

    public DocIdSetBuilder(int maxDoc) {
        this(maxDoc, -1, -1L);
    }

    public DocIdSetBuilder(int maxDoc, Terms terms) throws IOException {
        this(maxDoc, terms.getDocCount(), terms.getSumDocFreq());
    }

    public DocIdSetBuilder(int maxDoc, PointValues values2, String field2) throws IOException {
        this(maxDoc, values2.getDocCount(), values2.size());
    }

    DocIdSetBuilder(int maxDoc, int docCount, long valueCount) {
        this.maxDoc = maxDoc;
        this.multivalued = docCount < 0 || (long)docCount != valueCount;
        this.numValuesPerDoc = docCount <= 0 || valueCount < 0L ? 1.0 : (double)valueCount / (double)docCount;
        assert (this.numValuesPerDoc >= 1.0) : "valueCount=" + valueCount + " docCount=" + docCount;
        this.threshold = maxDoc >>> 7;
        this.bitSet = null;
    }

    public void add(DocIdSetIterator iter2) throws IOException {
        if (this.bitSet != null) {
            this.bitSet.or(iter2);
            return;
        }
        int cost = (int)Math.min(Integer.MAX_VALUE, iter2.cost());
        BulkAdder adder = this.grow(cost);
        for (int i = 0; i < cost; ++i) {
            int doc = iter2.nextDoc();
            if (doc == Integer.MAX_VALUE) {
                return;
            }
            adder.add(doc);
        }
        int doc = iter2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.grow(1).add(doc);
            doc = iter2.nextDoc();
        }
    }

    public BulkAdder grow(int numDocs) {
        if (this.bitSet == null) {
            if ((long)this.totalAllocated + (long)numDocs <= (long)this.threshold) {
                this.ensureBufferCapacity(numDocs);
            } else {
                this.upgradeToBitSet();
                this.counter += (long)numDocs;
            }
        } else {
            this.counter += (long)numDocs;
        }
        return this.adder;
    }

    private void ensureBufferCapacity(int numDocs) {
        if (this.buffers.isEmpty()) {
            this.addBuffer(this.additionalCapacity(numDocs));
            return;
        }
        Buffer current = this.buffers.get(this.buffers.size() - 1);
        if (current.array.length - current.length >= numDocs) {
            return;
        }
        if (current.length < current.array.length - (current.array.length >>> 3)) {
            this.growBuffer(current, this.additionalCapacity(numDocs));
        } else {
            this.addBuffer(this.additionalCapacity(numDocs));
        }
    }

    private int additionalCapacity(int numDocs) {
        int c = this.totalAllocated;
        c = Math.max(numDocs + 1, c);
        c = Math.max(32, c);
        c = Math.min(this.threshold - this.totalAllocated, c);
        return c;
    }

    private Buffer addBuffer(int len) {
        Buffer buffer = new Buffer(len);
        this.buffers.add(buffer);
        this.adder = new BufferAdder(buffer);
        this.totalAllocated += buffer.array.length;
        return buffer;
    }

    private void growBuffer(Buffer buffer, int additionalCapacity) {
        buffer.array = Arrays.copyOf(buffer.array, buffer.array.length + additionalCapacity);
        this.totalAllocated += additionalCapacity;
    }

    private void upgradeToBitSet() {
        assert (this.bitSet == null);
        FixedBitSet bitSet = new FixedBitSet(this.maxDoc);
        long counter = 0L;
        for (Buffer buffer : this.buffers) {
            int[] array = buffer.array;
            int length = buffer.length;
            counter += (long)length;
            for (int i = 0; i < length; ++i) {
                bitSet.set(array[i]);
            }
        }
        this.bitSet = bitSet;
        this.counter = counter;
        this.buffers = null;
        this.adder = new FixedBitSetAdder(bitSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet build() {
        try {
            int l;
            if (this.bitSet != null) {
                assert (this.counter >= 0L);
                long cost = Math.round((double)this.counter / this.numValuesPerDoc);
                BitDocIdSet bitDocIdSet = new BitDocIdSet(this.bitSet, cost);
                return bitDocIdSet;
            }
            Buffer concatenated = DocIdSetBuilder.concat(this.buffers);
            LSBRadixSorter sorter = new LSBRadixSorter();
            sorter.sort(PackedInts.bitsRequired(this.maxDoc - 1), concatenated.array, concatenated.length);
            if (this.multivalued) {
                l = DocIdSetBuilder.dedup(concatenated.array, concatenated.length);
            } else {
                assert (DocIdSetBuilder.noDups(concatenated.array, concatenated.length));
                l = concatenated.length;
            }
            assert (l <= concatenated.length);
            concatenated.array[l] = Integer.MAX_VALUE;
            IntArrayDocIdSet intArrayDocIdSet = new IntArrayDocIdSet(concatenated.array, l);
            return intArrayDocIdSet;
        }
        finally {
            this.buffers = null;
            this.bitSet = null;
        }
    }

    private static Buffer concat(List<Buffer> buffers) {
        int totalLength = 0;
        Buffer largestBuffer = null;
        for (Buffer buffer : buffers) {
            totalLength += buffer.length;
            if (largestBuffer != null && buffer.array.length <= largestBuffer.array.length) continue;
            largestBuffer = buffer;
        }
        if (largestBuffer == null) {
            return new Buffer(1);
        }
        int[] docs = largestBuffer.array;
        if (docs.length < totalLength + 1) {
            docs = Arrays.copyOf(docs, totalLength + 1);
        }
        totalLength = largestBuffer.length;
        for (Buffer buffer : buffers) {
            if (buffer == largestBuffer) continue;
            System.arraycopy(buffer.array, 0, docs, totalLength, buffer.length);
            totalLength += buffer.length;
        }
        return new Buffer(docs, totalLength);
    }

    private static int dedup(int[] arr, int length) {
        if (length == 0) {
            return 0;
        }
        int l = 1;
        int previous = arr[0];
        for (int i = 1; i < length; ++i) {
            int value2 = arr[i];
            assert (value2 >= previous);
            if (value2 == previous) continue;
            arr[l++] = value2;
            previous = value2;
        }
        return l;
    }

    private static boolean noDups(int[] a, int len) {
        for (int i = 1; i < len; ++i) {
            assert (a[i - 1] < a[i]);
        }
        return true;
    }

    private static class BufferAdder
    extends BulkAdder {
        final Buffer buffer;

        BufferAdder(Buffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void add(int doc) {
            this.buffer.array[this.buffer.length++] = doc;
        }
    }

    private static class Buffer {
        int[] array;
        int length;

        Buffer(int length) {
            this.array = new int[length];
            this.length = 0;
        }

        Buffer(int[] array, int length) {
            this.array = array;
            this.length = length;
        }
    }

    private static class FixedBitSetAdder
    extends BulkAdder {
        final FixedBitSet bitSet;

        FixedBitSetAdder(FixedBitSet bitSet) {
            this.bitSet = bitSet;
        }

        @Override
        public void add(int doc) {
            this.bitSet.set(doc);
        }
    }

    public static abstract class BulkAdder {
        public abstract void add(int var1);
    }
}

