/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.RandomAccessInput;

public abstract class IndexInput
extends DataInput
implements Cloneable,
Closeable {
    private final String resourceDescription;

    protected IndexInput(String resourceDescription) {
        if (resourceDescription == null) {
            throw new IllegalArgumentException("resourceDescription must not be null");
        }
        this.resourceDescription = resourceDescription;
    }

    @Override
    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    public abstract long length();

    public String toString() {
        return this.resourceDescription;
    }

    @Override
    public IndexInput clone() {
        return (IndexInput)super.clone();
    }

    public abstract IndexInput slice(String var1, long var2, long var4) throws IOException;

    protected String getFullSliceDescription(String sliceDescription) {
        if (sliceDescription == null) {
            return this.toString();
        }
        return this.toString() + " [slice=" + sliceDescription + "]";
    }

    public RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        final IndexInput slice2 = this.slice("randomaccess", offset, length);
        if (slice2 instanceof RandomAccessInput) {
            return (RandomAccessInput)((Object)slice2);
        }
        return new RandomAccessInput(){

            @Override
            public byte readByte(long pos) throws IOException {
                slice2.seek(pos);
                return slice2.readByte();
            }

            @Override
            public short readShort(long pos) throws IOException {
                slice2.seek(pos);
                return slice2.readShort();
            }

            @Override
            public int readInt(long pos) throws IOException {
                slice2.seek(pos);
                return slice2.readInt();
            }

            @Override
            public long readLong(long pos) throws IOException {
                slice2.seek(pos);
                return slice2.readLong();
            }

            public String toString() {
                return "RandomAccessInput(" + IndexInput.this.toString() + ")";
            }
        };
    }
}

