/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.NearSpansOrdered;
import org.apache.lucene.search.spans.NearSpansUnordered;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public class SpanNearQuery
extends SpanQuery
implements Cloneable {
    protected List<SpanQuery> clauses;
    protected int slop;
    protected boolean inOrder;
    protected String field;

    public static Builder newOrderedNearQuery(String field2) {
        return new Builder(field2, true);
    }

    public static Builder newUnorderedNearQuery(String field2) {
        return new Builder(field2, false);
    }

    public SpanNearQuery(SpanQuery[] clausesIn, int slop, boolean inOrder) {
        this.clauses = new ArrayList<SpanQuery>(clausesIn.length);
        for (SpanQuery clause : clausesIn) {
            if (this.field == null) {
                this.field = clause.getField();
            } else if (clause.getField() != null && !clause.getField().equals(this.field)) {
                throw new IllegalArgumentException("Clauses must have same field.");
            }
            this.clauses.add(clause);
        }
        this.slop = slop;
        this.inOrder = inOrder;
    }

    public SpanQuery[] getClauses() {
        return this.clauses.toArray(new SpanQuery[this.clauses.size()]);
    }

    public int getSlop() {
        return this.slop;
    }

    public boolean isInOrder() {
        return this.inOrder;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("spanNear([");
        Iterator<SpanQuery> i = this.clauses.iterator();
        while (i.hasNext()) {
            SpanQuery clause = i.next();
            buffer.append(clause.toString(field2));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("], ");
        buffer.append(this.slop);
        buffer.append(", ");
        buffer.append(this.inOrder);
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        ArrayList<SpanWeight> subWeights = new ArrayList<SpanWeight>();
        for (SpanQuery q : this.clauses) {
            subWeights.add(q.createWeight(searcher, false, boost));
        }
        return new SpanNearWeight(subWeights, searcher, needsScores ? SpanNearQuery.getTermContexts(subWeights) : null, boost);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        boolean actuallyRewritten = false;
        ArrayList<SpanQuery> rewrittenClauses = new ArrayList<SpanQuery>();
        for (int i = 0; i < this.clauses.size(); ++i) {
            SpanQuery c = this.clauses.get(i);
            SpanQuery query = (SpanQuery)c.rewrite(reader);
            actuallyRewritten |= query != c;
            rewrittenClauses.add(query);
        }
        if (actuallyRewritten) {
            try {
                SpanNearQuery rewritten = (SpanNearQuery)this.clone();
                rewritten.clauses = rewrittenClauses;
                return rewritten;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SpanNearQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(SpanNearQuery other) {
        return this.inOrder == other.inOrder && this.slop == other.slop && this.clauses.equals(other.clauses);
    }

    @Override
    public int hashCode() {
        int result2 = this.classHash();
        result2 ^= this.clauses.hashCode();
        int fac = 1 + (this.inOrder ? 8 : 4);
        return fac * (result2 += this.slop);
    }

    static class GapSpans
    extends Spans {
        int doc = -1;
        int pos = -1;
        final int width;

        GapSpans(int width) {
            this.width = width;
        }

        @Override
        public int nextStartPosition() throws IOException {
            return ++this.pos;
        }

        public int skipToPosition(int position2) throws IOException {
            this.pos = position2;
            return this.pos;
        }

        @Override
        public int startPosition() {
            return this.pos;
        }

        @Override
        public int endPosition() {
            return this.pos + this.width;
        }

        @Override
        public int width() {
            return this.width;
        }

        @Override
        public void collect(SpanCollector collector) throws IOException {
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            this.pos = -1;
            return ++this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.pos = -1;
            this.doc = target;
            return this.doc;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public float positionsCost() {
            return 0.0f;
        }
    }

    private static class SpanGapQuery
    extends SpanQuery {
        private final String field;
        private final int width;

        public SpanGapQuery(String field2, int width) {
            this.field = field2;
            this.width = width;
        }

        @Override
        public String getField() {
            return this.field;
        }

        @Override
        public String toString(String field2) {
            return "SpanGap(" + field2 + ":" + this.width + ")";
        }

        @Override
        public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
            return new SpanGapWeight(searcher, boost);
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((SpanGapQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(SpanGapQuery other) {
            return this.width == other.width && this.field.equals(other.field);
        }

        @Override
        public int hashCode() {
            int result2 = this.classHash();
            return (result2 -= 7 * this.width) * 15 - this.field.hashCode();
        }

        private class SpanGapWeight
        extends SpanWeight {
            SpanGapWeight(IndexSearcher searcher, float boost) throws IOException {
                super(SpanGapQuery.this, searcher, null, boost);
            }

            @Override
            public void extractTermContexts(Map<Term, TermContext> contexts) {
            }

            @Override
            public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
                return new GapSpans(SpanGapQuery.this.width);
            }

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        }
    }

    public class SpanNearWeight
    extends SpanWeight {
        final List<SpanWeight> subWeights;

        public SpanNearWeight(List<SpanWeight> subWeights, IndexSearcher searcher, Map<Term, TermContext> terms, float boost) throws IOException {
            super(SpanNearQuery.this, searcher, terms, boost);
            this.subWeights = subWeights;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            for (SpanWeight w : this.subWeights) {
                w.extractTermContexts(contexts);
            }
        }

        @Override
        public Spans getSpans(LeafReaderContext context, SpanWeight.Postings requiredPostings) throws IOException {
            Terms terms = context.reader().terms(this.field);
            if (terms == null) {
                return null;
            }
            ArrayList<Spans> subSpans = new ArrayList<Spans>(SpanNearQuery.this.clauses.size());
            for (SpanWeight w : this.subWeights) {
                Spans subSpan = w.getSpans(context, requiredPostings);
                if (subSpan != null) {
                    subSpans.add(subSpan);
                    continue;
                }
                return null;
            }
            return !SpanNearQuery.this.inOrder ? new NearSpansUnordered(SpanNearQuery.this.slop, subSpans) : new NearSpansOrdered(SpanNearQuery.this.slop, subSpans);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            for (SpanWeight w : this.subWeights) {
                w.extractTerms(terms);
            }
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            for (Weight weight : this.subWeights) {
                if (weight.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Builder {
        private final boolean ordered;
        private final String field;
        private final List<SpanQuery> clauses = new LinkedList<SpanQuery>();
        private int slop;

        public Builder(String field2, boolean ordered) {
            this.field = field2;
            this.ordered = ordered;
        }

        public Builder addClause(SpanQuery clause) {
            if (!Objects.equals(clause.getField(), this.field)) {
                throw new IllegalArgumentException("Cannot add clause " + clause + " to SpanNearQuery for field " + this.field);
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder addGap(int width) {
            if (!this.ordered) {
                throw new IllegalArgumentException("Gaps can only be added to ordered near queries");
            }
            this.clauses.add(new SpanGapQuery(this.field, width));
            return this;
        }

        public Builder setSlop(int slop) {
            this.slop = slop;
            return this;
        }

        public SpanNearQuery build() {
            return new SpanNearQuery(this.clauses.toArray(new SpanQuery[this.clauses.size()]), this.slop, this.ordered);
        }
    }
}

