/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.Distribution;
import org.apache.lucene.search.similarities.Lambda;
import org.apache.lucene.search.similarities.Normalization;
import org.apache.lucene.search.similarities.SimilarityBase;

public class IBSimilarity
extends SimilarityBase {
    protected final Distribution distribution;
    protected final Lambda lambda;
    protected final Normalization normalization;

    public IBSimilarity(Distribution distribution, Lambda lambda, Normalization normalization) {
        this.distribution = distribution;
        this.lambda = lambda;
        this.normalization = normalization;
    }

    @Override
    protected float score(BasicStats stats, float freq2, float docLen) {
        return stats.getBoost() * this.distribution.score(stats, this.normalization.tfn(stats, freq2, docLen), this.lambda.lambda(stats));
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, int doc, float freq2, float docLen) {
        if (stats.getBoost() != 1.0f) {
            subs.add(Explanation.match(stats.getBoost(), "boost", new Explanation[0]));
        }
        Explanation normExpl = this.normalization.explain(stats, freq2, docLen);
        Explanation lambdaExpl = this.lambda.explain(stats);
        subs.add(normExpl);
        subs.add(lambdaExpl);
        subs.add(this.distribution.explain(stats, normExpl.getValue(), lambdaExpl.getValue()));
    }

    @Override
    public String toString() {
        return "IB " + this.distribution.toString() + "-" + this.lambda.toString() + this.normalization.toString();
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Lambda getLambda() {
        return this.lambda;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }
}

