/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.io.IOException;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

public class BooleanSimilarity
extends Similarity {
    private static final Similarity BM25_SIM = new BM25Similarity();

    @Override
    public long computeNorm(FieldInvertState state) {
        return BM25_SIM.computeNorm(state);
    }

    @Override
    public Similarity.SimWeight computeWeight(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        return new BooleanWeight(boost);
    }

    @Override
    public Similarity.SimScorer simScorer(Similarity.SimWeight weight, LeafReaderContext context) throws IOException {
        final float boost = ((BooleanWeight)weight).boost;
        return new Similarity.SimScorer(){

            @Override
            public float score(int doc, float freq2) throws IOException {
                return boost;
            }

            @Override
            public Explanation explain(int doc, Explanation freq2) throws IOException {
                Explanation queryBoostExpl = Explanation.match(boost, "query boost", new Explanation[0]);
                return Explanation.match(queryBoostExpl.getValue(), "score(" + this.getClass().getSimpleName() + ", doc=" + doc + "), computed from:", queryBoostExpl);
            }

            @Override
            public float computeSlopFactor(int distance) {
                return 1.0f;
            }

            @Override
            public float computePayloadFactor(int doc, int start, int end, BytesRef payload) {
                return 1.0f;
            }
        };
    }

    private static class BooleanWeight
    extends Similarity.SimWeight {
        final float boost;

        BooleanWeight(float boost) {
            this.boost = boost;
        }
    }
}

