/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.similarities.Axiomatic;
import org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF3LOG
extends Axiomatic {
    public AxiomaticF3LOG(float s2, int queryLen) {
        super(s2, queryLen);
    }

    @Override
    public String toString() {
        return "F3LOG";
    }

    @Override
    protected float tf(BasicStats stats, float freq2, float docLen) {
        if ((double)freq2 <= 0.0) {
            return 0.0f;
        }
        return (float)(1.0 + Math.log(1.0 + Math.log(freq2)));
    }

    @Override
    protected float ln(BasicStats stats, float freq2, float docLen) {
        return 1.0f;
    }

    @Override
    protected float tfln(BasicStats stats, float freq2, float docLen) {
        return 1.0f;
    }

    @Override
    protected float idf(BasicStats stats, float freq2, float docLen) {
        return (float)Math.log(((double)stats.getNumberOfDocuments() + 1.0) / (double)stats.getDocFreq());
    }

    @Override
    protected float gamma(BasicStats stats, float freq2, float docLen) {
        return (docLen - (float)this.queryLen) * this.s * (float)this.queryLen / stats.getAvgFieldLength();
    }
}

