/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.intervals.IntervalFilter;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;

class LowpassIntervalsSource
extends IntervalsSource {
    final IntervalsSource in;
    private final int maxWidth;

    LowpassIntervalsSource(IntervalsSource in, int maxWidth2) {
        this.in = in;
        this.maxWidth = maxWidth2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowpassIntervalsSource that = (LowpassIntervalsSource)o;
        return this.maxWidth == that.maxWidth && Objects.equals(this.in, that.in);
    }

    @Override
    public String toString() {
        return "MAXWIDTH/" + this.maxWidth + "(" + this.in + ")";
    }

    @Override
    public void extractTerms(String field2, Set<Term> terms) {
        this.in.extractTerms(field2, terms);
    }

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        final IntervalIterator i = this.in.intervals(field2, ctx);
        if (i == null) {
            return null;
        }
        return new IntervalFilter(i){

            @Override
            protected boolean accept() {
                return i.end() - i.start() + 1 <= LowpassIntervalsSource.this.maxWidth;
            }
        };
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.in, this.maxWidth);
    }
}

