/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalScorer;
import org.apache.lucene.search.intervals.IntervalsSource;
import org.apache.lucene.search.similarities.Similarity;

public final class IntervalQuery
extends Query {
    private final String field;
    private final IntervalsSource intervalsSource;

    public IntervalQuery(String field2, IntervalsSource intervalsSource) {
        this.field = field2;
        this.intervalsSource = intervalsSource;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public String toString(String field2) {
        return this.intervalsSource.toString();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new IntervalWeight(this, needsScores ? this.buildSimScorer(searcher, needsScores, boost) : null, searcher.getSimilarity(needsScores), needsScores);
    }

    private Similarity.SimWeight buildSimScorer(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        HashSet<Term> terms = new HashSet<Term>();
        this.intervalsSource.extractTerms(this.field, terms);
        TermStatistics[] termStats = new TermStatistics[terms.size()];
        int termUpTo = 0;
        for (Term term : terms) {
            TermStatistics termStatistics = searcher.termStatistics(term, TermContext.build(searcher.getTopReaderContext(), term));
            if (termStatistics == null) continue;
            termStats[termUpTo++] = termStatistics;
        }
        if (termUpTo == 0) {
            return null;
        }
        CollectionStatistics collectionStats = searcher.collectionStatistics(this.field);
        return searcher.getSimilarity(needsScores).computeWeight(boost, collectionStats, Arrays.copyOf(termStats, termUpTo));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalQuery that = (IntervalQuery)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.intervalsSource, that.intervalsSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.intervalsSource);
    }

    private class IntervalWeight
    extends Weight {
        final Similarity.SimWeight simWeight;
        final Similarity similarity;
        final boolean needsScores;

        public IntervalWeight(Query query, Similarity.SimWeight simWeight, Similarity similarity, boolean needsScores) {
            super(query);
            this.simWeight = simWeight;
            this.similarity = similarity;
            this.needsScores = needsScores;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            IntervalQuery.this.intervalsSource.extractTerms(IntervalQuery.this.field, terms);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            IntervalScorer scorer = (IntervalScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                return scorer.explain("weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "]");
            }
            return Explanation.noMatch("no matching intervals", new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            IntervalIterator intervals = IntervalQuery.this.intervalsSource.intervals(IntervalQuery.this.field, context);
            if (intervals == null) {
                return null;
            }
            Similarity.SimScorer leafScorer = this.simWeight == null ? null : this.similarity.simScorer(this.simWeight, context);
            return new IntervalScorer(this, intervals, leafScorer);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

