/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.intervals.DifferenceIntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalsSource;

class DifferenceIntervalsSource
extends IntervalsSource {
    final IntervalsSource minuend;
    final IntervalsSource subtrahend;
    final DifferenceIntervalFunction function;

    public DifferenceIntervalsSource(IntervalsSource minuend, IntervalsSource subtrahend, DifferenceIntervalFunction function) {
        this.minuend = minuend;
        this.subtrahend = subtrahend;
        this.function = function;
    }

    @Override
    public IntervalIterator intervals(String field2, LeafReaderContext ctx) throws IOException {
        IntervalIterator minIt = this.minuend.intervals(field2, ctx);
        if (minIt == null) {
            return null;
        }
        IntervalIterator subIt = this.subtrahend.intervals(field2, ctx);
        if (subIt == null) {
            return minIt;
        }
        return this.function.apply(minIt, subIt);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DifferenceIntervalsSource that = (DifferenceIntervalsSource)o;
        return Objects.equals(this.minuend, that.minuend) && Objects.equals(this.subtrahend, that.subtrahend) && Objects.equals(this.function, that.function);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minuend, this.subtrahend, this.function);
    }

    @Override
    public String toString() {
        return this.function + "(" + this.minuend + ", " + this.subtrahend + ")";
    }

    @Override
    public void extractTerms(String field2, Set<Term> terms) {
        this.minuend.extractTerms(field2, terms);
    }
}

