/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.CollectionUtil;

final class ConjunctionDISI
extends DocIdSetIterator {
    final DocIdSetIterator lead1;
    final DocIdSetIterator lead2;
    final DocIdSetIterator[] others;

    public static DocIdSetIterator intersectIterators(List<? extends DocIdSetIterator> iterators) {
        if (iterators.size() < 2) {
            throw new IllegalArgumentException("Cannot make a ConjunctionDISI of less than 2 iterators");
        }
        ArrayList<DocIdSetIterator> allIterators = new ArrayList<DocIdSetIterator>();
        for (DocIdSetIterator docIdSetIterator : iterators) {
            ConjunctionDISI.addIterator(docIdSetIterator, allIterators);
        }
        return new ConjunctionDISI(allIterators);
    }

    private static void addIterator(DocIdSetIterator disi, List<DocIdSetIterator> allIterators) {
        if (disi.getClass() == ConjunctionDISI.class) {
            ConjunctionDISI conjunction = (ConjunctionDISI)disi;
            allIterators.add(conjunction.lead1);
            allIterators.add(conjunction.lead2);
            Collections.addAll(allIterators, conjunction.others);
        } else {
            allIterators.add(disi);
        }
    }

    private ConjunctionDISI(List<? extends DocIdSetIterator> iterators) {
        assert (iterators.size() >= 2);
        CollectionUtil.timSort(iterators, Comparator.comparingLong(DocIdSetIterator::cost));
        this.lead1 = iterators.get(0);
        this.lead2 = iterators.get(1);
        this.others = iterators.subList(2, iterators.size()).toArray(new DocIdSetIterator[0]);
    }

    private int doNext(int doc) throws IOException {
        block0: while (true) {
            assert (doc == this.lead1.docID());
            int next2 = this.lead2.advance(doc);
            if (next2 != doc && next2 != (doc = this.lead1.advance(next2))) continue;
            for (DocIdSetIterator other : this.others) {
                int next3;
                if (other.docID() >= doc || (next3 = other.advance(doc)) <= doc) continue;
                doc = this.lead1.advance(next3);
                continue block0;
            }
            break;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        return this.doNext(this.lead1.advance(target));
    }

    @Override
    public int docID() {
        return this.lead1.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.doNext(this.lead1.nextDoc());
    }

    @Override
    public long cost() {
        return this.lead1.cost();
    }
}

