/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhrasePositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PhraseQueue;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.FixedBitSet;

final class SloppyPhraseMatcher
extends PhraseMatcher {
    private final PhrasePositions[] phrasePositions;
    private final int slop;
    private final int numPostings;
    private final PhraseQueue pq;
    private int end;
    private int leadPosition;
    private int leadOffset;
    private int currentEndPostings;
    private int advanceEndPostings;
    private boolean hasRpts;
    private boolean checkedRpts;
    private boolean hasMultiTermRpts;
    private PhrasePositions[][] rptGroups;
    private PhrasePositions[] rptStack;
    private boolean positioned;
    private int matchLength;

    SloppyPhraseMatcher(PhraseQuery.PostingsAndFreq[] postings, int slop, float matchCost) {
        super(SloppyPhraseMatcher.approximation(postings), matchCost);
        this.slop = slop;
        this.numPostings = postings.length;
        this.pq = new PhraseQueue(postings.length);
        this.phrasePositions = new PhrasePositions[postings.length];
        for (int i = 0; i < postings.length; ++i) {
            this.phrasePositions[i] = new PhrasePositions(postings[i].postings, postings[i].position, i, postings[i].terms);
        }
    }

    private static DocIdSetIterator approximation(PhraseQuery.PostingsAndFreq[] postings) {
        ArrayList<DocIdSetIterator> iterators = new ArrayList<DocIdSetIterator>();
        for (PhraseQuery.PostingsAndFreq posting : postings) {
            iterators.add(posting.postings);
        }
        return ConjunctionDISI.intersectIterators(iterators);
    }

    @Override
    float maxFreq() throws IOException {
        float maxFreq = 0.0f;
        for (PhrasePositions phrasePosition : this.phrasePositions) {
            maxFreq += (float)phrasePosition.postings.freq();
        }
        return maxFreq;
    }

    @Override
    public void reset() throws IOException {
        this.positioned = this.initPhrasePositions();
        this.matchLength = Integer.MAX_VALUE;
        this.leadPosition = Integer.MAX_VALUE;
    }

    @Override
    float sloppyWeight(Similarity.SimScorer simScorer) {
        return simScorer.computeSlopFactor(this.matchLength);
    }

    @Override
    public boolean nextMatch() throws IOException {
        if (!this.positioned) {
            return false;
        }
        PhrasePositions pp2 = (PhrasePositions)this.pq.pop();
        assert (pp2 != null);
        this.leadPosition = pp2.position + pp2.offset;
        this.leadOffset = pp2.postings.startOffset();
        this.currentEndPostings = this.advanceEndPostings;
        this.matchLength = this.end - pp2.position;
        int next2 = ((PhrasePositions)this.pq.top()).position;
        while (this.advancePP(pp2) && (!this.hasRpts || this.advanceRpts(pp2))) {
            if (pp2.position > next2) {
                this.pq.add(pp2);
                if (this.matchLength <= this.slop) {
                    return true;
                }
                pp2 = (PhrasePositions)this.pq.pop();
                next2 = ((PhrasePositions)this.pq.top()).position;
                this.matchLength = this.end - pp2.position;
            } else {
                int matchLength2 = this.end - pp2.position;
                if (matchLength2 < this.matchLength) {
                    this.matchLength = matchLength2;
                }
            }
            this.leadPosition = pp2.position + pp2.offset;
            this.leadOffset = pp2.postings.startOffset();
            this.currentEndPostings = this.advanceEndPostings;
        }
        this.positioned = false;
        return this.matchLength <= this.slop;
    }

    @Override
    public int startPosition() {
        for (PhrasePositions pp2 : this.phrasePositions) {
            this.leadPosition = Math.min(this.leadPosition, pp2.position + pp2.offset);
        }
        return this.leadPosition;
    }

    @Override
    public int endPosition() {
        return this.phrasePositions[this.currentEndPostings].position + this.phrasePositions[this.currentEndPostings].offset;
    }

    @Override
    public int startOffset() throws IOException {
        for (PhrasePositions pp2 : this.phrasePositions) {
            this.leadOffset = Math.min(this.leadOffset, pp2.postings.startOffset());
        }
        return this.leadOffset;
    }

    @Override
    public int endOffset() throws IOException {
        return this.phrasePositions[this.currentEndPostings].postings.endOffset();
    }

    private boolean advancePP(PhrasePositions pp2) throws IOException {
        if (!pp2.nextPosition()) {
            return false;
        }
        if (pp2.position > this.end) {
            this.end = pp2.position;
            this.advanceEndPostings = pp2.ord;
        }
        if (pp2.position == this.end && pp2.ord > this.advanceEndPostings) {
            this.advanceEndPostings = pp2.ord;
        }
        return true;
    }

    private boolean advanceRpts(PhrasePositions pp2) throws IOException {
        int k;
        if (pp2.rptGroup < 0) {
            return true;
        }
        PhrasePositions[] rg = this.rptGroups[pp2.rptGroup];
        FixedBitSet bits2 = new FixedBitSet(rg.length);
        int k0 = pp2.rptInd;
        while ((k = this.collide(pp2)) >= 0) {
            if (!this.advancePP(pp2 = this.lesser(pp2, rg[k]))) {
                return false;
            }
            if (k == k0) continue;
            bits2 = FixedBitSet.ensureCapacity(bits2, k);
            bits2.set(k);
        }
        int n = 0;
        int numBits = bits2.length();
        while (bits2.cardinality() > 0) {
            PhrasePositions pp22 = (PhrasePositions)this.pq.pop();
            this.rptStack[n++] = pp22;
            if (pp22.rptGroup < 0 || pp22.rptInd >= numBits || !bits2.get(pp22.rptInd)) continue;
            bits2.clear(pp22.rptInd);
        }
        for (int i = n - 1; i >= 0; --i) {
            this.pq.add(this.rptStack[i]);
        }
        return true;
    }

    private PhrasePositions lesser(PhrasePositions pp2, PhrasePositions pp22) {
        if (pp2.position < pp22.position || pp2.position == pp22.position && pp2.offset < pp22.offset) {
            return pp2;
        }
        return pp22;
    }

    private int collide(PhrasePositions pp2) {
        int tpPos = this.tpPos(pp2);
        PhrasePositions[] rg = this.rptGroups[pp2.rptGroup];
        for (int i = 0; i < rg.length; ++i) {
            PhrasePositions pp22 = rg[i];
            if (pp22 == pp2 || this.tpPos(pp22) != tpPos) continue;
            return pp22.rptInd;
        }
        return -1;
    }

    private boolean initPhrasePositions() throws IOException {
        this.end = Integer.MIN_VALUE;
        if (!this.checkedRpts) {
            return this.initFirstTime();
        }
        if (!this.hasRpts) {
            this.initSimple();
            return true;
        }
        return this.initComplex();
    }

    private void initSimple() throws IOException {
        this.pq.clear();
        for (PhrasePositions pp2 : this.phrasePositions) {
            pp2.firstPosition();
            if (pp2.position > this.end) {
                this.end = pp2.position;
                this.advanceEndPostings = pp2.ord;
            }
            if (pp2.position == this.end && pp2.ord > this.advanceEndPostings) {
                this.advanceEndPostings = pp2.ord;
            }
            this.pq.add(pp2);
        }
    }

    private boolean initComplex() throws IOException {
        this.placeFirstPositions();
        if (!this.advanceRepeatGroups()) {
            return false;
        }
        this.fillQueue();
        return true;
    }

    private void placeFirstPositions() throws IOException {
        for (PhrasePositions pp2 : this.phrasePositions) {
            pp2.firstPosition();
        }
    }

    private void fillQueue() {
        this.pq.clear();
        for (PhrasePositions pp2 : this.phrasePositions) {
            if (pp2.position > this.end) {
                this.end = pp2.position;
                this.advanceEndPostings = pp2.ord;
            }
            if (pp2.position == this.end && pp2.ord > this.advanceEndPostings) {
                this.advanceEndPostings = pp2.ord;
            }
            this.pq.add(pp2);
        }
    }

    private boolean advanceRepeatGroups() throws IOException {
        for (PhrasePositions[] rg : this.rptGroups) {
            if (this.hasMultiTermRpts) {
                int incr;
                block1: for (int i = 0; i < rg.length; i += incr) {
                    int k;
                    incr = 1;
                    PhrasePositions pp2 = rg[i];
                    while ((k = this.collide(pp2)) >= 0) {
                        PhrasePositions pp22 = this.lesser(pp2, rg[k]);
                        if (!this.advancePP(pp22)) {
                            return false;
                        }
                        if (pp22.rptInd >= i) continue;
                        incr = 0;
                        continue block1;
                    }
                }
                continue;
            }
            for (int j = 1; j < rg.length; ++j) {
                for (int k = 0; k < j; ++k) {
                    if (rg[j].nextPosition()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean initFirstTime() throws IOException {
        this.checkedRpts = true;
        this.placeFirstPositions();
        LinkedHashMap<Term, Integer> rptTerms = this.repeatingTerms();
        boolean bl = this.hasRpts = !rptTerms.isEmpty();
        if (this.hasRpts) {
            this.rptStack = new PhrasePositions[this.numPostings];
            ArrayList<ArrayList<PhrasePositions>> rgs = this.gatherRptGroups(rptTerms);
            this.sortRptGroups(rgs);
            if (!this.advanceRepeatGroups()) {
                return false;
            }
        }
        this.fillQueue();
        return true;
    }

    private void sortRptGroups(ArrayList<ArrayList<PhrasePositions>> rgs) {
        this.rptGroups = new PhrasePositions[rgs.size()][];
        Comparator<PhrasePositions> cmprtr = new Comparator<PhrasePositions>(){

            @Override
            public int compare(PhrasePositions pp1, PhrasePositions pp2) {
                return pp1.offset - pp2.offset;
            }
        };
        for (int i = 0; i < this.rptGroups.length; ++i) {
            PhrasePositions[] rg = rgs.get(i).toArray(new PhrasePositions[0]);
            Arrays.sort(rg, cmprtr);
            this.rptGroups[i] = rg;
            for (int j = 0; j < rg.length; ++j) {
                rg[j].rptInd = j;
            }
        }
    }

    private ArrayList<ArrayList<PhrasePositions>> gatherRptGroups(LinkedHashMap<Term, Integer> rptTerms) throws IOException {
        PhrasePositions[] rpp = this.repeatingPPs(rptTerms);
        ArrayList<ArrayList<PhrasePositions>> res = new ArrayList<ArrayList<PhrasePositions>>();
        if (!this.hasMultiTermRpts) {
            for (int i = 0; i < rpp.length; ++i) {
                PhrasePositions pp2 = rpp[i];
                if (pp2.rptGroup >= 0) continue;
                int tpPos = this.tpPos(pp2);
                for (int j = i + 1; j < rpp.length; ++j) {
                    PhrasePositions pp22 = rpp[j];
                    if (pp22.rptGroup >= 0 || pp22.offset == pp2.offset || this.tpPos(pp22) != tpPos) continue;
                    int n = pp2.rptGroup;
                    if (n < 0) {
                        pp2.rptGroup = n = res.size();
                        ArrayList<PhrasePositions> rl = new ArrayList<PhrasePositions>(2);
                        rl.add(pp2);
                        res.add(rl);
                    }
                    pp22.rptGroup = n;
                    res.get(n).add(pp22);
                }
            }
        } else {
            ArrayList tmp = new ArrayList();
            ArrayList<FixedBitSet> bb = this.ppTermsBitSets(rpp, rptTerms);
            this.unionTermGroups(bb);
            HashMap<Term, Integer> tg = this.termGroups(rptTerms, bb);
            HashSet<Integer> distinctGroupIDs = new HashSet<Integer>(tg.values());
            for (int i = 0; i < distinctGroupIDs.size(); ++i) {
                tmp.add(new HashSet());
            }
            for (PhrasePositions pp3 : rpp) {
                for (Term t : pp3.terms) {
                    if (!rptTerms.containsKey(t)) continue;
                    int g = tg.get(t);
                    ((HashSet)tmp.get(g)).add(pp3);
                    assert (pp3.rptGroup == -1 || pp3.rptGroup == g);
                    pp3.rptGroup = g;
                }
            }
            for (HashSet hashSet : tmp) {
                res.add(new ArrayList(hashSet));
            }
        }
        return res;
    }

    private final int tpPos(PhrasePositions pp2) {
        return pp2.position + pp2.offset;
    }

    private LinkedHashMap<Term, Integer> repeatingTerms() {
        LinkedHashMap<Term, Integer> tord = new LinkedHashMap<Term, Integer>();
        HashMap<Term, Integer> tcnt = new HashMap<Term, Integer>();
        for (PhrasePositions pp2 : this.phrasePositions) {
            for (Term t : pp2.terms) {
                Integer cnt0 = (Integer)tcnt.get(t);
                Integer cnt = cnt0 == null ? new Integer(1) : new Integer(1 + cnt0);
                tcnt.put(t, cnt);
                if (cnt != 2) continue;
                tord.put(t, tord.size());
            }
        }
        return tord;
    }

    private PhrasePositions[] repeatingPPs(HashMap<Term, Integer> rptTerms) {
        ArrayList<PhrasePositions> rp = new ArrayList<PhrasePositions>();
        block0: for (PhrasePositions pp2 : this.phrasePositions) {
            for (Term t : pp2.terms) {
                if (!rptTerms.containsKey(t)) continue;
                rp.add(pp2);
                this.hasMultiTermRpts |= pp2.terms.length > 1;
                continue block0;
            }
        }
        return rp.toArray(new PhrasePositions[0]);
    }

    private ArrayList<FixedBitSet> ppTermsBitSets(PhrasePositions[] rpp, HashMap<Term, Integer> tord) {
        ArrayList<FixedBitSet> bb = new ArrayList<FixedBitSet>(rpp.length);
        for (PhrasePositions pp2 : rpp) {
            FixedBitSet b = new FixedBitSet(tord.size());
            for (Term t : pp2.terms) {
                Integer ord = tord.get(t);
                if (ord == null) continue;
                b.set(ord);
            }
            bb.add(b);
        }
        return bb;
    }

    private void unionTermGroups(ArrayList<FixedBitSet> bb) {
        int incr;
        for (int i = 0; i < bb.size() - 1; i += incr) {
            incr = 1;
            int j = i + 1;
            while (j < bb.size()) {
                if (bb.get(i).intersects(bb.get(j))) {
                    bb.get(i).or(bb.get(j));
                    bb.remove(j);
                    incr = 0;
                    continue;
                }
                ++j;
            }
        }
    }

    private HashMap<Term, Integer> termGroups(LinkedHashMap<Term, Integer> tord, ArrayList<FixedBitSet> bb) throws IOException {
        HashMap<Term, Integer> tg = new HashMap<Term, Integer>();
        Term[] t = tord.keySet().toArray(new Term[0]);
        for (int i = 0; i < bb.size(); ++i) {
            FixedBitSet bits2 = bb.get(i);
            int ord = bits2.nextSetBit(0);
            while (ord != Integer.MAX_VALUE) {
                tg.put(t[ord], i);
                ord = ord + 1 >= bits2.length() ? Integer.MAX_VALUE : bits2.nextSetBit(ord + 1);
            }
        }
        return tg;
    }
}

